/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.SystemClock;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.clock.AbstractClock;
import net.time4j.scale.TimeScale;

public final class AdjustableClock
extends AbstractClock {
    private static final int MIO = 1000000;
    private static final AdjustableClock SYSTEM_CLOCK_WRAPPER = new AdjustableClock(SystemClock.INSTANCE);
    private final TimeSource<?> source;
    private final TimeUnit pulse;
    private final int offsetAmount;
    private final TimeUnit offsetUnit;

    private AdjustableClock(TimeSource<?> timeSource) {
        this(timeSource, TimeUnit.NANOSECONDS, 0, TimeUnit.NANOSECONDS);
    }

    private AdjustableClock(TimeSource<?> timeSource, TimeUnit timeUnit, int n2, TimeUnit timeUnit2) {
        this.source = timeSource;
        this.pulse = timeUnit;
        this.offsetAmount = n2;
        this.offsetUnit = timeUnit2;
    }

    public static AdjustableClock ofSystem() {
        return SYSTEM_CLOCK_WRAPPER;
    }

    public static AdjustableClock of(TimeSource<?> timeSource) {
        if (timeSource.equals(SystemClock.INSTANCE)) {
            return SYSTEM_CLOCK_WRAPPER;
        }
        if (timeSource instanceof AdjustableClock) {
            return (AdjustableClock)AdjustableClock.class.cast(timeSource);
        }
        return new AdjustableClock(timeSource);
    }

    public AdjustableClock withPulse(TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("Missing pulse.");
        }
        if (timeUnit == this.pulse) {
            return this;
        }
        return new AdjustableClock(this.source, timeUnit, this.offsetAmount, this.offsetUnit);
    }

    public AdjustableClock withOffset(int n2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("Missing offset unit.");
        }
        if (this.offsetAmount == n2 && this.offsetUnit == timeUnit) {
            return this;
        }
        return new AdjustableClock(this.source, this.pulse, n2, timeUnit);
    }

    @Override
    public Moment currentTime() {
        Moment moment = Moment.from(this.source.currentTime());
        moment = (Moment)moment.plus((long)this.offsetAmount, this.offsetUnit);
        switch (this.pulse) {
            case DAYS: {
                moment = AdjustableClock.applyPulse(moment, 86400);
                break;
            }
            case HOURS: {
                moment = AdjustableClock.applyPulse(moment, 3600);
                break;
            }
            case MINUTES: {
                moment = AdjustableClock.applyPulse(moment, 60);
                break;
            }
            case SECONDS: {
                moment = Moment.of(moment.getPosixTime(), TimeScale.POSIX);
                break;
            }
            case MILLISECONDS: {
                moment = Moment.of(moment.getPosixTime(), moment.getNanosecond() / 1000000 * 1000000, TimeScale.POSIX);
                break;
            }
            case MICROSECONDS: {
                moment = Moment.of(moment.getPosixTime(), moment.getNanosecond() / 1000 * 1000, TimeScale.POSIX);
                break;
            }
            case NANOSECONDS: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.pulse.name());
            }
        }
        return moment;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AdjustableClock) {
            AdjustableClock adjustableClock = (AdjustableClock)object;
            return this.source.equals(adjustableClock.source) && this.offsetAmount == adjustableClock.offsetAmount && this.offsetUnit == adjustableClock.offsetUnit && this.pulse == adjustableClock.pulse;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 3;
        n2 = 37 * n2 + this.source.hashCode();
        n2 = 37 * n2 + this.pulse.hashCode();
        n2 = 37 * n2 + this.offsetAmount;
        return 37 * n2 + this.offsetUnit.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdjustableClock[");
        stringBuilder.append("source=");
        stringBuilder.append(this.source);
        stringBuilder.append(",offset-amount=");
        stringBuilder.append(this.offsetAmount);
        stringBuilder.append(",offset-unit=");
        stringBuilder.append((Object)this.offsetUnit);
        stringBuilder.append(",pulse=");
        stringBuilder.append((Object)this.pulse);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static Moment applyPulse(Moment moment, int n2) {
        return Moment.of(MathUtils.floorDivide(moment.getPosixTime(), n2) * (long)n2, TimeScale.POSIX);
    }
}

