/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduVariant;

final class SPX
implements Externalizable {
    static final int HINDU_CAL = 20;
    static final int HINDU_VAR = 21;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n2) {
        this.obj = object;
        this.type = n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 20: {
                this.writeHinduCalendar(objectOutput);
                break;
            }
            case 21: {
                this.writeHinduVariant(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        byte by2 = objectInput.readByte();
        switch (by2) {
            case 20: {
                this.obj = this.readHinduCalendar(objectInput);
                break;
            }
            case 21: {
                this.obj = this.readHinduVariant(objectInput);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeHinduCalendar(ObjectOutput objectOutput) throws IOException {
        HinduCalendar hinduCalendar = (HinduCalendar)this.obj;
        objectOutput.writeUTF(hinduCalendar.getVariant());
        objectOutput.writeLong(hinduCalendar.getDaysSinceEpochUTC());
    }

    private HinduCalendar readHinduCalendar(ObjectInput objectInput) throws IOException {
        HinduVariant hinduVariant = HinduVariant.from(objectInput.readUTF());
        long l2 = objectInput.readLong();
        return hinduVariant.getCalendarSystem().transform(l2);
    }

    private void writeHinduVariant(ObjectOutput objectOutput) throws IOException {
        HinduVariant hinduVariant = (HinduVariant)this.obj;
        objectOutput.writeUTF(hinduVariant.getVariant());
    }

    private HinduVariant readHinduVariant(ObjectInput objectInput) throws IOException {
        return HinduVariant.from(objectInput.readUTF());
    }
}

