/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.util.Collections;
import java.util.List;
import net.time4j.calendar.hindu.HinduCS;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduVariant;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.EpochDays;

public enum AryaSiddhanta {
    SOLAR{

        @Override
        public HinduCS getCalendarSystem() {
            return new OldCS(true);
        }
    }
    ,
    LUNAR{

        @Override
        public HinduCS getCalendarSystem() {
            return new OldCS(false);
        }
    };

    static final String PREFIX = "AryaSiddhanta@";

    public HinduVariant variant() {
        return this == SOLAR ? HinduVariant.VAR_OLD_SOLAR : HinduVariant.VAR_OLD_LUNAR;
    }

    abstract HinduCS getCalendarSystem();

    private static class OldCS
    extends HinduCS {
        private static final double ARYA_SOLAR_YEAR = 365.25868055555554;
        private static final double ARYA_SOLAR_MONTH = 30.43822337962963;
        private static final double ARYA_LUNAR_MONTH = 29.530581807581694;

        OldCS(boolean bl2) {
            super(bl2 ? HinduVariant.VAR_OLD_SOLAR : HinduVariant.VAR_OLD_LUNAR);
        }

        @Override
        public List<CalendarEra> getEras() {
            return Collections.singletonList(HinduEra.KALI_YUGA);
        }

        @Override
        HinduCalendar create(long l2) {
            double d2 = (double)(EpochDays.RATA_DIE.transform(l2, EpochDays.UTC) - -1132959L) + 0.25;
            if (this.isSolar()) {
                int n2 = (int)Math.floor(d2 / 365.25868055555554);
                int n3 = (int)OldCS.modulo(Math.floor(d2 / 30.43822337962963), 12.0) + 1;
                int n4 = (int)Math.floor(OldCS.modulo(d2, 30.43822337962963)) + 1;
                return new HinduCalendar(this.variant, n2, HinduMonth.ofSolar(n3), HinduDay.valueOf(n4), l2);
            }
            double d3 = d2 - OldCS.modulo(d2, 29.530581807581694);
            double d4 = OldCS.modulo(d3, 30.43822337962963);
            boolean bl2 = 0.907641572047936 >= d4 && d4 > 0.0;
            int n5 = (int)(Math.ceil((d3 + 30.43822337962963) / 365.25868055555554) - 1.0);
            int n6 = (int)(OldCS.modulo(Math.ceil(d3 / 30.43822337962963), 12.0) + 1.0);
            int n7 = (int)(OldCS.modulo(Math.floor(d2 * 30.0 / 29.530581807581694), 30.0) + 1.0);
            HinduMonth hinduMonth = HinduMonth.ofLunisolar(n6);
            return new HinduCalendar(this.variant, n5, bl2 ? hinduMonth.withLeap() : hinduMonth, HinduDay.valueOf(n7), l2);
        }

        @Override
        HinduCalendar create(int n2, HinduMonth hinduMonth, HinduDay hinduDay) {
            double d2;
            if (this.isSolar()) {
                d2 = (double)n2 * 365.25868055555554 + (double)(hinduMonth.getRasi() - 1) * 30.43822337962963 + (double)hinduDay.getValue() - 1.25;
            } else {
                double d3 = (double)(12 * n2 - 1) * 30.43822337962963;
                double d4 = 29.530581807581694 * (Math.floor(d3 / 29.530581807581694) + 1.0);
                int n3 = hinduMonth.getValue().getValue();
                if (hinduMonth.isLeap() || Math.ceil((d4 - d3) / 0.907641572047936) > (double)n3) {
                    --n3;
                }
                d2 = d4 + 29.530581807581694 * (double)n3 + (double)(hinduDay.getValue() - 1) * 0.9843527269193898 - 0.25;
            }
            return new HinduCalendar(this.variant, n2, hinduMonth, hinduDay, EpochDays.UTC.transform((long)Math.ceil(-1132959.0 + d2), EpochDays.RATA_DIE));
        }

        @Override
        boolean isValid(int n2, HinduMonth hinduMonth, HinduDay hinduDay) {
            if (n2 < 0 || n2 > 5999 || hinduMonth == null || hinduDay == null) {
                return false;
            }
            if (this.isSolar() && (hinduMonth.isLeap() || hinduDay.isLeap())) {
                return false;
            }
            if (hinduDay.getValue() > (this.isSolar() ? 31 : 30)) {
                return false;
            }
            return !this.isExpunged(n2, hinduMonth, hinduDay);
        }

        @Override
        public long getMinimumSinceUTC() {
            long l2 = this.isSolar() ? -1132959L : -1132988L;
            return EpochDays.UTC.transform(l2, EpochDays.RATA_DIE);
        }

        @Override
        public long getMaximumSinceUTC() {
            return this.isSolar() ? 338699L : 338671L;
        }

        private boolean isSolar() {
            return this.variant == HinduVariant.VAR_OLD_SOLAR;
        }
    }
}

