/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.Serializable;
import net.time4j.Moment;
import net.time4j.calendar.astro.AstroUtils;
import net.time4j.calendar.astro.EquatorialCoordinates;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.astro.Zodiac;

public class SunPosition
implements EquatorialCoordinates,
Serializable {
    private static final long serialVersionUID = -3023032442869934354L;
    private final double rightAscension;
    private final double declination;
    private final double azimuth;
    private final double elevation;

    private SunPosition(double d2, double d3, double d4, double d5) {
        this.rightAscension = d2;
        this.declination = d3;
        this.azimuth = d4;
        this.elevation = d5;
    }

    public static SunPosition at(Moment moment, GeoLocation geoLocation) {
        double d2;
        JulianDay julianDay = JulianDay.ofEphemerisTime(moment);
        double d3 = julianDay.getCenturyJ2000();
        StdSolarCalculator stdSolarCalculator = StdSolarCalculator.TIME4J;
        double[] dArray = new double[2];
        StdSolarCalculator.nutations(d3, dArray);
        double d4 = dArray[0];
        double d5 = StdSolarCalculator.meanObliquity(d3) + dArray[1];
        double d6 = Math.toRadians(stdSolarCalculator.rightAscension(julianDay.getValue()));
        double d7 = Math.toRadians(stdSolarCalculator.declination(julianDay.getValue()));
        double d8 = Math.toRadians(geoLocation.getLatitude());
        double d9 = Math.toRadians(geoLocation.getLongitude());
        double d10 = Math.cos(d8);
        double d11 = Math.sin(d8);
        int n2 = geoLocation.getAltitude();
        double d12 = JulianDay.ofMeanSolarTime(moment).getMJD();
        double d13 = d4 * Math.cos(Math.toRadians(d5));
        double d14 = AstroUtils.gmst(d12) + Math.toRadians(d13) + d9 - d6;
        double d15 = d11 * Math.sin(d7) + d10 * Math.cos(d7) * Math.cos(d14);
        double d16 = Math.toDegrees(Math.asin(d15));
        double d17 = stdSolarCalculator.getGeodeticAngle(geoLocation.getLatitude(), n2);
        if (d16 >= -0.5 - d17) {
            d2 = AstroUtils.refractionFactorOfStdAtmosphere(n2);
            double d18 = d2 * AstroUtils.getRefraction(d16) / 60.0;
            d16 += d18;
        }
        d2 = Math.toDegrees(Math.atan2(Math.sin(d14), Math.cos(d14) * d11 - Math.tan(d7) * d10)) + 180.0;
        return new SunPosition(Math.toDegrees(d6), Math.toDegrees(d7), d2, d16);
    }

    public static Zodiac.Event inConstellationOf(Zodiac zodiac) {
        return Zodiac.Event.ofConstellation('S', zodiac);
    }

    public static Zodiac.Event inSignOf(Zodiac zodiac) {
        return Zodiac.Event.ofSign('S', zodiac);
    }

    @Override
    public double getRightAscension() {
        return this.rightAscension;
    }

    @Override
    public double getDeclination() {
        return this.declination;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double getShadowLength(double d2) {
        double d3 = this.getElevation();
        if (Double.isFinite(d2)) {
            if (d2 <= 0.0) {
                throw new IllegalArgumentException("Object height must be greater than zero: " + d2);
            }
            if (d3 <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (d3 == 90.0) {
                return 0.0;
            }
            double d4 = d2 / Math.tan(Math.toRadians(d3));
            return d4 < 0.016666666666666666 ? 0.0 : d4;
        }
        throw new IllegalArgumentException("Object height must be finite and positive: " + d2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SunPosition) {
            SunPosition sunPosition = (SunPosition)object;
            return this.rightAscension == sunPosition.rightAscension && this.declination == sunPosition.declination && this.azimuth == sunPosition.azimuth && this.elevation == sunPosition.elevation;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.rightAscension) + 31 * Double.hashCode(this.declination);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("sun-position[ra=");
        stringBuilder.append(this.rightAscension);
        stringBuilder.append(",decl=");
        stringBuilder.append(this.declination);
        stringBuilder.append(",azimuth=");
        stringBuilder.append(this.azimuth);
        stringBuilder.append(",elevation=");
        stringBuilder.append(this.elevation);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

