/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import net.time4j.Moment;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TimeScale;
import net.time4j.tz.ZonalOffset;

public enum AstronomicalSeason {
    VERNAL_EQUINOX,
    SUMMER_SOLSTICE,
    AUTUMNAL_EQUINOX,
    WINTER_SOLSTICE;

    private static final int[] A;
    private static final double[] B;
    private static final double[] C;

    public static AstronomicalSeason of(Moment moment) {
        int n2 = moment.toZonalTimestamp(ZonalOffset.UTC).getYear();
        AstronomicalSeason.checkYear(n2);
        if (moment.isBefore(VERNAL_EQUINOX.inYear(n2))) {
            return WINTER_SOLSTICE;
        }
        if (moment.isBefore(SUMMER_SOLSTICE.inYear(n2))) {
            return VERNAL_EQUINOX;
        }
        if (moment.isBefore(AUTUMNAL_EQUINOX.inYear(n2))) {
            return SUMMER_SOLSTICE;
        }
        if (moment.isBefore(WINTER_SOLSTICE.inYear(n2))) {
            return AUTUMNAL_EQUINOX;
        }
        return WINTER_SOLSTICE;
    }

    public Moment inYear(int n2) {
        TimeScale timeScale;
        double d2;
        AstronomicalSeason.checkYear(n2);
        double d3 = (this.jdEphemerisDays(n2) - 2441317.5) * 86400.0;
        boolean bl2 = LeapSeconds.getInstance().isEnabled();
        if (!bl2 || n2 < 1972) {
            d2 = d3 - TimeScale.deltaT(n2, (this.ordinal() + 1) * 3);
            timeScale = TimeScale.UT;
        } else {
            d2 = d3 - 42.184;
            timeScale = TimeScale.UTC;
        }
        long l2 = (long)Math.floor(d2);
        int n3 = (int)((d2 - (double)l2) * 1.0E9);
        if (!bl2) {
            l2 += 63072000L;
            timeScale = TimeScale.POSIX;
        }
        return Moment.of(l2, n3, timeScale);
    }

    public JulianDay julianDay(int n2) {
        AstronomicalSeason.checkYear(n2);
        return JulianDay.ofEphemerisTime(this.jdEphemerisDays(n2));
    }

    public AstronomicalSeason onNorthernHemisphere() {
        return this;
    }

    public AstronomicalSeason onSouthernHemisphere() {
        return AstronomicalSeason.values()[(this.ordinal() + 2) % 4];
    }

    private static void checkYear(int n2) {
        if (n2 < -2000 || n2 > 3000) {
            throw new IllegalArgumentException("Year out of supported range: -2000 <= " + n2 + " <= +3000");
        }
    }

    private double jdEphemerisDays(int n2) {
        double d2 = this.jdMean(n2);
        double d3 = (d2 - 2451545.0) / 36525.0;
        double d4 = 35999.373 * d3 - 2.47;
        double d5 = 1.0 + 0.0334 * AstronomicalSeason.cos(d4) + 7.0E-4 * AstronomicalSeason.cos(2.0 * d4);
        double d6 = AstronomicalSeason.periodic24(d3);
        return d2 + 1.0E-5 * d6 / d5;
    }

    private double jdMean(int n2) {
        if (n2 < 1000) {
            double d2 = (double)n2 / 1000.0;
            switch (this) {
                case VERNAL_EQUINOX: {
                    return 1721139.29189 + (365242.1374 + (0.06134 + (0.00111 - 7.1E-4 * d2) * d2) * d2) * d2;
                }
                case SUMMER_SOLSTICE: {
                    return 1721233.25401 + (365241.72562 + (-0.05323 + (0.00907 + 2.5E-4 * d2) * d2) * d2) * d2;
                }
                case AUTUMNAL_EQUINOX: {
                    return 1721325.70455 + (365242.49558 + (-0.11677 + (-0.00297 + 7.4E-4 * d2) * d2) * d2) * d2;
                }
                case WINTER_SOLSTICE: {
                    return 1721414.39987 + (365242.88257 + (-0.00769 + (-0.00933 - 6.0E-5 * d2) * d2) * d2) * d2;
                }
            }
            throw new AssertionError((Object)this);
        }
        double d3 = (double)(n2 - 2000) / 1000.0;
        switch (this) {
            case VERNAL_EQUINOX: {
                return 2451623.80984 + (365242.37404 + (0.05169 + (-0.00411 - 5.7E-4 * d3) * d3) * d3) * d3;
            }
            case SUMMER_SOLSTICE: {
                return 2451716.56767 + (365241.62603 + (0.00325 + (0.00888 - 3.0E-4 * d3) * d3) * d3) * d3;
            }
            case AUTUMNAL_EQUINOX: {
                return 2451810.21715 + (365242.01767 + (-0.11575 + (0.00337 + 7.8E-4 * d3) * d3) * d3) * d3;
            }
            case WINTER_SOLSTICE: {
                return 2451900.05952 + (365242.74049 + (-0.06223 + (-0.00823 + 3.2E-4 * d3) * d3) * d3) * d3;
            }
        }
        throw new AssertionError((Object)this);
    }

    private static double periodic24(double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 < 24; ++i2) {
            d3 += (double)A[i2] * AstronomicalSeason.cos(B[i2] + C[i2] * d2);
        }
        return d3;
    }

    private static double cos(double d2) {
        return Math.cos(d2 * Math.PI / 180.0);
    }

    static {
        A = new int[]{485, 203, 199, 182, 156, 136, 77, 74, 70, 58, 52, 50, 45, 44, 29, 18, 17, 16, 14, 12, 12, 12, 9, 8};
        B = new double[]{324.96, 337.23, 342.08, 27.85, 73.14, 171.52, 222.54, 296.72, 243.58, 119.81, 297.17, 21.02, 247.54, 325.15, 60.93, 155.12, 288.79, 198.04, 199.76, 95.39, 287.11, 320.81, 227.73, 15.45};
        C = new double[]{1934.136, 32964.467, 20.186, 445267.112, 45036.886, 22518.443, 65928.934, 3034.906, 9037.513, 33718.147, 150.678, 2281.226, 29929.562, 31555.956, 4443.417, 67555.328, 4562.452, 62894.029, 31436.921, 14577.848, 31931.756, 34777.259, 1222.114, 16859.074};
    }
}

