/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import net.time4j.Weekday;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.IntElementRule;

final class WeekdayInMonthElement<T extends ChronoEntity<T>>
extends StdIntegerDateElement<T>
implements OrdinalWeekdayElement<T> {
    private static final int LAST = Integer.MAX_VALUE;
    private static final long serialVersionUID = 4275169663905222176L;
    private final transient ChronoElement<Integer> domElement;
    private final transient ChronoElement<Weekday> dowElement;

    WeekdayInMonthElement(Class<T> clazz, ChronoElement<Integer> chronoElement, ChronoElement<Weekday> chronoElement2) {
        super("WEEKDAY_IN_MONTH", clazz, 1, chronoElement.getDefaultMaximum() / 7, 'F', new WeekOperator(true), new WeekOperator(false));
        this.domElement = chronoElement;
        this.dowElement = chronoElement2;
    }

    @Override
    public ChronoOperator<T> setToFirst(Weekday weekday) {
        return this.setTo(1, weekday);
    }

    @Override
    public ChronoOperator<T> setToLast(Weekday weekday) {
        return this.setTo(Integer.MAX_VALUE, weekday);
    }

    @Override
    public ChronoOperator<T> setTo(int n2, Weekday weekday) {
        return new SetOperator(this, n2, weekday);
    }

    static <T extends ChronoEntity<T>> ElementRule<T, Integer> getRule(WeekdayInMonthElement<T> weekdayInMonthElement) {
        return new Rule<T>(weekdayInMonthElement);
    }

    private static class WeekOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final boolean backwards;

        WeekOperator(boolean bl2) {
            this.backwards = bl2;
        }

        @Override
        public T apply(T t2) {
            long l2 = ((ChronoEntity)t2).get(EpochDays.UTC);
            l2 = this.backwards ? (l2 -= 7L) : (l2 += 7L);
            return ((ChronoEntity)t2).with(EpochDays.UTC, l2);
        }
    }

    private static class SetOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final WeekdayInMonthElement<T> wim;
        private final long ordinal;
        private final Weekday dayOfWeek;

        SetOperator(WeekdayInMonthElement<T> weekdayInMonthElement, int n2, Weekday weekday) {
            if (weekday == null) {
                throw new NullPointerException("Missing value.");
            }
            this.wim = weekdayInMonthElement;
            this.ordinal = n2;
            this.dayOfWeek = weekday;
        }

        @Override
        public T apply(T t2) {
            long l2;
            int n2;
            Weekday weekday = (Weekday)((ChronoEntity)t2).get(((WeekdayInMonthElement)this.wim).dowElement);
            int n3 = ((ChronoEntity)t2).getInt(((WeekdayInMonthElement)this.wim).domElement);
            if (this.ordinal == Integer.MAX_VALUE) {
                n2 = (Integer)((ChronoEntity)t2).getMaximum(((WeekdayInMonthElement)this.wim).domElement);
                int n4 = weekday.getValue() + (n2 - n3) % 7;
                if (n4 > 7) {
                    n4 -= 7;
                }
                int n5 = this.dayOfWeek.getValue() - n4;
                l2 = n2 - n3 + n5;
                if (n5 > 0) {
                    l2 -= 7L;
                }
            } else {
                n2 = this.dayOfWeek.getValue() - weekday.getValue();
                l2 = (this.ordinal - (long)(Math.floorDiv(n3 + n2 - 1, 7) + 1)) * 7L + (long)n2;
            }
            long l3 = ((CalendarDate)t2).getDaysSinceEpochUTC();
            return ((ChronoEntity)t2).with(EpochDays.UTC, l3 + l2);
        }
    }

    private static class Rule<T extends ChronoEntity<T>>
    implements IntElementRule<T> {
        private final WeekdayInMonthElement<T> wim;

        Rule(WeekdayInMonthElement<T> weekdayInMonthElement) {
            this.wim = weekdayInMonthElement;
        }

        @Override
        public Integer getValue(T t2) {
            return this.getInt(t2);
        }

        @Override
        public Integer getMinimum(T t2) {
            return 1;
        }

        @Override
        public Integer getMaximum(T t2) {
            return this.getMax(t2);
        }

        @Override
        public boolean isValid(T t2, Integer n2) {
            return n2 != null && this.isValid(t2, (int)n2);
        }

        @Override
        public T withValue(T t2, Integer n2, boolean bl2) {
            if (n2 != null) {
                return this.withValue(t2, (int)n2, bl2);
            }
            throw new IllegalArgumentException("Missing value.");
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t2) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t2) {
            return null;
        }

        @Override
        public boolean isValid(T t2, int n2) {
            return n2 >= 1 && n2 <= this.getMax(t2);
        }

        @Override
        public T withValue(T t2, int n2, boolean bl2) {
            if (this.isValid(t2, n2)) {
                Weekday weekday = (Weekday)((ChronoEntity)t2).get(((WeekdayInMonthElement)this.wim).dowElement);
                return ((ChronoEntity)t2).with(this.wim.setTo(n2, weekday));
            }
            throw new IllegalArgumentException("Invalid value: " + n2);
        }

        @Override
        public int getInt(T t2) {
            int n2 = ((ChronoEntity)t2).getInt(((WeekdayInMonthElement)this.wim).domElement);
            return Math.floorDiv(n2 - 1, 7) + 1;
        }

        private int getMax(T t2) {
            int n2 = ((ChronoEntity)t2).getInt(((WeekdayInMonthElement)this.wim).domElement);
            int n3 = (Integer)((ChronoEntity)t2).getMaximum(((WeekdayInMonthElement)this.wim).domElement);
            while (n2 + 7 <= n3) {
                n2 += 7;
            }
            return Math.floorDiv(n2 - 1, 7) + 1;
        }
    }
}

