/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.SPX8;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.ThaiSolarEra;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.RelatedGregorianYearRule;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="buddhist")
public final class ThaiSolarCalendar
extends Calendrical<CalendarUnit, ThaiSolarCalendar>
implements LocalizedPatternSupport {
    private static final PlainDate MIN_ISO = PlainDate.of(-542, 4, 1);
    @FormattableElement(format="G")
    public static final ChronoElement<ThaiSolarEra> ERA = new StdEnumDateElement<ThaiSolarEra, ThaiSolarCalendar>("ERA", ThaiSolarCalendar.class, ThaiSolarEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, ThaiSolarCalendar> YEAR_OF_ERA = new StdIntegerDateElement<ThaiSolarCalendar>("YEAR_OF_ERA", ThaiSolarCalendar.class, 1, 1000000542, 'y');
    @FormattableElement(format="M", alt="L")
    public static final StdCalendarElement<Month, ThaiSolarCalendar> MONTH_OF_YEAR = new StdEnumDateElement<Month, ThaiSolarCalendar>("MONTH_OF_YEAR", ThaiSolarCalendar.class, Month.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, ThaiSolarCalendar> DAY_OF_MONTH = new StdIntegerDateElement<ThaiSolarCalendar>("DAY_OF_MONTH", ThaiSolarCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, ThaiSolarCalendar> DAY_OF_YEAR = new StdIntegerDateElement<ThaiSolarCalendar>("DAY_OF_YEAR", ThaiSolarCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, ThaiSolarCalendar> DAY_OF_WEEK = new StdWeekdayElement<ThaiSolarCalendar>(ThaiSolarCalendar.class, ThaiSolarCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<ThaiSolarCalendar> WIM_ELEMENT = new WeekdayInMonthElement<ThaiSolarCalendar>(ThaiSolarCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<ThaiSolarCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final EraYearMonthDaySystem<ThaiSolarCalendar> CALSYS;
    private static final TimeAxis<CalendarUnit, ThaiSolarCalendar> ENGINE;
    private static final long serialVersionUID = -6628190121085147706L;
    private final PlainDate iso;

    private ThaiSolarCalendar(PlainDate plainDate) {
        if (plainDate.isBefore(MIN_ISO)) {
            throw new IllegalArgumentException("Before buddhist era: " + plainDate);
        }
        this.iso = plainDate;
    }

    public static ThaiSolarCalendar ofBuddhist(int n2, Month month, int n3) {
        return ThaiSolarCalendar.of(ThaiSolarEra.BUDDHIST, n2, month.getValue(), n3);
    }

    public static ThaiSolarCalendar ofBuddhist(int n2, int n3, int n4) {
        return ThaiSolarCalendar.of(ThaiSolarEra.BUDDHIST, n2, n3, n4);
    }

    public static ThaiSolarCalendar of(ThaiSolarEra thaiSolarEra, int n2, int n3, int n4) {
        int n5 = thaiSolarEra.toIsoYear(n2, n3);
        PlainDate plainDate = PlainDate.of(n5, n3, n4);
        return new ThaiSolarCalendar(plainDate);
    }

    public static ThaiSolarCalendar nowInSystemTime() {
        return (ThaiSolarCalendar)SystemClock.inLocalView().now(ThaiSolarCalendar.axis());
    }

    public ThaiSolarEra getEra() {
        return ThaiSolarEra.BUDDHIST;
    }

    public int getYear() {
        int n2 = this.iso.getYear();
        if (n2 >= 1941 || this.iso.getMonth() >= 4) {
            return n2 + 543;
        }
        return n2 + 542;
    }

    public Month getMonth() {
        return Month.valueOf(this.iso.getMonth());
    }

    public int getDayOfMonth() {
        return this.iso.getDayOfMonth();
    }

    public Weekday getDayOfWeek() {
        return this.iso.getDayOfWeek();
    }

    public int getDayOfYear() {
        int n2 = (Integer)this.iso.get(PlainDate.DAY_OF_YEAR);
        if (this.iso.getYear() < 1941) {
            n2 = this.iso.getMonth() >= 4 ? (n2 -= this.iso.isLeapYear() ? 91 : 90) : (n2 += 275);
        }
        return n2;
    }

    public int lengthOfMonth() {
        return this.iso.lengthOfMonth();
    }

    public int lengthOfYear() {
        int n2 = this.iso.getYear();
        if (n2 >= 1941) {
            return this.iso.lengthOfYear();
        }
        if (this.iso.getMonth() >= 4) {
            if (n2 == 1940) {
                return 275;
            }
            return GregorianMath.isLeapYear(n2 + 1) ? 366 : 365;
        }
        return this.iso.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return this.lengthOfYear() == 366;
    }

    public static boolean isValid(ThaiSolarEra thaiSolarEra, int n2, int n3, int n4) {
        return CALSYS.isValid(thaiSolarEra, n2, n3, n4);
    }

    public GeneralTimestamp<ThaiSolarCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<ThaiSolarCalendar> atTime(int n2, int n3) {
        return this.at(PlainTime.of(n2, n3));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ThaiSolarCalendar) {
            ThaiSolarCalendar thaiSolarCalendar = (ThaiSolarCalendar)object;
            return this.iso.equals(thaiSolarCalendar.iso);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.iso.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getEra());
        stringBuilder.append('-');
        stringBuilder.append(this.getYear());
        stringBuilder.append('-');
        int n2 = this.getMonth().getValue();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        int n3 = this.getDayOfMonth();
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1);
    }

    public static TimeAxis<CalendarUnit, ThaiSolarCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<CalendarUnit, ThaiSolarCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected ThaiSolarCalendar getContext() {
        return this;
    }

    PlainDate toISO() {
        return this.iso;
    }

    private static void registerUnits(TimeAxis.Builder<CalendarUnit, ThaiSolarCalendar> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit(calendarUnit, new ThaiUnitRule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo(CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private Object writeReplace() {
        return new SPX8(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        HashMap<ChronoElement<ThaiSolarEra>, StdCalendarElement<Object, ThaiSolarCalendar>> hashMap = new HashMap<ChronoElement<ThaiSolarEra>, StdCalendarElement<Object, ThaiSolarCalendar>>();
        hashMap.put(ERA, YEAR_OF_ERA);
        hashMap.put(YEAR_OF_ERA, MONTH_OF_YEAR);
        hashMap.put(MONTH_OF_YEAR, DAY_OF_MONTH);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        CALSYS = new Transformer();
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(CalendarUnit.class, ThaiSolarCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)FieldRule.of(ERA))).appendElement(YEAR_OF_ERA, FieldRule.of(YEAR_OF_ERA), CalendarUnit.YEARS).appendElement(MONTH_OF_YEAR, FieldRule.of(MONTH_OF_YEAR), CalendarUnit.MONTHS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<ThaiSolarCalendar>(CALSYS, DAY_OF_YEAR))).appendElement(DAY_OF_MONTH, FieldRule.of(DAY_OF_MONTH), CalendarUnit.DAYS).appendElement(DAY_OF_YEAR, FieldRule.of(DAY_OF_YEAR), CalendarUnit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<ThaiSolarCalendar>(ThaiSolarCalendar.getDefaultWeekmodel(), thaiSolarCalendar -> CALSYS), CalendarUnit.DAYS).appendElement(WIM_ELEMENT, (ElementRule)WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendExtension(new CommonElements.Weekengine(ThaiSolarCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, ThaiSolarCalendar.getDefaultWeekmodel()));
        ThaiSolarCalendar.registerUnits((TimeAxis.Builder<CalendarUnit, ThaiSolarCalendar>)builder);
        ENGINE = ((TimeAxis.Builder)builder).build();
    }

    private static class ThaiUnitRule
    implements UnitRule<ThaiSolarCalendar> {
        private final CalendarUnit unit;

        ThaiUnitRule(CalendarUnit calendarUnit) {
            this.unit = calendarUnit;
        }

        @Override
        public ThaiSolarCalendar addTo(ThaiSolarCalendar thaiSolarCalendar, long l2) {
            return new ThaiSolarCalendar(thaiSolarCalendar.iso.plus(l2, this.unit));
        }

        @Override
        public long between(ThaiSolarCalendar thaiSolarCalendar, ThaiSolarCalendar thaiSolarCalendar2) {
            return this.unit.between(thaiSolarCalendar.iso, thaiSolarCalendar2.iso);
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<ThaiSolarCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n2, int n3, int n4) {
            try {
                if (calendarEra instanceof ThaiSolarEra && n2 >= 1) {
                    int n5 = ((ThaiSolarEra)ThaiSolarEra.class.cast(calendarEra)).toIsoYear(n2, n3);
                    return n5 <= 999999999 && n3 >= 1 && n3 <= 12 && n4 >= 1 && n4 <= GregorianMath.getLengthOfMonth(n5, n3);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n2, int n3) {
            try {
                int n4 = ((ThaiSolarEra)ThaiSolarEra.class.cast(calendarEra)).toIsoYear(n2, n3);
                return GregorianMath.getLengthOfMonth(n4, n3);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n2) {
            if (n2 < 1) {
                throw new IllegalArgumentException("Out of bounds: " + n2);
            }
            if (calendarEra.equals(ThaiSolarEra.BUDDHIST)) {
                int n3 = n2 - 543;
                if (n3 == 1940) {
                    return 275;
                }
                if (n3 < 1940) {
                    ++n3;
                }
                return GregorianMath.isLeapYear(n3) ? 366 : 365;
            }
            if (calendarEra.equals(ThaiSolarEra.RATTANAKOSIN)) {
                return GregorianMath.isLeapYear(n2 + 1782) ? 366 : 365;
            }
            throw new IllegalArgumentException("Invalid calendar era: " + calendarEra);
        }

        @Override
        public ThaiSolarCalendar transform(long l2) {
            return new ThaiSolarCalendar(PlainDate.of(l2, EpochDays.UTC));
        }

        @Override
        public long transform(ThaiSolarCalendar thaiSolarCalendar) {
            return thaiSolarCalendar.iso.get(EpochDays.UTC);
        }

        @Override
        public long getMinimumSinceUTC() {
            return MIN_ISO.getDaysSinceEpochUTC();
        }

        @Override
        public long getMaximumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMaximumSinceUTC();
        }

        @Override
        public List<CalendarEra> getEras() {
            ThaiSolarEra thaiSolarEra = ThaiSolarEra.RATTANAKOSIN;
            ThaiSolarEra thaiSolarEra2 = ThaiSolarEra.BUDDHIST;
            return Arrays.asList(thaiSolarEra, thaiSolarEra2);
        }
    }

    private static class Merger
    implements ChronoMerger<ThaiSolarCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return GenericDatePatterns.get("buddhist", formatStyle, locale);
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() + 543;
        }

        @Override
        public ThaiSolarCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (ThaiSolarCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        public ThaiSolarCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            ThaiSolarEra thaiSolarEra;
            if (chronoEntity.contains(PlainDate.COMPONENT)) {
                return new ThaiSolarCalendar(chronoEntity.get(PlainDate.COMPONENT));
            }
            if (chronoEntity.contains(ERA)) {
                thaiSolarEra = chronoEntity.get(ERA);
            } else if (bl2) {
                thaiSolarEra = ThaiSolarEra.BUDDHIST;
            } else {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Thai era.");
                return null;
            }
            int n2 = chronoEntity.getInt(YEAR_OF_ERA);
            if (n2 == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Thai year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n3 = ((Month)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n4 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n4 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(thaiSolarEra, n2, n3, n4)) {
                        return ThaiSolarCalendar.of(thaiSolarEra, n2, n3, n4);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Thai calendar date.");
                }
            } else {
                int n5 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n5 != Integer.MIN_VALUE) {
                    if (n5 > 0) {
                        int n6 = thaiSolarEra == ThaiSolarEra.RATTANAKOSIN || n2 < 2484 ? 3 : 0;
                        int n7 = thaiSolarEra.toIsoYear(n2, 4);
                        int n8 = 1 + n6;
                        int n9 = 0;
                        while (n8 <= 12 + n6) {
                            int n10;
                            int n11 = n7;
                            int n12 = n8;
                            if (n12 > 12) {
                                if (thaiSolarEra == ThaiSolarEra.BUDDHIST && n11 == 1940) break;
                                ++n11;
                                n12 -= 12;
                            }
                            if (n5 > n9 + (n10 = GregorianMath.getLengthOfMonth(n11, n12))) {
                                ++n8;
                                n9 += n10;
                                continue;
                            }
                            int n13 = n5 - n9;
                            return ThaiSolarCalendar.of(thaiSolarEra, n2, n12, n13);
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Thai calendar date.");
                }
            }
            return null;
        }
    }

    private static class FieldRule<V extends Comparable<V>>
    implements ElementRule<ThaiSolarCalendar, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V extends Comparable<V>> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        @Override
        public V getValue(ThaiSolarCalendar thaiSolarCalendar) {
            Object object;
            if (this.element == ERA) {
                object = thaiSolarCalendar.getEra();
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = thaiSolarCalendar.getYear();
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = thaiSolarCalendar.getMonth();
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = thaiSolarCalendar.getDayOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = thaiSolarCalendar.getDayOfYear();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public V getMinimum(ThaiSolarCalendar thaiSolarCalendar) {
            Object object;
            if (this.element == ERA) {
                object = ThaiSolarEra.BUDDHIST;
            } else if (Integer.class.isAssignableFrom(this.element.getType())) {
                object = 1;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = thaiSolarCalendar.iso.getYear() >= 1941 ? Month.JANUARY : Month.APRIL;
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public V getMaximum(ThaiSolarCalendar thaiSolarCalendar) {
            Object object;
            if (this.element == ERA) {
                object = ThaiSolarEra.BUDDHIST;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = 1000000542;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = thaiSolarCalendar.getYear() >= 2483 ? Month.DECEMBER : Month.MARCH;
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = thaiSolarCalendar.lengthOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = thaiSolarCalendar.lengthOfYear();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public boolean isValid(ThaiSolarCalendar thaiSolarCalendar, V v2) {
            if (v2 == null) {
                return false;
            }
            if (this.element.getType().isEnum()) {
                if (this.element.equals(MONTH_OF_YEAR) && thaiSolarCalendar.getYear() == 2483) {
                    return ((Month)Month.class.cast(v2)).getValue() >= 4;
                }
                return true;
            }
            V v3 = this.getMinimum(thaiSolarCalendar);
            V v4 = this.getMaximum(thaiSolarCalendar);
            return v3.compareTo(v2) <= 0 && v2.compareTo(v4) <= 0;
        }

        @Override
        public ThaiSolarCalendar withValue(ThaiSolarCalendar thaiSolarCalendar, V v2, boolean bl2) {
            if (!this.isValid(thaiSolarCalendar, v2)) {
                throw new IllegalArgumentException("Out of range: " + v2);
            }
            if (this.element == ERA) {
                return thaiSolarCalendar;
            }
            if (this.element.equals(YEAR_OF_ERA)) {
                ThaiSolarCalendar thaiSolarCalendar2 = ThaiSolarCalendar.ofBuddhist(FieldRule.toNumber(v2), thaiSolarCalendar.getMonth(), 1);
                return (ThaiSolarCalendar)thaiSolarCalendar2.with((ChronoElement<Integer>)DAY_OF_MONTH, Math.min(thaiSolarCalendar.getDayOfMonth(), thaiSolarCalendar2.lengthOfMonth()));
            }
            if (this.element.equals(MONTH_OF_YEAR)) {
                ThaiSolarCalendar thaiSolarCalendar3 = ThaiSolarCalendar.ofBuddhist(thaiSolarCalendar.getYear(), (Month)Month.class.cast(v2), 1);
                return (ThaiSolarCalendar)thaiSolarCalendar3.with((ChronoElement<Integer>)DAY_OF_MONTH, Math.min(thaiSolarCalendar.getDayOfMonth(), thaiSolarCalendar3.lengthOfMonth()));
            }
            if (this.element.equals(DAY_OF_MONTH)) {
                PlainDate plainDate = (PlainDate)thaiSolarCalendar.iso.with((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, FieldRule.toNumber(v2));
                return new ThaiSolarCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_YEAR)) {
                int n2 = thaiSolarCalendar.iso.getYear() >= 1941 ? 1 : 4;
                ThaiSolarCalendar thaiSolarCalendar4 = ThaiSolarCalendar.ofBuddhist(thaiSolarCalendar.getYear(), n2, 1);
                PlainDate plainDate = thaiSolarCalendar4.iso.plus((long)(FieldRule.toNumber(v2) - 1), CalendarUnit.DAYS);
                return new ThaiSolarCalendar(plainDate);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(ThaiSolarCalendar thaiSolarCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(ThaiSolarCalendar thaiSolarCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private static int toNumber(Object object) {
            return (Integer)Integer.class.cast(object);
        }
    }
}

