/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.net.URI;
import java.text.ParsePosition;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EastAsianME;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.Nengo;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.SPX9;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="japanese")
public final class JapaneseCalendar
extends Calendrical<Unit, JapaneseCalendar>
implements LocalizedPatternSupport {
    private static final int YEAR_OF_NENGO_INDEX = 0;
    private static final int MONTH_AS_ORDINAL_INDEX = 1;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    private static final int RELATED_GREGORIAN_YEAR_INDEX = 4;
    private static final int KOKI_INDEX = 5;
    private static final int MRD = 1000000000;
    private static final long EPOCH_1873 = -36158L;
    private static final byte[] LEAP_INDICATORS;
    private static final int[] LUNISOLAR_MONTHS;
    private static final long[] START_OF_YEAR;
    @FormattableElement(format="G")
    public static final TextElement<Nengo> ERA;
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, JapaneseCalendar> YEAR_OF_ERA;
    public static final ChronoElement<Integer> KOKI_YEAR;
    @FormattableElement(format="M", alt="L")
    public static final TextElement<EastAsianMonth> MONTH_OF_YEAR;
    public static final StdCalendarElement<Integer, JapaneseCalendar> MONTH_AS_ORDINAL;
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, JapaneseCalendar> DAY_OF_MONTH;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, JapaneseCalendar> DAY_OF_YEAR;
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, JapaneseCalendar> DAY_OF_WEEK;
    private static final WeekdayInMonthElement<JapaneseCalendar> WIM_ELEMENT;
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<JapaneseCalendar> WEEKDAY_IN_MONTH;
    private static final Transformer CALSYS;
    private static final TimeAxis<Unit, JapaneseCalendar> ENGINE;
    private static final long serialVersionUID = -153630575450868922L;
    private final transient int relgregyear;
    private final transient int dayOfYear;
    private final transient Nengo nengo;
    private final transient EastAsianMonth month;
    private final transient int dayOfMonth;

    private JapaneseCalendar(Nengo nengo, int n2, int n3) {
        this(nengo, n2, n3, JapaneseCalendar.getMonth(n2, n3), JapaneseCalendar.getDayOfMonth(n2, n3));
    }

    private JapaneseCalendar(Nengo nengo, int n2, int n3, EastAsianMonth eastAsianMonth, int n4) {
        this.nengo = nengo;
        this.relgregyear = n2;
        this.dayOfYear = n3;
        this.month = eastAsianMonth;
        this.dayOfMonth = n4;
    }

    public static JapaneseCalendar ofGregorian(Nengo nengo, int n2, int n3, int n4) {
        if (!nengo.isModern() || nengo == Nengo.MEIJI && n2 < 6) {
            throw new IllegalArgumentException("Cannot create modern calendar with lunisolar calendar year.");
        }
        return JapaneseCalendar.of(nengo, n2, EastAsianMonth.valueOf(n3), n4, Leniency.SMART);
    }

    public static JapaneseCalendar of(Nengo nengo, int n2, EastAsianMonth eastAsianMonth, int n3) {
        return JapaneseCalendar.of(nengo, n2, eastAsianMonth, n3, Leniency.SMART);
    }

    public static JapaneseCalendar of(Nengo nengo, int n2, EastAsianMonth eastAsianMonth, int n3, Leniency leniency) {
        int n4;
        if (n2 < 1) {
            throw new IllegalArgumentException("Year of nengo smaller than 1: " + n2);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Day of month smaller than 1: " + n3);
        }
        int n5 = nengo.getFirstRelatedGregorianYear() + n2 - 1;
        Optional<Nengo> optional = nengo.findNext();
        if (optional.isPresent() && optional.get().getFirstRelatedGregorianYear() < n5) {
            throw new IllegalArgumentException("Year of nengo out of range: " + nengo + "/" + n2);
        }
        int n6 = 0;
        if (n5 >= 1873) {
            if (eastAsianMonth.isLeap()) {
                throw new IllegalArgumentException("Lunisolar leap month not valid in modern times: " + eastAsianMonth);
            }
            if (n3 > GregorianMath.getLengthOfMonth(n5, eastAsianMonth.getNumber())) {
                throw new IllegalArgumentException("Day of month out of range: " + n3);
            }
            int n7 = eastAsianMonth.getNumber();
            for (n4 = 1; n4 < n7; ++n4) {
                n6 += GregorianMath.getLengthOfMonth(n5, n4);
            }
            n6 += n3;
        } else {
            n4 = LUNISOLAR_MONTHS[n5 - 701];
            int n8 = JapaneseCalendar.getMonthIndex(n5, eastAsianMonth);
            if (eastAsianMonth.isLeap() && n8 != LEAP_INDICATORS[n5 - 701]) {
                throw new IllegalArgumentException("Invalid leap month: " + eastAsianMonth);
            }
            for (int i2 = 1; i2 <= n8; ++i2) {
                int n9;
                int n10 = n9 = (n4 & 1) == 1 ? 30 : 29;
                if (i2 == n8) {
                    if (n3 > n9) {
                        throw new IllegalArgumentException("Day of month out of range: " + n3);
                    }
                    n6 += n3;
                    continue;
                }
                n6 += n9;
                n4 >>>= 1;
            }
        }
        if (n5 == 1872 && eastAsianMonth.getNumber() == 12 && n3 >= 3) {
            if (leniency.isStrict()) {
                throw new IllegalArgumentException("Last month of lunisolar calendar had only 2 days.");
            }
            n4 = n3 - 2;
            return new JapaneseCalendar(Nengo.MEIJI, 1873, n4, EastAsianMonth.valueOf(1), n4);
        }
        long l2 = JapaneseCalendar.transform(n5, n6);
        CALSYS.check(l2);
        Nengo nengo2 = JapaneseCalendar.findBestNengo(nengo.matches(Nengo.Selector.NORTHERN_COURT), n5, l2);
        switch (leniency) {
            case STRICT: {
                if (nengo2 == nengo) break;
                throw new IllegalArgumentException("Nengo should be: " + nengo2 + ", but was: " + nengo);
            }
            case SMART: {
                nengo = nengo2;
                break;
            }
        }
        return new JapaneseCalendar(nengo, n5, n6, eastAsianMonth, n3);
    }

    public static JapaneseCalendar nowInSystemTime() {
        return (JapaneseCalendar)SystemClock.inLocalView().now(JapaneseCalendar.axis());
    }

    public Nengo getEra() {
        return this.nengo;
    }

    public int getYear() {
        return this.relgregyear - this.nengo.getFirstRelatedGregorianYear() + 1;
    }

    public EastAsianMonth getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Weekday getDayOfWeek() {
        long l2 = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l2 + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return this.dayOfYear;
    }

    public int lengthOfMonth() {
        return JapaneseCalendar.getLengthOfMonth(this.relgregyear, this.month);
    }

    public int lengthOfYear() {
        return JapaneseCalendar.getLengthOfYear(this.relgregyear);
    }

    public boolean isLeapYear() {
        if (this.relgregyear >= 1873) {
            return GregorianMath.isLeapYear(this.relgregyear);
        }
        return LEAP_INDICATORS[this.relgregyear - 701] > 0;
    }

    public GeneralTimestamp<JapaneseCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<JapaneseCalendar> atTime(int n2, int n3) {
        return this.at(PlainTime.of(n2, n3));
    }

    @Override
    public int compareTo(JapaneseCalendar japaneseCalendar) {
        int n2 = super.compareTo(japaneseCalendar);
        if (n2 == 0 && (n2 = this.nengo.getValue() - japaneseCalendar.nengo.getValue()) == 0) {
            boolean bl2 = this.nengo.matches(Nengo.Selector.NORTHERN_COURT);
            boolean bl3 = japaneseCalendar.nengo.matches(Nengo.Selector.NORTHERN_COURT);
            n2 = !bl2 && bl3 ? -1 : (bl2 && !bl3 ? 1 : 0);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JapaneseCalendar) {
            JapaneseCalendar japaneseCalendar = (JapaneseCalendar)object;
            return this.relgregyear == japaneseCalendar.relgregyear && this.dayOfYear == japaneseCalendar.dayOfYear && this.nengo == japaneseCalendar.nengo && this.dayOfMonth == japaneseCalendar.dayOfMonth && this.month.equals(japaneseCalendar.month);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.relgregyear + 31 * this.dayOfYear;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.nengo.getDisplayName(Locale.ROOT));
        stringBuilder.append('-');
        stringBuilder.append(this.getYear());
        stringBuilder.append('(');
        stringBuilder.append(this.relgregyear);
        stringBuilder.append(")-");
        if (this.month.isLeap()) {
            stringBuilder.append('*');
        }
        int n2 = this.month.getNumber();
        if (this.relgregyear >= 1873 && n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        int n3 = this.getDayOfMonth();
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Locale.JAPAN);
    }

    public static TimeAxis<Unit, JapaneseCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, JapaneseCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected JapaneseCalendar getContext() {
        return this;
    }

    @Override
    protected int compareByTime(CalendarDate calendarDate) {
        JapaneseCalendar japaneseCalendar = calendarDate instanceof JapaneseCalendar ? (JapaneseCalendar)JapaneseCalendar.class.cast(calendarDate) : CALSYS.transform(calendarDate.getDaysSinceEpochUTC());
        if (this.relgregyear < japaneseCalendar.relgregyear) {
            return -1;
        }
        if (this.relgregyear > japaneseCalendar.relgregyear) {
            return 1;
        }
        if (this.dayOfYear < japaneseCalendar.dayOfYear) {
            return -1;
        }
        if (this.dayOfYear > japaneseCalendar.dayOfYear) {
            return 1;
        }
        return 0;
    }

    private JapaneseCalendar tryWithNorthernCourt() {
        if (this.relgregyear >= 1332 && this.relgregyear < 1394) {
            Nengo nengo = Nengo.ofRelatedGregorianYear(this.relgregyear, Nengo.Selector.NORTHERN_COURT);
            while (nengo.getStartAsDaysSinceEpochUTC() > this.getDaysSinceEpochUTC()) {
                nengo = nengo.findPrevious().get();
            }
            return new JapaneseCalendar(nengo, this.relgregyear, this.dayOfYear, this.month, this.dayOfMonth);
        }
        return this;
    }

    private static Nengo findBestNengo(boolean bl2, int n2, long l2) {
        Optional<Nengo> optional;
        Nengo nengo = bl2 && n2 >= 1332 && n2 < 1394 ? Nengo.ofRelatedGregorianYear(n2, Nengo.Selector.NORTHERN_COURT) : Nengo.ofRelatedGregorianYear(n2, Nengo.Selector.OFFICIAL);
        while (nengo.getStartAsDaysSinceEpochUTC() > l2 && (optional = nengo.findPrevious()).isPresent()) {
            nengo = optional.get();
        }
        return nengo;
    }

    private static EastAsianMonth getMonth(int n2, int n3) {
        block6: {
            int n4 = 0;
            if (n3 < 1) break block6;
            if (n2 >= 1873) {
                for (int i2 = 1; i2 <= 12; ++i2) {
                    if ((n4 += GregorianMath.getLengthOfMonth(n2, i2)) < n3) continue;
                    return EastAsianMonth.valueOf(i2);
                }
            } else {
                int n5;
                int n6 = LEAP_INDICATORS[n2 - 701];
                int n7 = LUNISOLAR_MONTHS[n2 - 701];
                int n8 = n5 = n6 == 0 ? 12 : 13;
                for (int i3 = 1; i3 <= n5; ++i3) {
                    int n9 = (n7 & 1) == 1 ? 30 : 29;
                    n7 >>>= 1;
                    if ((n4 += n9) < n3) continue;
                    int n10 = i3;
                    if (n6 > 0 && n6 <= i3) {
                        --n10;
                    }
                    EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n10);
                    if (i3 == n6) {
                        eastAsianMonth = eastAsianMonth.withLeap();
                    }
                    return eastAsianMonth;
                }
            }
        }
        throw new IllegalArgumentException("Day of year out of range: " + n3);
    }

    private static int getLengthOfMonth(int n2, EastAsianMonth eastAsianMonth) {
        if (n2 >= 1873) {
            return GregorianMath.getLengthOfMonth(n2, eastAsianMonth.getNumber());
        }
        if (n2 == 1872 && eastAsianMonth.getNumber() == 12) {
            return 2;
        }
        int n3 = JapaneseCalendar.getMonthIndex(n2, eastAsianMonth);
        int n4 = LUNISOLAR_MONTHS[n2 - 701];
        for (int i2 = 1; i2 <= n3; ++i2) {
            if (i2 == n3) {
                return (n4 & 1) == 1 ? 30 : 29;
            }
            n4 >>>= 1;
        }
        throw new AssertionError();
    }

    private static int getLengthOfYear(int n2) {
        int n3;
        if (n2 >= 1873) {
            return GregorianMath.isLeapYear(n2) ? 366 : 365;
        }
        if (n2 == 1872) {
            return (int)(-36158L - START_OF_YEAR[1171]);
        }
        int n4 = n2 - 701;
        int n5 = LUNISOLAR_MONTHS[n4];
        int n6 = 0;
        int n7 = n3 = LEAP_INDICATORS[n4] == 0 ? 12 : 13;
        for (int i2 = 1; i2 <= n3; ++i2) {
            n6 += (n5 & 1) == 1 ? 30 : 29;
            n5 >>>= 1;
        }
        return n6;
    }

    private static int getMonthIndex(int n2, EastAsianMonth eastAsianMonth) {
        int n3 = eastAsianMonth.getNumber();
        if (n2 >= 1873) {
            return n3;
        }
        byte by2 = LEAP_INDICATORS[n2 - 701];
        if (eastAsianMonth.isLeap() || by2 > 0 && n3 >= by2) {
            return n3 + 1;
        }
        return n3;
    }

    private static int getDayOfMonth(int n2, int n3) {
        int n4 = n3;
        EastAsianMonth eastAsianMonth = JapaneseCalendar.getMonth(n2, n3);
        if (n2 >= 1873) {
            int n5 = eastAsianMonth.getNumber();
            for (int i2 = 1; i2 < n5; ++i2) {
                n4 -= GregorianMath.getLengthOfMonth(n2, i2);
            }
        } else {
            int n6 = JapaneseCalendar.getMonthIndex(n2, eastAsianMonth);
            int n7 = LUNISOLAR_MONTHS[n2 - 701];
            for (int i3 = 1; i3 < n6; ++i3) {
                n4 -= (n7 & 1) == 1 ? 30 : 29;
                n7 >>>= 1;
            }
        }
        return n4;
    }

    private static int getArrayIndex(long l2) {
        int n2 = 0;
        int n3 = START_OF_YEAR.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            if (START_OF_YEAR[n4] <= l2) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2 - 1;
    }

    static long transform(int n2, int n3) {
        if (n2 >= 1873) {
            return PlainDate.of(n2, n3).getDaysSinceEpochUTC();
        }
        return START_OF_YEAR[n2 - 701] + (long)n3 - 1L;
    }

    private static JapaneseCalendar create(JapaneseCalendar japaneseCalendar, int n2, EastAsianMonth eastAsianMonth, int n3) {
        Nengo nengo = Nengo.ofRelatedGregorianYear(n2);
        JapaneseCalendar japaneseCalendar2 = JapaneseCalendar.of(nengo, n2 - nengo.getFirstRelatedGregorianYear() + 1, eastAsianMonth, n3, Leniency.SMART);
        if (japaneseCalendar.nengo.matches(Nengo.Selector.NORTHERN_COURT)) {
            japaneseCalendar2 = japaneseCalendar2.tryWithNorthernCourt();
        }
        return japaneseCalendar2;
    }

    private Object writeReplace() {
        return new SPX9(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Object object = "data/tsuchihashi.data";
        URI uRI = ResourceLoader.getInstance().locate("base", JapaneseCalendar.class, (String)object);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        try {
            if (inputStream == null) {
                inputStream = ResourceLoader.getInstance().load(JapaneseCalendar.class, (String)object, true);
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            long l2 = -464176L;
            int n2 = 1172;
            byte[] byArray = new byte[n2];
            int[] nArray = new int[n2];
            long[] lArray = new long[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by2 = dataInputStream.readByte();
                int n3 = dataInputStream.readShort();
                byArray[i2] = by2;
                nArray[i2] = n3;
                lArray[i2] = l2;
                int n4 = 0;
                for (int i3 = 1; i3 <= (by2 == 0 ? 12 : 13); ++i3) {
                    n4 += (n3 & 1) == 1 ? 30 : 29;
                    n3 >>>= 1;
                }
                l2 += (long)n4;
            }
            LEAP_INDICATORS = byArray;
            LUNISOLAR_MONTHS = nArray;
            START_OF_YEAR = lArray;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        ERA = Nengo.Element.SINGLETON;
        YEAR_OF_ERA = new YearOfNengoElement();
        KOKI_YEAR = new StdIntegerDateElement<JapaneseCalendar>("KOKI_YEAR", JapaneseCalendar.class, 1361, 1000000659, '\u0000');
        MONTH_OF_YEAR = new MonthPrimitiveElement();
        MONTH_AS_ORDINAL = new StdIntegerDateElement<JapaneseCalendar>("MONTH_AS_ORDINAL", JapaneseCalendar.class, 1, 12, '\u0000');
        DAY_OF_MONTH = new StdIntegerDateElement<JapaneseCalendar>("DAY_OF_MONTH", JapaneseCalendar.class, 1, 31, 'd');
        DAY_OF_YEAR = new StdIntegerDateElement<JapaneseCalendar>("DAY_OF_YEAR", JapaneseCalendar.class, 1, 365, 'D');
        DAY_OF_WEEK = new StdWeekdayElement<JapaneseCalendar>(JapaneseCalendar.class, JapaneseCalendar.getDefaultWeekmodel());
        WIM_ELEMENT = new WeekdayInMonthElement<JapaneseCalendar>(JapaneseCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
        WEEKDAY_IN_MONTH = WIM_ELEMENT;
        CALSYS = new Transformer();
        object = ((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, JapaneseCalendar.class, new Merger(), CALSYS).appendElement(ERA, new NengoRule(), Unit.ERAS).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement(MONTH_OF_YEAR, MonthPrimitiveElement.SINGLETON_JP, Unit.MONTHS).appendElement(MONTH_AS_ORDINAL, new IntegerRule(1), Unit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<JapaneseCalendar>(JapaneseCalendar.getDefaultWeekmodel(), japaneseCalendar -> CALSYS), Unit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendElement(KOKI_YEAR, new IntegerRule(5), Unit.YEARS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, (ElementRule)new IntegerRule(4))).appendUnit(Unit.ERAS, new JapaneseUnitRule(Unit.ERAS), Unit.ERAS.getLength()).appendUnit(Unit.YEARS, new JapaneseUnitRule(Unit.YEARS), Unit.YEARS.getLength()).appendUnit(Unit.MONTHS, new JapaneseUnitRule(Unit.MONTHS), Unit.MONTHS.getLength()).appendUnit(Unit.WEEKS, new JapaneseUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new JapaneseUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS));
        ENGINE = ((TimeAxis.Builder)object).build();
    }

    private static class Transformer
    implements CalendarSystem<JapaneseCalendar> {
        private Transformer() {
        }

        @Override
        public JapaneseCalendar transform(long l2) {
            if (l2 >= -36158L) {
                PlainDate plainDate = PlainDate.of(l2, EpochDays.UTC);
                int n2 = plainDate.getYear();
                Nengo nengo = JapaneseCalendar.findBestNengo(false, n2, l2);
                return new JapaneseCalendar(nengo, n2, plainDate.getDayOfYear(), EastAsianMonth.valueOf(plainDate.getMonth()), plainDate.getDayOfMonth());
            }
            int n3 = JapaneseCalendar.getArrayIndex(l2);
            if (n3 < 0) {
                throw new IllegalArgumentException("Out of bounds: " + l2);
            }
            int n4 = n3 + 701;
            int n5 = (int)(l2 - START_OF_YEAR[n3] + 1L);
            Nengo nengo = JapaneseCalendar.findBestNengo(false, n4, l2);
            return new JapaneseCalendar(nengo, n4, n5);
        }

        @Override
        public long transform(JapaneseCalendar japaneseCalendar) {
            return JapaneseCalendar.transform(japaneseCalendar.relgregyear, japaneseCalendar.dayOfYear);
        }

        @Override
        public long getMinimumSinceUTC() {
            return START_OF_YEAR[0];
        }

        @Override
        public long getMaximumSinceUTC() {
            return 365241779741L;
        }

        @Override
        public List<CalendarEra> getEras() {
            List<CalendarEra> list = Nengo.list();
            return list;
        }

        void check(long l2) {
            if (l2 < this.getMinimumSinceUTC() || l2 > this.getMaximumSinceUTC()) {
                throw new IllegalArgumentException("Japanese calendar out of supported range.");
            }
        }
    }

    private static class YearOfNengoElement
    extends StdIntegerDateElement<JapaneseCalendar>
    implements DualFormatElement {
        private static final long serialVersionUID = -8502388572788955989L;

        private YearOfNengoElement() {
            super("YEAR_OF_ERA", JapaneseCalendar.class, 1, 1000000000 - Nengo.Element.SINGLETON.getDefaultMaximum().getFirstRelatedGregorianYear(), 'y');
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            char c2 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
            this.print(chronoDisplay, appendable, attributeQuery, numberSystem, c2, 1, 9);
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, NumberSystem numberSystem, char c2, int n2, int n3) throws IOException, ChronoException {
            int n4 = chronoDisplay.getInt(this);
            if (n4 == 1 && numberSystem == NumberSystem.ARABIC && attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT).getLanguage().equals("ja")) {
                appendable.append('\u5143');
            } else {
                String string = numberSystem.toNumeral(n4);
                if (numberSystem.isDecimal()) {
                    int n5 = string.length();
                    int n6 = n2 - n5;
                    for (int i2 = 0; i2 < n6; ++i2) {
                        appendable.append(c2);
                    }
                }
                appendable.append(string);
            }
        }

        @Override
        public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n2;
            NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            int n3 = n2 = parsePosition.getIndex();
            if (numberSystem == NumberSystem.ARABIC && charSequence.charAt(n3) == '\u5143' && attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT).getLanguage().equals("ja")) {
                parsePosition.setIndex(n3 + 1);
                return 1;
            }
            int n4 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (int)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (int)numberSystem.getDigits().charAt(0) : 48);
            int n5 = 0;
            if (numberSystem.hasDecimalCodepoints()) {
                int n6;
                int n7 = Math.min(n3 + 9, charSequence.length());
                for (int i2 = n3; i2 < n7 && (n6 = charSequence.charAt(i2) - n4) >= 0 && n6 <= 9; ++i2) {
                    n5 = n5 * 10 + n6;
                    ++n3;
                }
            } else {
                int n8 = 0;
                int n9 = charSequence.length();
                for (int i3 = n3; i3 < n9 && numberSystem.contains(charSequence.charAt(i3)); ++i3) {
                    ++n8;
                }
                if (n8 > 0) {
                    n5 = numberSystem.toInteger(charSequence.subSequence(n3, n3 + n8).toString(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART));
                    n3 += n8;
                }
            }
            if (n3 == n2) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            parsePosition.setIndex(n3);
            return n5;
        }

        @Override
        public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, ChronoEntity<?> chronoEntity) {
            return this.parse(charSequence, parsePosition, attributeQuery);
        }
    }

    private static class MonthPrimitiveElement
    extends EastAsianME
    implements ElementRule<JapaneseCalendar, EastAsianMonth> {
        static final MonthPrimitiveElement SINGLETON_JP = new MonthPrimitiveElement();
        private static final long serialVersionUID = -2978966174642315851L;

        private MonthPrimitiveElement() {
        }

        @Override
        public EastAsianMonth getValue(JapaneseCalendar japaneseCalendar) {
            return japaneseCalendar.month;
        }

        @Override
        public EastAsianMonth getMinimum(JapaneseCalendar japaneseCalendar) {
            return EastAsianMonth.valueOf(1);
        }

        @Override
        public EastAsianMonth getMaximum(JapaneseCalendar japaneseCalendar) {
            EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(12);
            if (japaneseCalendar.relgregyear < 1873 && LEAP_INDICATORS[japaneseCalendar.relgregyear - 701] == 13) {
                return eastAsianMonth.withLeap();
            }
            return eastAsianMonth;
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, EastAsianMonth eastAsianMonth) {
            if (eastAsianMonth == null) {
                return false;
            }
            if (japaneseCalendar.relgregyear >= 1873) {
                return !eastAsianMonth.isLeap();
            }
            if (eastAsianMonth.isLeap()) {
                return LEAP_INDICATORS[japaneseCalendar.relgregyear - 701] == eastAsianMonth.getNumber() + 1;
            }
            return true;
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, EastAsianMonth eastAsianMonth, boolean bl2) {
            if (this.isValid(japaneseCalendar, eastAsianMonth)) {
                int n2 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(japaneseCalendar.relgregyear, eastAsianMonth));
                return JapaneseCalendar.create(japaneseCalendar, japaneseCalendar.relgregyear, eastAsianMonth, n2);
            }
            throw new IllegalArgumentException("Invalid month: " + eastAsianMonth);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JapaneseCalendar japaneseCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JapaneseCalendar japaneseCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return SINGLETON_JP;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            if (chronoDisplay.get(CommonElements.RELATED_GREGORIAN_YEAR) >= 1873) {
                int n2 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
                int n3 = chronoDisplay.get(MONTH_OF_YEAR).getNumber();
                if (n2 == 0) {
                    Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
                    TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                    OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                    appendable.append(CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext).print(Month.valueOf(n3)));
                } else {
                    NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                    char c2 = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(numberSystem.getDigits().charAt(0))).charValue();
                    String string = DualFormatElement.toNumeral(numberSystem, c2, n3);
                    if (numberSystem.isDecimal()) {
                        for (int i2 = n2 - string.length(); i2 > 0; --i2) {
                            appendable.append(c2);
                        }
                    }
                    appendable.append(string);
                }
            } else {
                super.print(chronoDisplay, appendable, attributeQuery);
            }
        }

        @Override
        public EastAsianMonth parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n2 = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            int n3 = parsePosition.getIndex();
            if (n2 == 0) {
                TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                TextAccessor textAccessor = CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext);
                Month month = textAccessor.parse(charSequence, parsePosition, Month.class, attributeQuery);
                if (month != null) {
                    return EastAsianMonth.valueOf(month.getValue());
                }
                parsePosition.setIndex(n3);
                parsePosition.setErrorIndex(-1);
            }
            return super.parse(charSequence, parsePosition, attributeQuery);
        }
    }

    public static enum Unit implements ChronoUnit
    {
        ERAS(2.147483647E9),
        YEARS(3.1556952E7),
        MONTHS(2592000.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d2) {
            this.length = d2;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public long between(JapaneseCalendar japaneseCalendar, JapaneseCalendar japaneseCalendar2) {
            return japaneseCalendar.until(japaneseCalendar2, this);
        }
    }

    private static class Merger
    implements ChronoMerger<JapaneseCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return GenericDatePatterns.get("japanese", formatStyle, locale);
        }

        @Override
        public JapaneseCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (JapaneseCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        public JapaneseCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            int n2;
            int n3;
            Nengo nengo = chronoEntity.get(ERA);
            if (nengo == null) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Japanese nengo/era.");
                return null;
            }
            int n4 = chronoEntity.getInt(YEAR_OF_ERA);
            if (n4 == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Japanese year.");
                return null;
            }
            int n5 = nengo.getFirstRelatedGregorianYear() + n4 - 1;
            EastAsianMonth eastAsianMonth = null;
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                eastAsianMonth = chronoEntity.get(MONTH_OF_YEAR);
            } else if (chronoEntity.contains(MONTH_AS_ORDINAL)) {
                n3 = chronoEntity.getInt(MONTH_AS_ORDINAL);
                eastAsianMonth = n5 >= 1873 ? EastAsianMonth.valueOf(n3) : (n3 == (n2 = LEAP_INDICATORS[n5 - 701]) ? EastAsianMonth.valueOf(n3 - 1).withLeap() : (n3 > n2 ? EastAsianMonth.valueOf(n3 - 1) : EastAsianMonth.valueOf(n3)));
            }
            if (eastAsianMonth != null) {
                n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 == Integer.MIN_VALUE) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Japanese day of month.");
                    return null;
                }
                Leniency leniency = bl2 ? Leniency.LAX : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
                return JapaneseCalendar.of(nengo, n4, eastAsianMonth, n3, leniency);
            }
            n3 = chronoEntity.getInt(DAY_OF_YEAR);
            if (n3 != Integer.MIN_VALUE && n3 <= JapaneseCalendar.getLengthOfYear(n5)) {
                try {
                    eastAsianMonth = JapaneseCalendar.getMonth(n5, n3);
                    n2 = JapaneseCalendar.getDayOfMonth(n5, n3);
                    Leniency leniency = bl2 ? Leniency.LAX : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
                    return JapaneseCalendar.of(nengo, n4, eastAsianMonth, n2, leniency);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Japanese date.");
                    return null;
                }
            }
            return null;
        }

        @Override
        public int getDefaultPivotYear() {
            return 100;
        }
    }

    private static class NengoRule
    implements ElementRule<JapaneseCalendar, Nengo> {
        private NengoRule() {
        }

        @Override
        public Nengo getValue(JapaneseCalendar japaneseCalendar) {
            return japaneseCalendar.nengo;
        }

        @Override
        public Nengo getMinimum(JapaneseCalendar japaneseCalendar) {
            return (Nengo)ERA.getDefaultMinimum();
        }

        @Override
        public Nengo getMaximum(JapaneseCalendar japaneseCalendar) {
            return (Nengo)ERA.getDefaultMaximum();
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, Nengo nengo) {
            return nengo != null;
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, Nengo nengo, boolean bl2) {
            int n2;
            int n3;
            int n4 = japaneseCalendar.getYear();
            EastAsianMonth eastAsianMonth = japaneseCalendar.month;
            int n5 = japaneseCalendar.dayOfMonth;
            Optional<Nengo> optional = nengo.findNext();
            if (optional.isPresent() && n4 > (n3 = optional.get().getFirstRelatedGregorianYear() - nengo.getFirstRelatedGregorianYear() + 1)) {
                n4 = n3;
            }
            if ((n3 = n4 - 1 + nengo.getFirstRelatedGregorianYear()) >= 1873) {
                if (eastAsianMonth.isLeap()) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
            } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n3 - 701] == 0) {
                eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
            }
            if (n5 > (n2 = JapaneseCalendar.getLengthOfMonth(n3, eastAsianMonth))) {
                n5 = n2;
            }
            return JapaneseCalendar.of(nengo, n4, eastAsianMonth, n5, bl2 ? Leniency.LAX : Leniency.SMART);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JapaneseCalendar japaneseCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JapaneseCalendar japaneseCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class IntegerRule
    implements IntElementRule<JapaneseCalendar> {
        private final int index;

        IntegerRule(int n2) {
            this.index = n2;
        }

        @Override
        public int getInt(JapaneseCalendar japaneseCalendar) {
            switch (this.index) {
                case 0: {
                    return japaneseCalendar.getYear();
                }
                case 2: {
                    return japaneseCalendar.dayOfMonth;
                }
                case 3: {
                    return japaneseCalendar.dayOfYear;
                }
                case 1: {
                    return JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
                }
                case 4: {
                    return japaneseCalendar.relgregyear;
                }
                case 5: {
                    return japaneseCalendar.relgregyear + 660;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        int getMin() {
            switch (this.index) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return 1;
                }
                case 4: {
                    return 701;
                }
                case 5: {
                    return 1361;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        int getMax(JapaneseCalendar japaneseCalendar) {
            switch (this.index) {
                case 0: {
                    Nengo nengo = japaneseCalendar.nengo;
                    Optional<Nengo> optional = nengo.findNext();
                    if (optional.isPresent()) {
                        return optional.get().getFirstRelatedGregorianYear() - nengo.getFirstRelatedGregorianYear() + 1;
                    }
                    return 1000000000 - Nengo.Element.SINGLETON.getDefaultMaximum().getFirstRelatedGregorianYear();
                }
                case 2: {
                    return JapaneseCalendar.getLengthOfMonth(japaneseCalendar.relgregyear, japaneseCalendar.month);
                }
                case 3: {
                    return JapaneseCalendar.getLengthOfYear(japaneseCalendar.relgregyear);
                }
                case 1: {
                    return japaneseCalendar.relgregyear >= 1873 || LEAP_INDICATORS[japaneseCalendar.relgregyear - 701] == 0 ? 12 : 13;
                }
                case 4: {
                    return 999999999;
                }
                case 5: {
                    return 1000000659;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, int n2) {
            switch (this.index) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    return n2 >= 1 && n2 <= this.getMax(japaneseCalendar);
                }
                case 4: {
                    return japaneseCalendar.relgregyear == n2;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, int n2, boolean bl2) {
            if (this.isValid(japaneseCalendar, n2)) {
                switch (this.index) {
                    case 0: {
                        return IntegerRule.yearsAdded(japaneseCalendar, japaneseCalendar.nengo.getFirstRelatedGregorianYear() + n2 - 1);
                    }
                    case 2: {
                        return JapaneseCalendar.create(japaneseCalendar, japaneseCalendar.relgregyear, japaneseCalendar.month, n2);
                    }
                    case 3: {
                        return new JapaneseCalendar(japaneseCalendar.nengo, japaneseCalendar.relgregyear, n2);
                    }
                    case 1: {
                        byte by2;
                        EastAsianMonth eastAsianMonth = japaneseCalendar.relgregyear >= 1873 ? EastAsianMonth.valueOf(n2) : ((by2 = LEAP_INDICATORS[japaneseCalendar.relgregyear - 701]) == 0 || by2 > n2 ? EastAsianMonth.valueOf(n2) : (n2 == by2 ? EastAsianMonth.valueOf(n2 - 1).withLeap() : EastAsianMonth.valueOf(n2 - 1)));
                        return (JapaneseCalendar)japaneseCalendar.with(MONTH_OF_YEAR, eastAsianMonth);
                    }
                    case 4: {
                        return japaneseCalendar;
                    }
                    case 5: {
                        return IntegerRule.yearsAdded(japaneseCalendar, n2 - 660);
                    }
                }
                throw new UnsupportedOperationException("Unknown element index: " + this.index);
            }
            if (this.index == 4) {
                throw new IllegalArgumentException("The related gregorian year is read-only.");
            }
            throw new IllegalArgumentException("Out of range: " + n2);
        }

        @Override
        public Integer getValue(JapaneseCalendar japaneseCalendar) {
            return this.getInt(japaneseCalendar);
        }

        @Override
        public Integer getMinimum(JapaneseCalendar japaneseCalendar) {
            return this.getMin();
        }

        @Override
        public Integer getMaximum(JapaneseCalendar japaneseCalendar) {
            return this.getMax(japaneseCalendar);
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, Integer n2) {
            return n2 != null && this.isValid(japaneseCalendar, (int)n2);
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Not nullable.");
            }
            return this.withValue(japaneseCalendar, (int)n2, bl2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JapaneseCalendar japaneseCalendar) {
            switch (this.index) {
                case 0: {
                    return MONTH_OF_YEAR;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return null;
                }
                case 1: {
                    return DAY_OF_MONTH;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JapaneseCalendar japaneseCalendar) {
            return this.getChildAtFloor(japaneseCalendar);
        }

        private static JapaneseCalendar yearsAdded(JapaneseCalendar japaneseCalendar, int n2) {
            EastAsianMonth eastAsianMonth = japaneseCalendar.month;
            int n3 = eastAsianMonth.getNumber();
            if (n2 >= 1873) {
                if (eastAsianMonth.isLeap()) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
            } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n2 - 701] != n3 + 1) {
                eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
            }
            int n4 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n2, eastAsianMonth));
            return JapaneseCalendar.create(japaneseCalendar, n2, eastAsianMonth, n4);
        }
    }

    private static class JapaneseUnitRule
    implements UnitRule<JapaneseCalendar> {
        private final Unit unit;

        JapaneseUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public JapaneseCalendar addTo(JapaneseCalendar japaneseCalendar, long l2) {
            switch (this.unit) {
                case ERAS: {
                    try {
                        return JapaneseUnitRule.erasAdded(japaneseCalendar, l2);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new IllegalArgumentException(indexOutOfBoundsException);
                    }
                }
                case YEARS: {
                    try {
                        int n2 = MathUtils.safeAdd(japaneseCalendar.relgregyear, MathUtils.safeCast(l2));
                        EastAsianMonth eastAsianMonth = japaneseCalendar.month;
                        int n3 = eastAsianMonth.getNumber();
                        if (n2 >= 1873) {
                            if (eastAsianMonth.isLeap()) {
                                eastAsianMonth = EastAsianMonth.valueOf(n3);
                            }
                        } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n2 - 701] != n3 + 1) {
                            eastAsianMonth = EastAsianMonth.valueOf(n3);
                        }
                        int n4 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n2, eastAsianMonth));
                        return JapaneseCalendar.create(japaneseCalendar, n2, eastAsianMonth, n4);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new IllegalArgumentException(indexOutOfBoundsException);
                    }
                }
                case MONTHS: {
                    try {
                        int n5;
                        JapaneseUnitRule.checkAmountOfMonths(l2);
                        int n6 = japaneseCalendar.relgregyear;
                        int n7 = JapaneseCalendar.getMonthIndex(n6, japaneseCalendar.month);
                        int n8 = n5 = l2 > 0L ? 1 : -1;
                        while (l2 != 0L) {
                            n7 += n5;
                            if (n6 >= 1873) {
                                if (n7 == 0) {
                                    n7 = --n6 >= 1873 || LEAP_INDICATORS[n6 - 701] == 0 ? 12 : 13;
                                } else if (n7 == 13) {
                                    ++n6;
                                    n7 = 1;
                                }
                            } else if (n7 == 0) {
                                n7 = LEAP_INDICATORS[--n6 - 701] == 0 ? 12 : 13;
                            } else if (n7 > (LEAP_INDICATORS[n6 - 701] == 0 ? 12 : 13)) {
                                ++n6;
                                n7 = 1;
                            }
                            l2 -= (long)n5;
                        }
                        if (n6 >= 1873) {
                            Nengo nengo = Nengo.ofRelatedGregorianYear(n6, Nengo.Selector.MODERN);
                            EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n7);
                            int n9 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n6, eastAsianMonth));
                            return JapaneseCalendar.of(nengo, n6 - nengo.getFirstRelatedGregorianYear() + 1, eastAsianMonth, n9, Leniency.SMART);
                        }
                        int n10 = n7;
                        boolean bl2 = false;
                        byte by2 = LEAP_INDICATORS[n6 - 701];
                        if (by2 > 0) {
                            if (by2 <= n7) {
                                --n10;
                            }
                            if (by2 == n7) {
                                bl2 = true;
                            }
                        }
                        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n10);
                        if (bl2) {
                            eastAsianMonth = eastAsianMonth.withLeap();
                        }
                        int n11 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n6, eastAsianMonth));
                        return JapaneseCalendar.create(japaneseCalendar, n6, eastAsianMonth, n11);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new IllegalArgumentException(indexOutOfBoundsException);
                    }
                }
                case WEEKS: {
                    l2 = MathUtils.safeMultiply(l2, 7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd(CALSYS.transform(japaneseCalendar), l2);
                    JapaneseCalendar japaneseCalendar2 = CALSYS.transform(l3);
                    if (japaneseCalendar.nengo.matches(Nengo.Selector.NORTHERN_COURT)) {
                        japaneseCalendar2 = japaneseCalendar2.tryWithNorthernCourt();
                    }
                    return japaneseCalendar2;
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(JapaneseCalendar japaneseCalendar, JapaneseCalendar japaneseCalendar2) {
            switch (this.unit) {
                case ERAS: {
                    return JapaneseUnitRule.erasBetween(japaneseCalendar, japaneseCalendar2);
                }
                case YEARS: {
                    int n2 = japaneseCalendar2.relgregyear - japaneseCalendar.relgregyear;
                    if (n2 == 0) {
                        return 0L;
                    }
                    int n3 = JapaneseCalendar.getMonthIndex(japaneseCalendar2.relgregyear, japaneseCalendar2.month);
                    int n4 = JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
                    if (n2 > 0) {
                        if (n4 > n3 || n4 == n3 && japaneseCalendar.dayOfMonth > japaneseCalendar2.dayOfMonth) {
                            --n2;
                        }
                    } else if (n4 < n3 || n4 == n3 && japaneseCalendar.dayOfMonth < japaneseCalendar2.dayOfMonth) {
                        ++n2;
                    }
                    return n2;
                }
                case MONTHS: {
                    int n5 = japaneseCalendar2.relgregyear;
                    int n6 = JapaneseCalendar.getMonthIndex(japaneseCalendar2.relgregyear, japaneseCalendar2.month);
                    int n7 = japaneseCalendar.relgregyear;
                    int n8 = JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
                    int n9 = japaneseCalendar2.compareByTime(japaneseCalendar);
                    int n10 = 0;
                    while (n7 != n5 || n8 != n6) {
                        n8 += n9;
                        if (n7 >= 1873) {
                            if (n8 == 0) {
                                n8 = --n7 >= 1873 || LEAP_INDICATORS[n7 - 701] == 0 ? 12 : 13;
                            } else if (n8 == 13) {
                                ++n7;
                                n8 = 1;
                            }
                        } else if (n8 == 0) {
                            n8 = LEAP_INDICATORS[--n7 - 701] == 0 ? 12 : 13;
                        } else if (n8 > (LEAP_INDICATORS[n7 - 701] == 0 ? 12 : 13)) {
                            ++n7;
                            n8 = 1;
                        }
                        JapaneseUnitRule.checkAmountOfMonths(n10 += n9);
                    }
                    if (n10 > 0 && japaneseCalendar.dayOfMonth > japaneseCalendar2.dayOfMonth) {
                        --n10;
                    } else if (n10 < 0 && japaneseCalendar.dayOfMonth < japaneseCalendar2.dayOfMonth) {
                        ++n10;
                    }
                    return n10;
                }
                case WEEKS: {
                    return Unit.DAYS.between(japaneseCalendar, japaneseCalendar2) / 7L;
                }
                case DAYS: {
                    return CALSYS.transform(japaneseCalendar2) - CALSYS.transform(japaneseCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static JapaneseCalendar erasAdded(JapaneseCalendar japaneseCalendar, long l2) {
            int n2;
            int n3;
            Nengo nengo;
            Optional<Nengo> optional;
            Nengo nengo2 = japaneseCalendar.nengo;
            int n4 = japaneseCalendar.getYear();
            EastAsianMonth eastAsianMonth = japaneseCalendar.month;
            int n5 = japaneseCalendar.dayOfMonth;
            if (nengo2.matches(Nengo.Selector.NORTHERN_COURT)) {
                nengo2 = Nengo.ofRelatedGregorianYear(japaneseCalendar.relgregyear);
                n4 = japaneseCalendar.relgregyear - nengo2.getFirstRelatedGregorianYear() + 1;
            }
            if ((optional = (nengo = Nengo.ofIndexOfficial(Math.addExact(nengo2.getIndexOfficial(), MathUtils.safeCast(l2)))).findNext()).isPresent() && n4 > (n3 = optional.get().getFirstRelatedGregorianYear() - nengo.getFirstRelatedGregorianYear() + 1)) {
                n4 = n3;
            }
            if ((n3 = n4 - 1 + nengo.getFirstRelatedGregorianYear()) >= 1873) {
                if (eastAsianMonth.isLeap()) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
            } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n3 - 701] == 0) {
                eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
            }
            if (n5 > (n2 = JapaneseCalendar.getLengthOfMonth(n3, eastAsianMonth))) {
                n5 = n2;
            }
            return JapaneseCalendar.of(nengo, n4, eastAsianMonth, n5);
        }

        private static int erasBetween(JapaneseCalendar japaneseCalendar, JapaneseCalendar japaneseCalendar2) {
            int n2;
            Nengo nengo = japaneseCalendar.nengo;
            int n3 = japaneseCalendar.getYear();
            int n4 = JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
            int n5 = japaneseCalendar.dayOfMonth;
            if (nengo.matches(Nengo.Selector.NORTHERN_COURT)) {
                nengo = Nengo.ofRelatedGregorianYear(japaneseCalendar.relgregyear);
                n3 = japaneseCalendar.relgregyear - nengo.getFirstRelatedGregorianYear() + 1;
            }
            Nengo nengo2 = japaneseCalendar2.nengo;
            int n6 = japaneseCalendar2.getYear();
            int n7 = JapaneseCalendar.getMonthIndex(japaneseCalendar2.relgregyear, japaneseCalendar2.month);
            int n8 = japaneseCalendar2.dayOfMonth;
            if (nengo2.matches(Nengo.Selector.NORTHERN_COURT)) {
                nengo2 = Nengo.ofRelatedGregorianYear(japaneseCalendar2.relgregyear);
                n6 = japaneseCalendar2.relgregyear - nengo2.getFirstRelatedGregorianYear() + 1;
            }
            if ((n2 = nengo2.getIndexOfficial() - nengo.getIndexOfficial()) > 0) {
                if (n3 > n6 || n3 == n6 && (n4 > n7 || n4 == n7 && n5 > n8)) {
                    --n2;
                }
            } else if (n2 < 0 && (n3 < n6 || n3 == n6 && (n4 < n7 || n4 == n7 && n5 < n8))) {
                ++n2;
            }
            return n2;
        }

        private static void checkAmountOfMonths(long l2) {
            if (Math.abs(l2) >= 25000L) {
                throw new ArithmeticException("Month arithmetic limited to delta smaller than 25000.");
            }
        }
    }
}

