/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum HebrewMonth implements ChronoCondition<HebrewCalendar>
{
    TISHRI,
    HESHVAN,
    KISLEV,
    TEVET,
    SHEVAT,
    ADAR_I,
    ADAR_II,
    NISAN,
    IYAR,
    SIVAN,
    TAMUZ,
    AV,
    ELUL;

    private static final HebrewMonth[] ENUMS;
    private static final AttributeKey<Order> ATTRIBUTE;

    public static HebrewMonth valueOfCivil(int n2, boolean bl2) {
        if (n2 < 1 || n2 > 13 || !bl2 && n2 == 13) {
            throw new IllegalArgumentException("Hebrew month out of range: " + n2);
        }
        if (!bl2 && n2 >= 6) {
            return ENUMS[n2];
        }
        return ENUMS[n2 - 1];
    }

    public static HebrewMonth valueOfBiblical(int n2, boolean bl2) {
        if (n2 < 1 || n2 > 13 || !bl2 && n2 == 13) {
            throw new IllegalArgumentException("Hebrew month out of range: " + n2);
        }
        int n3 = n2 + 7;
        if (n3 > 13) {
            n3 -= 13;
        }
        if (!bl2 && n2 == 12) {
            return ADAR_II;
        }
        return ENUMS[n3 - 1];
    }

    public int getCivilValue(boolean bl2) {
        int n2 = this.ordinal() + 1;
        if (!bl2 && n2 >= 7) {
            --n2;
        }
        return n2;
    }

    public int getBiblicalValue(boolean bl2) {
        int n2 = this.ordinal() + 7;
        if (n2 > 13) {
            n2 -= 13;
        }
        if (!bl2 && n2 == 13) {
            n2 = 12;
        }
        return n2;
    }

    public String getDisplayName(Locale locale, boolean bl2) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT, bl2);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl2) {
        CalendarText calendarText = CalendarText.getInstance("hebrew", locale);
        if (bl2 && this == ADAR_II) {
            return calendarText.getLeapMonths(textWidth, outputContext).print(this);
        }
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    @Override
    public boolean test(HebrewCalendar hebrewCalendar) {
        return hebrewCalendar.getMonth() == this;
    }

    public static AttributeKey<Order> order() {
        return ATTRIBUTE;
    }

    static HebrewMonth valueOf(int n2) {
        if (n2 < 1 || n2 > 13) {
            throw new IllegalArgumentException("Hebrew month out of range: " + n2);
        }
        return ENUMS[n2 - 1];
    }

    int getValue() {
        return this.ordinal() + 1;
    }

    static {
        ENUMS = HebrewMonth.values();
        ATTRIBUTE = Attributes.createKey("HEBREW_MONTH_ORDER", Order.class);
    }

    public static enum Order {
        CIVIL,
        BIBLICAL,
        ENUM;

    }
}

