/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.time.Clock;
import java.time.Instant;
import net.time4j.Moment;
import net.time4j.ZonalClock;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TickProvider;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class SystemClock
implements TimeSource<Moment> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final TickProvider PROVIDER;
    private static final boolean MONOTON_MODE;
    public static final SystemClock INSTANCE;
    public static final SystemClock MONOTONIC;
    private final boolean monotonic;
    private final long offset;

    private SystemClock(boolean bl2, long l2) {
        this.monotonic = bl2;
        this.offset = l2;
    }

    @Override
    public Moment currentTime() {
        if ((this.monotonic || MONOTON_MODE) && LeapSeconds.getInstance().isEnabled()) {
            long l2 = this.utcNanos();
            return Moment.of(Math.floorDiv(l2, 1000000000L), (int)Math.floorMod(l2, 1000000000L), TimeScale.UTC);
        }
        long l3 = System.currentTimeMillis();
        int n2 = (int)Math.floorMod(l3, 1000L) * 1000000;
        return Moment.of(Math.floorDiv(l3, 1000L), n2, TimeScale.POSIX);
    }

    public long currentTimeInMillis() {
        if (this.monotonic || MONOTON_MODE) {
            long l2 = this.utcNanos();
            long l3 = LeapSeconds.getInstance().strip(Math.floorDiv(l2, 1000000000L));
            return Math.multiplyExact(l3, 1000L) + Math.floorMod(l2, 1000000L);
        }
        return System.currentTimeMillis();
    }

    public long currentTimeInMicros() {
        if (this.monotonic || MONOTON_MODE) {
            long l2 = this.utcNanos();
            long l3 = LeapSeconds.getInstance().strip(Math.floorDiv(l2, 1000000000L));
            return Math.multiplyExact(l3, 1000000L) + Math.floorMod(l2, 1000L);
        }
        return Math.multiplyExact(System.currentTimeMillis(), 1000L);
    }

    public long realTimeInMicros() {
        if (this.monotonic || MONOTON_MODE) {
            return Math.floorDiv(this.utcNanos(), 1000L);
        }
        long l2 = System.currentTimeMillis();
        long l3 = LeapSeconds.getInstance().enhance(Math.floorDiv(l2, 1000L));
        return Math.multiplyExact(l3, 1000000L) + Math.floorMod(l2, 1000L) * 1000L;
    }

    public static ZonalClock inPlatformView() {
        return new ZonalClock(INSTANCE, Timezone.ofPlatform());
    }

    public static ZonalClock inLocalView() {
        return ZonalClock.ofSystem();
    }

    public static ZonalClock inZonalView(TZID tZID) {
        return new ZonalClock(INSTANCE, tZID);
    }

    public static ZonalClock inZonalView(String string) {
        return new ZonalClock(INSTANCE, string);
    }

    public static Moment currentMoment() {
        return INSTANCE.currentTime();
    }

    public SystemClock recalibrated() {
        return new SystemClock(this.monotonic, SystemClock.calibrate());
    }

    public SystemClock synchronizedWith(TimeSource<?> timeSource) {
        Moment moment = Moment.from(timeSource.currentTime());
        long l2 = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        long l3 = moment.getElapsedTime(TimeScale.UTC);
        long l4 = Math.multiplyExact(l3, 1000000000L) + (long)moment.getNanosecond(TimeScale.UTC);
        long l5 = Math.subtractExact(l4, l2);
        return new SystemClock(this.monotonic, l5);
    }

    private static long calibrate() {
        Instant instant = Clock.systemUTC().instant();
        long l2 = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        long l3 = LeapSeconds.getInstance().enhance(instant.getEpochSecond());
        long l4 = Math.multiplyExact(l3, 1000000000L) + (long)instant.getNano();
        return Math.subtractExact(l4, l2);
    }

    private long utcNanos() {
        long l2 = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        return Math.addExact(l2, this.offset);
    }

    static {
        String string = System.getProperty("java.vm.name");
        TickProvider tickProvider = null;
        for (TickProvider tickProvider2 : ResourceLoader.getInstance().services(TickProvider.class)) {
            if (!string.equals(tickProvider2.getPlatform())) continue;
            tickProvider = tickProvider2;
            break;
        }
        if (tickProvider == null) {
            tickProvider = new StdTickProvider();
        }
        PROVIDER = tickProvider;
        MONOTON_MODE = Boolean.getBoolean("net.time4j.systemclock.nanoTime");
        INSTANCE = new SystemClock(false, SystemClock.calibrate());
        MONOTONIC = new SystemClock(true, SystemClock.calibrate());
    }

    private static class StdTickProvider
    implements TickProvider {
        private StdTickProvider() {
        }

        @Override
        public String getPlatform() {
            return "";
        }

        @Override
        public long getNanos() {
            return System.nanoTime();
        }
    }
}

