/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.DayCycles;
import net.time4j.Duration;
import net.time4j.ElementOperator;
import net.time4j.IsoUnit;
import net.time4j.LongElement;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SPX;
import net.time4j.TemporalType;
import net.time4j.Weekcycle;
import net.time4j.Weekmodel;
import net.time4j.ZonalClock;
import net.time4j.ZonalDateTime;
import net.time4j.base.GregorianDate;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FlagElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.Normalizer;
import net.time4j.engine.Temporal;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.engine.UnitRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.TemporalFormatter;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="iso8601")
public final class PlainTimestamp
extends TimePoint<IsoUnit, PlainTimestamp>
implements GregorianDate,
WallTime,
Temporal<PlainTimestamp>,
ThreetenAdapter,
Normalizer<IsoUnit>,
LocalizedPatternSupport {
    private static final int MRD = 1000000000;
    private static final PlainTimestamp MIN = new PlainTimestamp(PlainDate.MIN, PlainTime.MIN);
    private static final PlainTimestamp MAX = new PlainTimestamp(PlainDate.MAX, PlainTime.WALL_TIME.getDefaultMaximum());
    private static final Map<CalendarUnit, UnitRule<PlainTimestamp>> CALENDAR_UNIT_RULE_MAP;
    private static final Map<ClockUnit, UnitRule<PlainTimestamp>> CLOCK_UNIT_RULE_MAP;
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final TimeAxis<IsoUnit, PlainTimestamp> ENGINE;
    private static final TimeMetric<IsoUnit, Duration<IsoUnit>> STD_METRIC;
    private static final Chronology<LocalDateTime> THREETEN;
    private static final long serialVersionUID = 7458380065762437714L;
    private final transient PlainDate date;
    private final transient PlainTime time;

    private PlainTimestamp(PlainDate plainDate, PlainTime plainTime) {
        if (plainTime.getHour() == 24) {
            this.date = plainDate.plus(1L, CalendarUnit.DAYS);
            this.time = PlainTime.MIN;
        } else {
            if (plainDate == null) {
                throw new NullPointerException("Missing date.");
            }
            this.date = plainDate;
            this.time = plainTime;
        }
    }

    public static PlainTimestamp of(PlainDate plainDate, PlainTime plainTime) {
        return new PlainTimestamp(plainDate, plainTime);
    }

    public static PlainTimestamp of(int n2, int n3, int n4, int n5, int n6) {
        return PlainTimestamp.of(n2, n3, n4, n5, n6, 0);
    }

    public static PlainTimestamp of(int n2, int n3, int n4, int n5, int n6, int n7) {
        return PlainTimestamp.of(PlainDate.of(n2, n3, n4), PlainTime.of(n5, n6, n7));
    }

    public static PlainTimestamp nowInSystemTime() {
        return ZonalClock.ofSystem().now();
    }

    public static PlainTimestamp from(LocalDateTime localDateTime) {
        return TemporalType.LOCAL_DATE_TIME.translate(localDateTime);
    }

    public PlainDate getCalendarDate() {
        return this.date;
    }

    public PlainTime getWallTime() {
        return this.time;
    }

    @Override
    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public int getMonth() {
        return this.date.getMonth();
    }

    @Override
    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    @Override
    public int getHour() {
        return this.time.getHour();
    }

    @Override
    public int getMinute() {
        return this.time.getMinute();
    }

    @Override
    public int getSecond() {
        return this.time.getSecond();
    }

    @Override
    public int getNanosecond() {
        return this.time.getNanosecond();
    }

    @Override
    public PlainTimestamp with(ElementOperator<?> elementOperator) {
        return this.with(elementOperator.onTimestamp());
    }

    public PlainTimestamp with(PlainDate plainDate) {
        return (PlainTimestamp)this.with(PlainDate.CALENDAR_DATE, plainDate);
    }

    public PlainTimestamp with(PlainTime plainTime) {
        return (PlainTimestamp)this.with(PlainTime.WALL_TIME, plainTime);
    }

    @Override
    public boolean isBefore(PlainTimestamp plainTimestamp) {
        return this.compareTo(plainTimestamp) < 0;
    }

    @Override
    public boolean isAfter(PlainTimestamp plainTimestamp) {
        return this.compareTo(plainTimestamp) > 0;
    }

    @Override
    public boolean isSimultaneous(PlainTimestamp plainTimestamp) {
        return this.compareTo(plainTimestamp) == 0;
    }

    @Override
    public int compareTo(PlainTimestamp plainTimestamp) {
        if (this.date.isAfter(plainTimestamp.date)) {
            return 1;
        }
        if (this.date.isBefore(plainTimestamp.date)) {
            return -1;
        }
        return this.time.compareTo(plainTimestamp.time);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PlainTimestamp) {
            PlainTimestamp plainTimestamp = (PlainTimestamp)object;
            return this.date.equals(plainTimestamp.date) && this.time.equals(plainTimestamp.time);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 13 * this.date.hashCode() + 37 * this.time.hashCode();
    }

    @Override
    public String toString() {
        return this.date.toString() + this.time.toString();
    }

    public PlainDate toDate() {
        return this.date;
    }

    public PlainTime toTime() {
        return this.time;
    }

    public String print(TemporalFormatter<PlainTimestamp> temporalFormatter) {
        return temporalFormatter.print(this);
    }

    public static PlainTimestamp parse(String string, TemporalFormatter<PlainTimestamp> temporalFormatter) {
        try {
            return temporalFormatter.parse(string);
        }
        catch (ParseException parseException) {
            throw new ChronoException(parseException.getMessage(), parseException);
        }
    }

    @Override
    public LocalDateTime toTemporalAccessor() {
        return TemporalType.LOCAL_DATE_TIME.from(this);
    }

    public static TimeAxis<IsoUnit, PlainTimestamp> axis() {
        return ENGINE;
    }

    public static Chronology<LocalDateTime> threeten() {
        return THREETEN;
    }

    public Moment atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    public Moment at(ZonalOffset zonalOffset) {
        long l2 = MathUtils.safeMultiply(this.date.getDaysSinceUTC() + 730L, 86400L);
        l2 += (long)(this.time.getHour() * 3600);
        l2 += (long)(this.time.getMinute() * 60);
        int n2 = this.time.getNanosecond();
        long l3 = (l2 += (long)this.time.getSecond()) - (long)zonalOffset.getIntegralAmount();
        int n3 = n2 - zonalOffset.getFractionalAmount();
        if (n3 < 0) {
            n3 += 1000000000;
            --l3;
        } else if (n3 >= 1000000000) {
            n3 -= 1000000000;
            ++l3;
        }
        return Moment.of(l3, n3, TimeScale.POSIX);
    }

    public Moment inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    public Moment inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    public Moment in(Timezone timezone) {
        if (timezone.isFixed()) {
            return this.at(timezone.getOffset(this.date, this.time));
        }
        TransitionStrategy transitionStrategy = timezone.getStrategy();
        long l2 = transitionStrategy.resolve(this.date, this.time, timezone);
        Moment moment = Moment.of(l2, this.time.getNanosecond(), TimeScale.POSIX);
        if (transitionStrategy == Timezone.STRICT_MODE) {
            Moment.checkNegativeLS(l2, this);
        }
        return moment;
    }

    public ZonalDateTime inLocalView() {
        return this.inZonalView(Timezone.ofSystem());
    }

    public ZonalDateTime inZonalView(Timezone timezone) {
        Moment moment = this.in(timezone);
        return ZonalDateTime.of(moment, timezone);
    }

    public boolean isValid(TZID tZID) {
        if (tZID == null) {
            return false;
        }
        return !Timezone.of(tZID).isInvalid(this.date, this.time);
    }

    @Override
    public Duration<IsoUnit> normalize(TimeSpan<? extends IsoUnit> timeSpan) {
        return this.until((PlainTimestamp)this.plus(timeSpan), STD_METRIC);
    }

    @Override
    public PlainTimestamp plus(long l2, CalendarUnit calendarUnit) {
        if (calendarUnit == null) {
            throw new NullPointerException("Missing unit.");
        }
        if (l2 == 0L) {
            return this;
        }
        try {
            return CALENDAR_UNIT_RULE_MAP.get(calendarUnit).addTo(this, l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    @Override
    public PlainTimestamp plus(long l2, ClockUnit clockUnit) {
        if (clockUnit == null) {
            throw new NullPointerException("Missing unit.");
        }
        if (l2 == 0L) {
            return this;
        }
        try {
            return CLOCK_UNIT_RULE_MAP.get(clockUnit).addTo(this, l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    @Override
    public PlainTimestamp minus(long l2, CalendarUnit calendarUnit) {
        return this.plus(Math.negateExact(l2), calendarUnit);
    }

    @Override
    public PlainTimestamp minus(long l2, ClockUnit clockUnit) {
        return this.plus(Math.negateExact(l2), clockUnit);
    }

    @Override
    protected TimeAxis<IsoUnit, PlainTimestamp> getChronology() {
        return ENGINE;
    }

    @Override
    protected PlainTimestamp getContext() {
        return this;
    }

    static PlainTimestamp from(UnixTime unixTime, ZonalOffset zonalOffset) {
        long l2 = unixTime.getPosixTime() + (long)zonalOffset.getIntegralAmount();
        int n2 = unixTime.getNanosecond() + zonalOffset.getFractionalAmount();
        if (n2 < 0) {
            n2 += 1000000000;
            --l2;
        } else if (n2 >= 1000000000) {
            n2 -= 1000000000;
            ++l2;
        }
        PlainDate plainDate = PlainDate.of(MathUtils.floorDivide(l2, 86400), EpochDays.UNIX);
        int n3 = MathUtils.floorModulo(l2, 86400);
        int n4 = n3 % 60;
        int n5 = n3 / 60;
        int n6 = n5 % 60;
        int n7 = n5 / 60;
        PlainTime plainTime = PlainTime.of(n7, n6, n4, n2);
        return PlainTimestamp.of(plainDate, plainTime);
    }

    private static void registerCalendarUnits(TimeAxis.Builder<IsoUnit, PlainTimestamp> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit(calendarUnit, CALENDAR_UNIT_RULE_MAP.get(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo(CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private static void registerClockUnits(TimeAxis.Builder<IsoUnit, PlainTimestamp> builder) {
        for (ClockUnit clockUnit : ClockUnit.values()) {
            builder.appendUnit(clockUnit, CLOCK_UNIT_RULE_MAP.get(clockUnit), clockUnit.getLength(), EnumSet.allOf(ClockUnit.class));
        }
    }

    private static void registerExtensions(TimeAxis.Builder<IsoUnit, PlainTimestamp> builder) {
        for (ChronoExtension chronoExtension : PlainDate.axis().getExtensions()) {
            builder.appendExtension(chronoExtension);
        }
        for (ChronoExtension chronoExtension : PlainTime.axis().getExtensions()) {
            builder.appendExtension(chronoExtension);
        }
    }

    private Object writeReplace() {
        return new SPX(this, 8);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        EnumMap<CalendarUnit, UnitRule<PlainTimestamp>> enumMap = new EnumMap<CalendarUnit, UnitRule<PlainTimestamp>>(CalendarUnit.class);
        EnumMap<ClockUnit, UnitRule<PlainTimestamp>> enumMap2 = new EnumMap<ClockUnit, UnitRule<PlainTimestamp>>(ClockUnit.class);
        for (CalendarUnit enum_ : CalendarUnit.values()) {
            enumMap.put(enum_, new CompositeUnitRule(enum_));
        }
        for (Enum enum_ : ClockUnit.values()) {
            enumMap2.put((ClockUnit)enum_, new CompositeUnitRule((ClockUnit)enum_));
        }
        CALENDAR_UNIT_RULE_MAP = enumMap;
        CLOCK_UNIT_RULE_MAP = enumMap2;
        HashMap hashMap = new HashMap();
        hashMap.put(PlainDate.CALENDAR_DATE, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.YEAR, PlainDate.MONTH_AS_NUMBER);
        hashMap.put(PlainDate.YEAR_OF_WEEKDATE, Weekmodel.ISO.weekOfYear());
        hashMap.put(PlainDate.QUARTER_OF_YEAR, PlainDate.DAY_OF_QUARTER);
        hashMap.put(PlainDate.MONTH_OF_YEAR, PlainDate.DAY_OF_MONTH);
        hashMap.put(PlainDate.MONTH_AS_NUMBER, PlainDate.DAY_OF_MONTH);
        hashMap.put(PlainDate.DAY_OF_MONTH, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.DAY_OF_WEEK, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.DAY_OF_YEAR, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.DAY_OF_QUARTER, PlainTime.WALL_TIME);
        hashMap.put(PlainDate.WEEKDAY_IN_MONTH, PlainTime.WALL_TIME);
        hashMap.put(PlainTime.AM_PM_OF_DAY, PlainTime.DIGITAL_HOUR_OF_AMPM);
        hashMap.put(PlainTime.CLOCK_HOUR_OF_AMPM, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.CLOCK_HOUR_OF_DAY, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.DIGITAL_HOUR_OF_AMPM, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.DIGITAL_HOUR_OF_DAY, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.HOUR_FROM_0_TO_24, PlainTime.MINUTE_OF_HOUR);
        hashMap.put(PlainTime.MINUTE_OF_HOUR, PlainTime.SECOND_OF_MINUTE);
        hashMap.put(PlainTime.MINUTE_OF_DAY, PlainTime.SECOND_OF_MINUTE);
        hashMap.put(PlainTime.SECOND_OF_MINUTE, PlainTime.NANO_OF_SECOND);
        hashMap.put(PlainTime.SECOND_OF_DAY, PlainTime.NANO_OF_SECOND);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(IsoUnit.class, PlainTimestamp.class, new Merger(), MIN, MAX).appendElement(PlainDate.CALENDAR_DATE, FieldRule.of(PlainDate.CALENDAR_DATE), CalendarUnit.DAYS).appendElement(PlainDate.YEAR, new IntFieldRule(PlainDate.YEAR), CalendarUnit.YEARS).appendElement(PlainDate.YEAR_OF_WEEKDATE, new IntFieldRule(PlainDate.YEAR_OF_WEEKDATE), Weekcycle.YEARS).appendElement(PlainDate.QUARTER_OF_YEAR, FieldRule.of(PlainDate.QUARTER_OF_YEAR), CalendarUnit.QUARTERS).appendElement(PlainDate.MONTH_OF_YEAR, FieldRule.of(PlainDate.MONTH_OF_YEAR), CalendarUnit.MONTHS).appendElement(PlainDate.MONTH_AS_NUMBER, new IntFieldRule(PlainDate.MONTH_AS_NUMBER), CalendarUnit.MONTHS).appendElement(PlainDate.DAY_OF_MONTH, new IntFieldRule(PlainDate.DAY_OF_MONTH), CalendarUnit.DAYS).appendElement(PlainDate.DAY_OF_WEEK, FieldRule.of(PlainDate.DAY_OF_WEEK), CalendarUnit.DAYS).appendElement(PlainDate.DAY_OF_YEAR, new IntFieldRule(PlainDate.DAY_OF_YEAR), CalendarUnit.DAYS).appendElement(PlainDate.DAY_OF_QUARTER, new IntFieldRule(PlainDate.DAY_OF_QUARTER), CalendarUnit.DAYS).appendElement(PlainDate.WEEKDAY_IN_MONTH, new IntFieldRule(PlainDate.WEEKDAY_IN_MONTH), CalendarUnit.WEEKS).appendElement((ChronoElement)PlainTime.WALL_TIME, (ElementRule)FieldRule.of(PlainTime.WALL_TIME))).appendElement((ChronoElement)PlainTime.AM_PM_OF_DAY, FieldRule.of(PlainTime.AM_PM_OF_DAY))).appendElement(PlainTime.CLOCK_HOUR_OF_AMPM, new IntFieldRule(PlainTime.CLOCK_HOUR_OF_AMPM), ClockUnit.HOURS).appendElement(PlainTime.CLOCK_HOUR_OF_DAY, new IntFieldRule(PlainTime.CLOCK_HOUR_OF_DAY), ClockUnit.HOURS).appendElement(PlainTime.DIGITAL_HOUR_OF_AMPM, new IntFieldRule(PlainTime.DIGITAL_HOUR_OF_AMPM), ClockUnit.HOURS).appendElement(PlainTime.DIGITAL_HOUR_OF_DAY, new IntFieldRule(PlainTime.DIGITAL_HOUR_OF_DAY), ClockUnit.HOURS).appendElement(PlainTime.HOUR_FROM_0_TO_24, new IntFieldRule(PlainTime.HOUR_FROM_0_TO_24), ClockUnit.HOURS).appendElement(PlainTime.MINUTE_OF_HOUR, new IntFieldRule(PlainTime.MINUTE_OF_HOUR), ClockUnit.MINUTES).appendElement(PlainTime.MINUTE_OF_DAY, new IntFieldRule(PlainTime.MINUTE_OF_DAY), ClockUnit.MINUTES).appendElement(PlainTime.SECOND_OF_MINUTE, new IntFieldRule(PlainTime.SECOND_OF_MINUTE), ClockUnit.SECONDS).appendElement(PlainTime.SECOND_OF_DAY, new IntFieldRule(PlainTime.SECOND_OF_DAY), ClockUnit.SECONDS).appendElement(PlainTime.MILLI_OF_SECOND, new IntFieldRule(PlainTime.MILLI_OF_SECOND), ClockUnit.MILLIS).appendElement(PlainTime.MICRO_OF_SECOND, new IntFieldRule(PlainTime.MICRO_OF_SECOND), ClockUnit.MICROS).appendElement(PlainTime.NANO_OF_SECOND, new IntFieldRule(PlainTime.NANO_OF_SECOND), ClockUnit.NANOS).appendElement(PlainTime.MILLI_OF_DAY, new IntFieldRule(PlainTime.MILLI_OF_DAY), ClockUnit.MILLIS).appendElement(PlainTime.MICRO_OF_DAY, FieldRule.of(PlainTime.MICRO_OF_DAY), ClockUnit.MICROS).appendElement(PlainTime.NANO_OF_DAY, FieldRule.of(PlainTime.NANO_OF_DAY), ClockUnit.NANOS).appendElement((ChronoElement)PlainTime.DECIMAL_HOUR, (ElementRule)new DecimalRule(PlainTime.DECIMAL_HOUR))).appendElement((ChronoElement)PlainTime.DECIMAL_MINUTE, (ElementRule)new DecimalRule(PlainTime.DECIMAL_MINUTE))).appendElement((ChronoElement)PlainTime.DECIMAL_SECOND, (ElementRule)new DecimalRule(PlainTime.DECIMAL_SECOND))).appendElement((ChronoElement)PlainTime.PRECISION, FieldRule.of(PlainTime.PRECISION));
        PlainTimestamp.registerCalendarUnits((TimeAxis.Builder<IsoUnit, PlainTimestamp>)builder);
        PlainTimestamp.registerClockUnits((TimeAxis.Builder<IsoUnit, PlainTimestamp>)builder);
        PlainTimestamp.registerExtensions((TimeAxis.Builder<IsoUnit, PlainTimestamp>)builder);
        ENGINE = ((TimeAxis.Builder)builder).build();
        IsoUnit[] isoUnitArray = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS};
        STD_METRIC = Duration.in((IsoUnit[])isoUnitArray);
        THREETEN = new BridgeChronology<LocalDateTime, PlainTimestamp>(TemporalType.LOCAL_DATE_TIME, ENGINE);
    }

    private static class CompositeUnitRule
    implements UnitRule<PlainTimestamp> {
        private final CalendarUnit calendarUnit;
        private final ClockUnit clockUnit;

        CompositeUnitRule(CalendarUnit calendarUnit) {
            this.calendarUnit = calendarUnit;
            this.clockUnit = null;
        }

        CompositeUnitRule(ClockUnit clockUnit) {
            this.calendarUnit = null;
            this.clockUnit = clockUnit;
        }

        @Override
        public PlainTimestamp addTo(PlainTimestamp plainTimestamp, long l2) {
            PlainTime plainTime;
            PlainDate plainDate;
            if (this.calendarUnit != null) {
                plainDate = plainTimestamp.date.plus(l2, this.calendarUnit);
                plainTime = plainTimestamp.time;
            } else {
                DayCycles dayCycles = plainTimestamp.time.roll(l2, this.clockUnit);
                plainDate = plainTimestamp.date.plus(dayCycles.getDayOverflow(), CalendarUnit.DAYS);
                plainTime = dayCycles.getWallTime();
            }
            return PlainTimestamp.of(plainDate, plainTime);
        }

        @Override
        public long between(PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
            long l2;
            if (this.calendarUnit != null) {
                l2 = this.calendarUnit.between(plainTimestamp.date, plainTimestamp2.date);
                if (l2 != 0L) {
                    TimePoint timePoint;
                    boolean bl2;
                    if (this.calendarUnit == CalendarUnit.DAYS) {
                        bl2 = true;
                    } else {
                        timePoint = plainTimestamp.date.plus(l2, this.calendarUnit);
                        boolean bl3 = bl2 = ((PlainDate)timePoint).compareByTime(plainTimestamp2.date) == 0;
                    }
                    if (bl2) {
                        timePoint = plainTimestamp.time;
                        PlainTime plainTime = plainTimestamp2.time;
                        if (l2 > 0L && ((PlainTime)timePoint).isAfter(plainTime)) {
                            --l2;
                        } else if (l2 < 0L && ((PlainTime)timePoint).isBefore(plainTime)) {
                            ++l2;
                        }
                    }
                }
            } else if (plainTimestamp.date.isAfter(plainTimestamp2.date)) {
                l2 = -this.between(plainTimestamp2, plainTimestamp);
            } else {
                long l3 = plainTimestamp.date.until(plainTimestamp2.date, CalendarUnit.DAYS);
                assert (this.clockUnit != null);
                if (l3 == 0L) {
                    return this.clockUnit.between(plainTimestamp.time, plainTimestamp2.time);
                }
                if (this.clockUnit.compareTo(ClockUnit.SECONDS) <= 0) {
                    l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l3, 86400L), MathUtils.safeSubtract(((Integer)plainTimestamp2.time.get(PlainTime.SECOND_OF_DAY)).longValue(), ((Integer)plainTimestamp.time.get(PlainTime.SECOND_OF_DAY)).longValue()));
                    if (plainTimestamp.time.getNanosecond() > plainTimestamp2.time.getNanosecond()) {
                        --l2;
                    }
                } else {
                    l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l3, 86400000000000L), MathUtils.safeSubtract((Long)plainTimestamp2.time.get(PlainTime.NANO_OF_DAY), (Long)plainTimestamp.time.get(PlainTime.NANO_OF_DAY)));
                }
                switch (this.clockUnit) {
                    case HOURS: {
                        l2 /= 3600L;
                        break;
                    }
                    case MINUTES: {
                        l2 /= 60L;
                        break;
                    }
                    case SECONDS: {
                        break;
                    }
                    case MILLIS: {
                        l2 /= 1000000L;
                        break;
                    }
                    case MICROS: {
                        l2 /= 1000L;
                        break;
                    }
                    case NANOS: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.clockUnit.name());
                    }
                }
            }
            return l2;
        }
    }

    private static class Merger
    implements ChronoMerger<PlainTimestamp> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
            return CalendarText.patternForTimestamp(formatStyle, formatStyle, locale);
        }

        @Override
        public PlainTimestamp createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID));
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            Object obj = timeSource.currentTime();
            return PlainTimestamp.from(obj, timezone.getOffset((UnixTime)obj));
        }

        @Override
        public PlainTimestamp createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl2, boolean bl3) {
            PlainTime plainTime;
            PlainDate plainDate;
            boolean bl4;
            if (chronoEntity instanceof UnixTime) {
                TZID tZID;
                if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                    tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
                } else if (bl2) {
                    tZID = ZonalOffset.UTC;
                } else {
                    throw new IllegalArgumentException("Missing timezone attribute for type conversion.");
                }
                Moment moment = Moment.from((UnixTime)UnixTime.class.cast(chronoEntity));
                return moment.toZonalTimestamp(tZID);
            }
            boolean bl5 = bl4 = bl3 && chronoEntity.getInt(PlainTime.SECOND_OF_MINUTE) == 60;
            if (bl4) {
                chronoEntity.with((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE, 59);
            }
            if ((plainDate = chronoEntity.contains(PlainDate.CALENDAR_DATE) ? chronoEntity.get(PlainDate.CALENDAR_DATE) : (PlainDate)PlainDate.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, false)) == null) {
                return null;
            }
            if (chronoEntity.contains(PlainTime.WALL_TIME)) {
                plainTime = chronoEntity.get(PlainTime.WALL_TIME);
            } else {
                plainTime = (PlainTime)PlainTime.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, false);
                if (plainTime == null && bl2) {
                    plainTime = PlainTime.MIN;
                }
            }
            if (plainTime == null) {
                return null;
            }
            if (chronoEntity.contains(LongElement.DAY_OVERFLOW)) {
                plainDate = plainDate.plus((long)chronoEntity.get(LongElement.DAY_OVERFLOW), CalendarUnit.DAYS);
            }
            if (bl4 && chronoEntity.isValid(FlagElement.LEAP_SECOND, Boolean.TRUE)) {
                chronoEntity.with(FlagElement.LEAP_SECOND, Boolean.TRUE);
            }
            return PlainTimestamp.of(plainDate, plainTime);
        }
    }

    private static class FieldRule<V>
    implements ElementRule<PlainTimestamp, V> {
        final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        @Override
        public V getValue(PlainTimestamp plainTimestamp) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.get(this.element);
            }
            if (this.element.isTimeElement()) {
                return plainTimestamp.time.get(this.element);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public V getMinimum(PlainTimestamp plainTimestamp) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.getMinimum(this.element);
            }
            if (this.element.isTimeElement()) {
                return this.element.getDefaultMinimum();
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public V getMaximum(PlainTimestamp plainTimestamp) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.getMaximum(this.element);
            }
            if (this.element.isTimeElement()) {
                return this.element.getDefaultMaximum();
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public boolean isValid(PlainTimestamp plainTimestamp, V v2) {
            if (v2 == null) {
                return false;
            }
            if (this.element.isDateElement()) {
                return plainTimestamp.date.isValid(this.element, v2);
            }
            if (this.element.isTimeElement()) {
                if (Number.class.isAssignableFrom(this.element.getType())) {
                    long l2 = this.toNumber(this.element.getDefaultMinimum());
                    long l3 = this.toNumber(this.element.getDefaultMaximum());
                    long l4 = this.toNumber(v2);
                    return l2 <= l4 && l3 >= l4;
                }
                if (this.element.equals(PlainTime.WALL_TIME) && PlainTime.MAX.equals(v2)) {
                    return false;
                }
                return plainTimestamp.time.isValid(this.element, v2);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public PlainTimestamp withValue(PlainTimestamp plainTimestamp, V v2, boolean bl2) {
            if (v2 == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            if (v2.equals(this.getValue(plainTimestamp))) {
                return plainTimestamp;
            }
            if (bl2) {
                IsoUnit isoUnit = (IsoUnit)ENGINE.getBaseUnit(this.element);
                long l2 = this.toNumber(this.getValue(plainTimestamp));
                long l3 = this.toNumber(v2);
                long l4 = MathUtils.safeSubtract(l3, l2);
                return (PlainTimestamp)plainTimestamp.plus(l4, isoUnit);
            }
            if (this.element.isDateElement()) {
                PlainDate plainDate = (PlainDate)plainTimestamp.date.with(this.element, v2);
                return PlainTimestamp.of(plainDate, plainTimestamp.time);
            }
            if (this.element.isTimeElement()) {
                if (Number.class.isAssignableFrom(this.element.getType())) {
                    long l5 = this.toNumber(this.element.getDefaultMinimum());
                    long l6 = this.toNumber(this.element.getDefaultMaximum());
                    long l7 = this.toNumber(v2);
                    if (l5 > l7 || l6 < l7) {
                        throw new IllegalArgumentException("Out of range: " + v2);
                    }
                } else if (this.element.equals(PlainTime.WALL_TIME) && v2.equals(PlainTime.MAX)) {
                    throw new IllegalArgumentException("Out of range: " + v2);
                }
                PlainTime plainTime = (PlainTime)plainTimestamp.time.with(this.element, v2);
                return PlainTimestamp.of(plainTimestamp.date, plainTime);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTimestamp plainTimestamp) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTimestamp plainTimestamp) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private long toNumber(V v2) {
            return ((Number)Number.class.cast(v2)).longValue();
        }
    }

    private static class IntFieldRule
    extends FieldRule<Integer>
    implements IntElementRule<PlainTimestamp> {
        private IntFieldRule(ChronoElement<Integer> chronoElement) {
            super(chronoElement);
        }

        @Override
        public int getInt(PlainTimestamp plainTimestamp) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.getInt(this.element);
            }
            if (this.element.isTimeElement()) {
                return plainTimestamp.time.getInt(this.element);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public boolean isValid(PlainTimestamp plainTimestamp, int n2) {
            if (this.element.isDateElement()) {
                return plainTimestamp.date.isValid(this.element, n2);
            }
            if (this.element.isTimeElement()) {
                int n3 = (Integer)this.element.getDefaultMinimum();
                int n4 = (Integer)this.element.getDefaultMaximum();
                return n3 <= n2 && n4 >= n2;
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public PlainTimestamp withValue(PlainTimestamp plainTimestamp, int n2, boolean bl2) {
            if (n2 == this.getInt(plainTimestamp)) {
                return plainTimestamp;
            }
            if (bl2) {
                IsoUnit isoUnit = (IsoUnit)ENGINE.getBaseUnit(this.element);
                long l2 = MathUtils.safeSubtract((long)n2, (long)this.getInt(plainTimestamp));
                return (PlainTimestamp)plainTimestamp.plus(l2, isoUnit);
            }
            if (this.element.isDateElement()) {
                PlainDate plainDate = (PlainDate)plainTimestamp.date.with(this.element, n2);
                return PlainTimestamp.of(plainDate, plainTimestamp.time);
            }
            if (this.element.isTimeElement()) {
                int n3 = (Integer)this.element.getDefaultMinimum();
                int n4 = (Integer)this.element.getDefaultMaximum();
                if (n3 > n2 || n4 < n2) {
                    throw new IllegalArgumentException("Out of range: " + n2);
                }
                PlainTime plainTime = (PlainTime)plainTimestamp.time.with(this.element, n2);
                return PlainTimestamp.of(plainTimestamp.date, plainTime);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }
    }

    private static class DecimalRule
    extends FieldRule<BigDecimal> {
        DecimalRule(ChronoElement<BigDecimal> chronoElement) {
            super(chronoElement);
        }

        @Override
        public boolean isValid(PlainTimestamp plainTimestamp, BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                return false;
            }
            BigDecimal bigDecimal2 = (BigDecimal)this.element.getDefaultMinimum();
            BigDecimal bigDecimal3 = (BigDecimal)this.element.getDefaultMaximum();
            return bigDecimal2.compareTo(bigDecimal) <= 0 && bigDecimal.compareTo(bigDecimal3) <= 0;
        }

        @Override
        public PlainTimestamp withValue(PlainTimestamp plainTimestamp, BigDecimal bigDecimal, boolean bl2) {
            if (!this.isValid(plainTimestamp, bigDecimal)) {
                throw new IllegalArgumentException("Out of range: " + bigDecimal);
            }
            PlainTime plainTime = (PlainTime)plainTimestamp.time.with(this.element, bigDecimal);
            return PlainTimestamp.of(plainTimestamp.date, plainTime);
        }
    }
}

