/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import net.time4j.AbstractTimeElement;
import net.time4j.PlainTime;
import net.time4j.ProportionalElement;
import net.time4j.ProportionalFunction;
import net.time4j.RoundingOperator;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;

final class IntegerTimeElement
extends AbstractTimeElement<Integer>
implements ProportionalElement<Integer, PlainTime> {
    static final int CLOCK_HOUR_OF_AMPM = 1;
    static final int CLOCK_HOUR_OF_DAY = 2;
    static final int DIGITAL_HOUR_OF_AMPM = 3;
    static final int DIGITAL_HOUR_OF_DAY = 4;
    static final int ISO_HOUR = 5;
    static final int MINUTE_OF_HOUR = 6;
    static final int MINUTE_OF_DAY = 7;
    static final int SECOND_OF_MINUTE = 8;
    static final int SECOND_OF_DAY = 9;
    static final int MILLI_OF_SECOND = 10;
    static final int MICRO_OF_SECOND = 11;
    static final int NANO_OF_SECOND = 12;
    static final int MILLI_OF_DAY = 13;
    private static final long serialVersionUID = -1337148214680014674L;
    private final transient int ruleIndex;
    private final transient Integer defaultMin;
    private final transient Integer defaultMax;
    private final transient char symbol;
    private final transient ChronoFunction<ChronoEntity<?>, BigDecimal> rf;

    private IntegerTimeElement(String string, int n2, Integer n3, Integer n4, char c2) {
        super(string);
        boolean bl2;
        this.ruleIndex = n2;
        this.defaultMin = n3;
        this.defaultMax = n4;
        this.symbol = c2;
        switch (n2) {
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        this.rf = new ProportionalFunction(this, bl2);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public Integer getDefaultMinimum() {
        return this.defaultMin;
    }

    @Override
    public Integer getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public ChronoFunction<ChronoEntity<?>, BigDecimal> ratio() {
        return this.rf;
    }

    @Override
    public ChronoOperator<PlainTime> roundedUp(int n2) {
        return new RoundingOperator<PlainTime>(this, Boolean.TRUE, n2);
    }

    @Override
    public ChronoOperator<PlainTime> roundedHalf(int n2) {
        return new RoundingOperator<PlainTime>(this, null, n2);
    }

    @Override
    public ChronoOperator<PlainTime> roundedDown(int n2) {
        return new RoundingOperator<PlainTime>(this, Boolean.FALSE, n2);
    }

    @Override
    protected boolean isSingleton() {
        return true;
    }

    int getRuleIndex() {
        return this.ruleIndex;
    }

    static IntegerTimeElement createTimeElement(String string, int n2, int n3, int n4, char c2) {
        return new IntegerTimeElement(string, n2, n3, n4, c2);
    }

    static IntegerTimeElement createClockElement(String string, boolean bl2) {
        return new IntegerTimeElement(string, bl2 ? 2 : 1, 1, bl2 ? 24 : 12, bl2 ? (char)'k' : 'h');
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainTime.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

