/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Locale;
import java.util.MissingResourceException;
import net.time4j.Weekday;
import net.time4j.format.PluralCategory;
import net.time4j.format.RelativeTimeProvider;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.PropertyBundle;

final class DefaultUnitPatternProviderSPI
implements RelativeTimeProvider {
    DefaultUnitPatternProviderSPI() {
    }

    @Override
    public String getYearPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'Y', textWidth, pluralCategory);
    }

    @Override
    public String getMonthPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'M', textWidth, pluralCategory);
    }

    @Override
    public String getWeekPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'W', textWidth, pluralCategory);
    }

    @Override
    public String getDayPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'D', textWidth, pluralCategory);
    }

    @Override
    public String getHourPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'H', textWidth, pluralCategory);
    }

    @Override
    public String getMinutePattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'N', textWidth, pluralCategory);
    }

    @Override
    public String getSecondPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'S', textWidth, pluralCategory);
    }

    @Override
    public String getMilliPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, '3', textWidth, pluralCategory);
    }

    @Override
    public String getMicroPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, '6', textWidth, pluralCategory);
    }

    @Override
    public String getNanoPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, '9', textWidth, pluralCategory);
    }

    @Override
    public String getYearPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'Y', bl2, pluralCategory);
    }

    @Override
    public String getMonthPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'M', bl2, pluralCategory);
    }

    @Override
    public String getWeekPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'W', bl2, pluralCategory);
    }

    @Override
    public String getDayPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'D', bl2, pluralCategory);
    }

    @Override
    public String getHourPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'H', bl2, pluralCategory);
    }

    @Override
    public String getMinutePattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'N', bl2, pluralCategory);
    }

    @Override
    public String getSecondPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'S', bl2, pluralCategory);
    }

    @Override
    public String getNowWord(Locale locale) {
        return this.getPattern(locale, "reltime/relpattern", "now", null, PluralCategory.OTHER);
    }

    @Override
    public String getShortYearPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'y', bl2, pluralCategory);
    }

    @Override
    public String getShortMonthPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'm', bl2, pluralCategory);
    }

    @Override
    public String getShortWeekPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'w', bl2, pluralCategory);
    }

    @Override
    public String getShortDayPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'd', bl2, pluralCategory);
    }

    @Override
    public String getShortHourPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'h', bl2, pluralCategory);
    }

    @Override
    public String getShortMinutePattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'n', bl2, pluralCategory);
    }

    @Override
    public String getShortSecondPattern(Locale locale, boolean bl2, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 's', bl2, pluralCategory);
    }

    @Override
    public String getYesterdayWord(Locale locale) {
        return this.getPattern(locale, "reltime/relpattern", "yesterday", null, PluralCategory.OTHER);
    }

    @Override
    public String getTodayWord(Locale locale) {
        return this.getPattern(locale, "reltime/relpattern", "today", null, PluralCategory.OTHER);
    }

    @Override
    public String getTomorrowWord(Locale locale) {
        return this.getPattern(locale, "reltime/relpattern", "tomorrow", null, PluralCategory.OTHER);
    }

    @Override
    public String labelForLast(Weekday weekday, Locale locale) {
        return this.getLabel(locale, weekday.name().substring(0, 3).toLowerCase() + "-");
    }

    @Override
    public String labelForNext(Weekday weekday, Locale locale) {
        return this.getLabel(locale, weekday.name().substring(0, 3).toLowerCase() + "+");
    }

    @Override
    public String getListPattern(Locale locale, TextWidth textWidth, int n2) {
        String string;
        String string2;
        if (n2 < 2) {
            throw new IllegalArgumentException("Size must be greater than 1.");
        }
        PropertyBundle propertyBundle = PropertyBundle.load("units/upattern", locale);
        if (propertyBundle.containsKey(string2 = DefaultUnitPatternProviderSPI.buildListKey(textWidth, String.valueOf(n2)))) {
            return propertyBundle.getString(string2);
        }
        String string3 = propertyBundle.getString(DefaultUnitPatternProviderSPI.buildListKey(textWidth, "end"));
        if (n2 == 2) {
            return string3;
        }
        String string4 = propertyBundle.getString(DefaultUnitPatternProviderSPI.buildListKey(textWidth, "start"));
        String string5 = propertyBundle.getString(DefaultUnitPatternProviderSPI.buildListKey(textWidth, "middle"));
        string3 = DefaultUnitPatternProviderSPI.replace(string3, '1', n2 - 1);
        String string6 = string = (string3 = DefaultUnitPatternProviderSPI.replace(string3, '0', n2 - 2));
        for (int i2 = n2 - 3; i2 >= 0; --i2) {
            String string7 = i2 == 0 ? string4 : string5;
            int n3 = -1;
            int n4 = string7.length();
            for (int i3 = n4 - 1; i3 >= 0; --i3) {
                if (i3 < 2 || string7.charAt(i3) != '}' || string7.charAt(i3 - 1) != '1' || string7.charAt(i3 - 2) != '{') continue;
                n3 = i3 - 2;
                break;
            }
            if (n3 > -1) {
                string6 = string7.substring(0, n3) + string;
                if (n3 < n4 - 3) {
                    string6 = string6 + string7.substring(n3 + 3);
                }
            }
            if (i2 <= 0) continue;
            string = DefaultUnitPatternProviderSPI.replace(string6, '0', i2);
        }
        return string6;
    }

    private String getUnitPattern(Locale locale, char c2, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getPattern(locale, "units/upattern", DefaultUnitPatternProviderSPI.buildKey(c2, textWidth, pluralCategory), DefaultUnitPatternProviderSPI.buildKey(c2, textWidth, PluralCategory.OTHER), pluralCategory);
    }

    private String getRelativePattern(Locale locale, char c2, boolean bl2, PluralCategory pluralCategory) {
        return this.getPattern(locale, "reltime/relpattern", DefaultUnitPatternProviderSPI.buildKey(c2, bl2, pluralCategory), DefaultUnitPatternProviderSPI.buildKey(c2, bl2, PluralCategory.OTHER), pluralCategory);
    }

    private String getPattern(Locale locale, String string, String string2, String string3, PluralCategory pluralCategory) {
        boolean bl2 = true;
        PropertyBundle propertyBundle = null;
        for (Locale locale2 : PropertyBundle.getCandidateLocales(locale)) {
            PropertyBundle propertyBundle2;
            PropertyBundle propertyBundle3 = propertyBundle2 = bl2 && propertyBundle != null ? propertyBundle : PropertyBundle.load(string, locale2);
            if (bl2) {
                if (locale2.equals(propertyBundle2.getLocale())) {
                    bl2 = false;
                } else {
                    propertyBundle = propertyBundle2;
                    continue;
                }
            }
            if (propertyBundle2.getInternalKeys().contains(string2)) {
                return propertyBundle2.getString(string2);
            }
            if (pluralCategory == PluralCategory.OTHER || !propertyBundle2.getInternalKeys().contains(string3)) continue;
            return propertyBundle2.getString(string3);
        }
        throw new MissingResourceException("Can't find resource for bundle " + string + ".properties, key " + string2, string + ".properties", string2);
    }

    private String getLabel(Locale locale, String string) {
        boolean bl2 = true;
        PropertyBundle propertyBundle = null;
        for (Locale locale2 : PropertyBundle.getCandidateLocales(locale)) {
            PropertyBundle propertyBundle2;
            PropertyBundle propertyBundle3 = propertyBundle2 = bl2 && propertyBundle != null ? propertyBundle : PropertyBundle.load("reltime/relpattern", locale2);
            if (bl2) {
                if (locale2.equals(propertyBundle2.getLocale())) {
                    bl2 = false;
                } else {
                    propertyBundle = propertyBundle2;
                    continue;
                }
            }
            if (!propertyBundle2.getInternalKeys().contains(string)) continue;
            return propertyBundle2.getString(string);
        }
        return "";
    }

    private static String buildKey(char c2, TextWidth textWidth, PluralCategory pluralCategory) {
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(c2);
        switch (textWidth) {
            case WIDE: {
                stringBuilder.append('w');
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                stringBuilder.append('s');
                break;
            }
            case NARROW: {
                stringBuilder.append('n');
                break;
            }
            default: {
                throw new UnsupportedOperationException(textWidth.name());
            }
        }
        return stringBuilder.append(pluralCategory.ordinal()).toString();
    }

    private static String buildKey(char c2, boolean bl2, PluralCategory pluralCategory) {
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(c2);
        stringBuilder.append(bl2 ? (char)'+' : '-');
        return stringBuilder.append(pluralCategory.ordinal()).toString();
    }

    private static String buildListKey(TextWidth textWidth, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('L');
        switch (textWidth) {
            case WIDE: {
                stringBuilder.append('w');
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                stringBuilder.append('s');
                break;
            }
            case NARROW: {
                stringBuilder.append('n');
                break;
            }
            default: {
                throw new UnsupportedOperationException(textWidth.name());
            }
        }
        return stringBuilder.append('-').append(string).toString();
    }

    private static String replace(String string, char c2, int n2) {
        int n3 = string.length() - 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.charAt(i2) != '{' || string.charAt(i2 + 1) != c2 || string.charAt(i2 + 2) != '}') continue;
            StringBuilder stringBuilder = new StringBuilder(n3 + 10);
            stringBuilder.append(string);
            stringBuilder.replace(i2 + 1, i2 + 2, String.valueOf(n2));
            return stringBuilder.toString();
        }
        return string;
    }
}

