/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ElementOperator;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.Quarter;
import net.time4j.base.GregorianMath;
import net.time4j.engine.ChronoOperator;

final class CalendarOperator
extends ElementOperator<PlainDate> {
    static final CalendarOperator FIRST_DAY_OF_NEXT_MONTH = new CalendarOperator(17);
    static final CalendarOperator FIRST_DAY_OF_NEXT_QUARTER = new CalendarOperator(18);
    static final CalendarOperator FIRST_DAY_OF_NEXT_YEAR = new CalendarOperator(19);
    static final CalendarOperator LAST_DAY_OF_PREVIOUS_MONTH = new CalendarOperator(20);
    static final CalendarOperator LAST_DAY_OF_PREVIOUS_QUARTER = new CalendarOperator(21);
    static final CalendarOperator LAST_DAY_OF_PREVIOUS_YEAR = new CalendarOperator(22);
    private final ChronoOperator<PlainTimestamp> tsop = plainTimestamp -> {
        PlainDate plainDate = this.doApply(plainTimestamp.getCalendarDate());
        return plainTimestamp.with(plainDate);
    };

    private CalendarOperator(int n2) {
        super(PlainDate.COMPONENT, n2);
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        return this.doApply(plainDate);
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return this.tsop;
    }

    private PlainDate doApply(PlainDate plainDate) {
        int n2 = plainDate.getYear();
        int n3 = plainDate.getMonth();
        switch (this.getType()) {
            case 17: {
                if (++n3 >= 13) {
                    ++n2;
                    n3 = 1;
                }
                return PlainDate.of(n2, n3, 1);
            }
            case 18: {
                Quarter quarter = Month.valueOf(n3).getQuarterOfYear();
                Quarter quarter2 = quarter.next();
                n3 = Month.atStartOfQuarterYear(quarter2).getValue();
                if (quarter == Quarter.Q4) {
                    ++n2;
                }
                return PlainDate.of(n2, n3, 1);
            }
            case 19: {
                return PlainDate.of(++n2, 1, 1);
            }
            case 20: {
                if (--n3 <= 0) {
                    --n2;
                    n3 = 12;
                }
                return PlainDate.of(n2, n3, GregorianMath.getLengthOfMonth(n2, n3));
            }
            case 21: {
                Quarter quarter = Month.valueOf(n3).getQuarterOfYear();
                Quarter quarter3 = quarter.previous();
                n3 = Month.atEndOfQuarterYear(quarter3).getValue();
                if (quarter3 == Quarter.Q4) {
                    return PlainDate.of(--n2, n3, 31);
                }
                if (quarter3 == Quarter.Q1) {
                    return PlainDate.of(n2, n3, 31);
                }
                return PlainDate.of(n2, n3, 30);
            }
            case 22: {
                return PlainDate.of(--n2, 12, 31);
            }
        }
        throw new AssertionError((Object)("Unknown: " + this.getType()));
    }
}

