/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.geometry;

import java.sql.SQLException;
import java.util.List;
import net.postgis.jdbc.geometry.Geometry;
import net.postgis.jdbc.geometry.GeometryTokenizer;

public class Point
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final boolean CUTINTS = true;
    public double x;
    public double y;
    public double z;
    public double m = 0.0;

    @Override
    public int hashCode() {
        return super.hashCode() ^ Point.hashCode(this.x) ^ Point.hashCode(this.y) ^ Point.hashCode(this.z) ^ Point.hashCode(this.m);
    }

    public static int hashCode(double value) {
        long v2 = Double.doubleToLongBits(value);
        return (int)(v2 ^ v2 >>> 32);
    }

    @Override
    protected boolean equalsintern(Geometry otherg) {
        Point other = (Point)otherg;
        return this.equals(other);
    }

    public static boolean double_equals(double a2, double b2) {
        if (Double.isNaN(a2) && Double.isNaN(b2)) {
            return true;
        }
        return a2 == b2;
    }

    public final boolean equals(Point other) {
        boolean xequals = Point.double_equals(this.x, other.x);
        boolean yequals = Point.double_equals(this.y, other.y);
        boolean zequals = this.dimension == 2 || Point.double_equals(this.z, other.z);
        boolean mequals = !this.haveMeasure || Point.double_equals(this.m, other.m);
        boolean result = xequals && yequals && zequals && mequals;
        return result;
    }

    @Override
    public Point getPoint(int index) {
        if (index == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("Point only has a single Point! " + index);
    }

    @Override
    public Point getFirstPoint() {
        return this;
    }

    @Override
    public Point getLastPoint() {
        return this;
    }

    @Override
    public int numPoints() {
        return 1;
    }

    public Point() {
        super(1);
    }

    public Point(double x2, double y2, double z2) {
        this();
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.dimension = 3;
    }

    public Point(double x2, double y2) {
        this();
        this.x = x2;
        this.y = y2;
        this.z = 0.0;
        this.dimension = 2;
    }

    public Point(String value) throws SQLException {
        this(value, false);
    }

    protected Point(String value, boolean haveM) throws SQLException {
        this();
        value = this.initSRID(value);
        if (value.indexOf("POINTM") == 0) {
            haveM = true;
            value = value.substring(6).trim();
        } else if (value.indexOf("POINT") == 0) {
            value = value.substring(5).trim();
        }
        String valueNoParans = GeometryTokenizer.removeLeadingAndTrailingStrings(value, "(", ")");
        List<String> tokens = GeometryTokenizer.tokenize(valueNoParans, ' ');
        try {
            this.x = Double.valueOf(tokens.get(0));
            this.y = Double.valueOf(tokens.get(1));
            if (tokens.size() == 3 && !(haveM |= tokens.size() == 4) || tokens.size() == 4) {
                this.z = Double.valueOf(tokens.get(2));
                this.dimension = 3;
            } else {
                this.dimension = 2;
            }
            if (haveM) {
                this.m = Double.valueOf(tokens.get(this.dimension));
            }
        }
        catch (NumberFormatException e2) {
            throw new SQLException("Error parsing Point: " + e2.toString());
        }
        this.haveMeasure = haveM;
    }

    @Override
    public void innerWKT(StringBuffer sb) {
        sb.append(this.x);
        Point.cutint(sb);
        sb.append(' ');
        sb.append(this.y);
        Point.cutint(sb);
        if (this.dimension == 3) {
            sb.append(' ');
            sb.append(this.z);
            Point.cutint(sb);
        }
        if (this.haveMeasure) {
            sb.append(' ');
            sb.append(this.m);
            Point.cutint(sb);
        }
    }

    private static void cutint(StringBuffer sb) {
        int l2 = sb.length() - 2;
        if (sb.charAt(l2 + 1) == '0' && sb.charAt(l2) == '.') {
            sb.setLength(l2);
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getM() {
        return this.m;
    }

    public void setX(double x2) {
        this.x = x2;
    }

    public void setY(double y2) {
        this.y = y2;
    }

    public void setZ(double z2) {
        this.z = z2;
    }

    public void setM(double m4) {
        this.haveMeasure = true;
        this.m = m4;
    }

    public void setX(int x2) {
        this.x = x2;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public void setZ(int z2) {
        this.z = z2;
    }

    public double distance(Point other) {
        if (this.dimension != other.dimension) {
            throw new IllegalArgumentException("Points have different dimensions!");
        }
        double tx = this.x - other.x;
        switch (this.dimension) {
            case 1: {
                return Math.sqrt(tx * tx);
            }
            case 2: {
                double ty = this.y - other.y;
                return Math.sqrt(tx * tx + ty * ty);
            }
            case 3: {
                double ty = this.y - other.y;
                double tz = this.z - other.z;
                return Math.sqrt(tx * tx + ty * ty + tz * tz);
            }
        }
        throw new IllegalArgumentException("Illegal dimension of Point" + this.dimension);
    }

    @Override
    public boolean checkConsistency() {
        return !(!super.checkConsistency() || this.dimension != 3 && this.z != 0.0 || !this.haveMeasure && this.m != 0.0);
    }
}

