/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.geometry;

import java.sql.SQLException;
import net.postgis.jdbc.geometry.Point;
import net.postgis.jdbc.geometry.PointComposedGeom;

public class LineString
extends PointComposedGeom {
    private static final long serialVersionUID = 256L;
    double len = -1.0;

    public LineString() {
        super(2);
    }

    public LineString(Point[] points) {
        super(2, points);
    }

    public LineString(String value) throws SQLException {
        super(2, value);
    }

    public LineString(String value, boolean haveM) throws SQLException {
        super(2, value, haveM);
    }

    public LineString reverse() {
        Point[] points = this.getPoints();
        int l2 = points.length;
        Point[] p2 = new Point[l2];
        int i2 = 0;
        int j2 = l2 - 1;
        while (i2 < l2) {
            p2[i2] = points[j2];
            ++i2;
            --j2;
        }
        return new LineString(p2);
    }

    public LineString concat(LineString other) {
        int i2;
        Point[] points = this.getPoints();
        Point[] opoints = other.getPoints();
        boolean cutPoint = this.getLastPoint() == null || this.getLastPoint().equals(other.getFirstPoint());
        int count = points.length + opoints.length - (cutPoint ? 1 : 0);
        Point[] p2 = new Point[count];
        for (i2 = 0; i2 < points.length; ++i2) {
            p2[i2] = points[i2];
        }
        if (!cutPoint) {
            p2[i2++] = other.getFirstPoint();
        }
        int j2 = 1;
        while (j2 < opoints.length) {
            p2[i2] = opoints[j2];
            ++j2;
            ++i2;
        }
        return new LineString(p2);
    }

    public double length() {
        if (this.len < 0.0) {
            Point[] points = this.getPoints();
            if (points == null || points.length < 2) {
                this.len = 0.0;
            } else {
                double sum = 0.0;
                for (int i2 = 1; i2 < points.length; ++i2) {
                    sum += points[i2 - 1].distance(points[i2]);
                }
                this.len = sum;
            }
        }
        return this.len;
    }
}

