/*
 * Decompiled with CFR 0.152.
 */
package net.postgis.jdbc.geometry;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.postgis.jdbc.geometry.Geometry;
import net.postgis.jdbc.geometry.GeometryTokenizer;
import net.postgis.jdbc.geometry.Point;

public abstract class ComposedGeom
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final Geometry[] EMPTY = new Geometry[0];
    protected Geometry[] subgeoms = EMPTY;
    boolean nohash = true;
    int hashcode = 0;

    public ComposedGeom(int type) {
        super(type);
    }

    public Geometry getSubGeometry(int index) {
        return this.subgeoms[index];
    }

    public int numGeoms() {
        return this.subgeoms.length;
    }

    protected ComposedGeom(int type, Geometry[] geoms) {
        this(type);
        this.subgeoms = geoms;
        if (geoms.length > 0) {
            this.dimension = geoms[0].dimension;
            this.haveMeasure = geoms[0].haveMeasure;
        } else {
            this.dimension = 0;
        }
    }

    protected ComposedGeom(int type, String value, boolean haveM) throws SQLException {
        super(type);
        value = this.initSRID(value);
        String typestring = this.getTypeString();
        if (value.indexOf(typestring) == 0) {
            int pfxlen = typestring.length();
            if (value.charAt(pfxlen) == 'M') {
                ++pfxlen;
                haveM = true;
            }
            value = value.substring(pfxlen).trim();
        } else if (value.charAt(0) != '(') {
            throw new SQLException("Error parsing a " + typestring + " out of " + value);
        }
        if (value.equals("(EMPTY)")) {
            return;
        }
        String valueNoParans = GeometryTokenizer.removeLeadingAndTrailingStrings(value, "(", ")");
        List<String> tokens = GeometryTokenizer.tokenize(valueNoParans, ',');
        int subgeomcount = tokens.size();
        this.subgeoms = this.createSubGeomArray(subgeomcount);
        for (int p2 = 0; p2 < subgeomcount; ++p2) {
            this.subgeoms[p2] = this.createSubGeomInstance(tokens.get(p2), haveM);
        }
        this.dimension = this.subgeoms[0].dimension;
        this.haveMeasure = this.subgeoms[0].haveMeasure;
    }

    protected abstract Geometry createSubGeomInstance(String var1, boolean var2) throws SQLException;

    protected abstract Geometry[] createSubGeomArray(int var1);

    @Override
    protected boolean equalsintern(Geometry other) {
        ComposedGeom cother = (ComposedGeom)other;
        if (cother.subgeoms == null && this.subgeoms == null) {
            return true;
        }
        if (cother.subgeoms == null || this.subgeoms == null) {
            return false;
        }
        if (cother.subgeoms.length != this.subgeoms.length) {
            return false;
        }
        if (this.subgeoms.length == 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            if (cother.subgeoms[i2].equalsintern(this.subgeoms[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int numPoints() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            return 0;
        }
        int result = 0;
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            result += this.subgeoms[i2].numPoints();
        }
        return result;
    }

    @Override
    public Point getPoint(int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index not allowed");
        }
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            Geometry current = this.subgeoms[i2];
            int np2 = current.numPoints();
            if (n2 < np2) {
                return current.getPoint(n2);
            }
            n2 -= np2;
        }
        throw new ArrayIndexOutOfBoundsException("Index too large!");
    }

    @Override
    public Point getLastPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[this.subgeoms.length - 1].getLastPoint();
    }

    @Override
    public Point getFirstPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[0].getFirstPoint();
    }

    public Iterator iterator() {
        return Arrays.asList(this.subgeoms).iterator();
    }

    public boolean isEmpty() {
        return this.subgeoms == null || this.subgeoms.length == 0;
    }

    @Override
    protected void mediumWKT(StringBuffer sb) {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            sb.append(" EMPTY");
        } else {
            sb.append('(');
            this.innerWKT(sb);
            sb.append(')');
        }
    }

    @Override
    protected void innerWKT(StringBuffer sb) {
        this.subgeoms[0].mediumWKT(sb);
        for (int i2 = 1; i2 < this.subgeoms.length; ++i2) {
            sb.append(',');
            this.subgeoms[i2].mediumWKT(sb);
        }
    }

    @Override
    public int hashCode() {
        if (this.nohash) {
            this.hashcode = super.hashCode() ^ this.subgeoms.hashCode();
            this.nohash = false;
        }
        return this.hashcode;
    }

    @Override
    public boolean checkConsistency() {
        if (super.checkConsistency()) {
            if (this.isEmpty()) {
                return true;
            }
            int _dimension = this.dimension;
            boolean _haveMeasure = this.haveMeasure;
            int _srid = this.srid;
            for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
                Geometry sub = this.subgeoms[i2];
                if (sub.checkConsistency() && sub.dimension == _dimension && sub.haveMeasure == _haveMeasure && sub.srid == _srid) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setSrid(int srid) {
        super.setSrid(srid);
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            this.subgeoms[i2].setSrid(srid);
        }
    }
}

