/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.VirtualScrollBar;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;

public class VirtualFlow<T extends IndexedCell>
extends Region {
    private static final int MIN_SCROLLING_LINES_PER_PAGE = 8;
    private static final String NEW_CELL = "newcell";
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;
    private static final int DEFAULT_IMPROVEMENT = 2;
    private boolean touchDetected = false;
    private boolean mouseDown = false;
    double lastWidth = -1.0;
    double lastHeight = -1.0;
    int lastCellCount = 0;
    boolean lastVertical;
    double lastPosition;
    double lastCellBreadth = -1.0;
    double lastCellLength = -1.0;
    final ArrayLinkedList<T> cells = new ArrayLinkedList();
    final ArrayLinkedList<T> pile = new ArrayLinkedList();
    T accumCell;
    Group accumCellParent;
    final Group sheet;
    final ObservableList<Node> sheetChildren;
    private VirtualScrollBar hbar = new VirtualScrollBar(this);
    private VirtualScrollBar vbar = new VirtualScrollBar(this);
    ClippedContainer clipView;
    StackPane corner;
    double absoluteOffset = 0.0;
    double estimatedSize = -1.0;
    private ArrayList<Double> itemSizeCache = new ArrayList();
    private double lastX;
    private double lastY;
    private boolean isPanning = false;
    private boolean fixedCellSizeEnabled = false;
    private boolean needsReconfigureCells = false;
    private boolean needsRecreateCells = false;
    private boolean needsRebuildCells = false;
    private boolean needsCellsLayout = false;
    private boolean sizeChanged = false;
    private final BitSet dirtyCells = new BitSet();
    Timeline sbTouchTimeline;
    KeyFrame sbTouchKF1;
    KeyFrame sbTouchKF2;
    private boolean needBreadthBar;
    private boolean needLengthBar;
    private boolean tempVisibility = false;
    private BooleanProperty vertical;
    private BooleanProperty pannable = new SimpleBooleanProperty(this, "pannable", true);
    private IntegerProperty cellCount = new SimpleIntegerProperty(this, "cellCount", 0){
        private int oldCount;
        {
            this.oldCount = 0;
        }

        @Override
        protected void invalidated() {
            Parent parent;
            int n2 = this.get();
            VirtualFlow.this.resetSizeEstimates();
            VirtualFlow.this.recalculateEstimatedSize();
            boolean bl2 = this.oldCount != n2;
            this.oldCount = n2;
            if (bl2) {
                parent = VirtualFlow.this.isVertical() ? VirtualFlow.this.vbar : VirtualFlow.this.hbar;
                ((ScrollBar)parent).setMax(n2);
            }
            if (bl2) {
                VirtualFlow.this.layoutChildren();
                parent = VirtualFlow.this.getParent();
                if (parent != null) {
                    parent.requestLayout();
                }
                VirtualFlow.this.adjustAbsoluteOffset();
            }
        }
    };
    private DoubleProperty position = new SimpleDoubleProperty(this, "position"){

        @Override
        public void setValue(Number number) {
            super.setValue(com.sun.javafx.util.Utils.clamp(0.0, this.get(), 1.0));
        }

        @Override
        protected void invalidated() {
            super.invalidated();
            VirtualFlow.this.adjustAbsoluteOffset();
            VirtualFlow.this.requestLayout();
        }
    };
    private DoubleProperty fixedCellSize = new SimpleDoubleProperty(this, "fixedCellSize"){

        @Override
        protected void invalidated() {
            VirtualFlow.this.fixedCellSizeEnabled = this.get() > 0.0;
            VirtualFlow.this.needsCellsLayout = true;
            VirtualFlow.this.layoutChildren();
        }
    };
    private ObjectProperty<Callback<VirtualFlow<T>, T>> cellFactory;
    private double maxPrefBreadth;
    private double viewportBreadth;
    private double viewportLength;
    private final List<T> privateCells = new ArrayList<T>();
    private boolean recalculating = false;

    public VirtualFlow() {
        this.getStyleClass().add("virtual-flow");
        this.setId("virtual-flow");
        this.sheet = new Group();
        this.sheet.getStyleClass().add("sheet");
        this.sheet.setAutoSizeChildren(false);
        this.sheetChildren = this.sheet.getChildren();
        this.clipView = new ClippedContainer(this);
        this.clipView.setNode(this.sheet);
        this.getChildren().add(this.clipView);
        this.accumCellParent = new Group();
        this.accumCellParent.setVisible(false);
        this.getChildren().add(this.accumCellParent);
        EventDispatcher eventDispatcher = (event, eventDispatchChain) -> event;
        EventDispatcher eventDispatcher2 = this.hbar.getEventDispatcher();
        this.hbar.setEventDispatcher((event, eventDispatchChain) -> {
            if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
                eventDispatchChain = eventDispatchChain.prepend(eventDispatcher2);
                return eventDispatchChain.dispatchEvent(event);
            }
            return eventDispatcher2.dispatchEvent(event, eventDispatchChain);
        });
        EventDispatcher eventDispatcher3 = this.vbar.getEventDispatcher();
        this.vbar.setEventDispatcher((event, eventDispatchChain) -> {
            if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
                eventDispatchChain = eventDispatchChain.prepend(eventDispatcher3);
                return eventDispatchChain.dispatchEvent(event);
            }
            return eventDispatcher3.dispatchEvent(event, eventDispatchChain);
        });
        this.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                VirtualScrollBar virtualScrollBar;
                double d2;
                if (Properties.IS_TOUCH_SUPPORTED && !VirtualFlow.this.touchDetected && !VirtualFlow.this.mouseDown) {
                    VirtualFlow.this.startSBReleasedAnimation();
                }
                double d3 = 0.0;
                if (VirtualFlow.this.isVertical()) {
                    switch (scrollEvent.getTextDeltaYUnits()) {
                        case PAGES: {
                            d3 = scrollEvent.getTextDeltaY() * VirtualFlow.this.lastHeight;
                            break;
                        }
                        case LINES: {
                            if (VirtualFlow.this.fixedCellSizeEnabled) {
                                d2 = VirtualFlow.this.getFixedCellSize();
                            } else {
                                IndexedCell indexedCell = (IndexedCell)VirtualFlow.this.cells.getLast();
                                d2 = (VirtualFlow.this.getCellPosition(indexedCell) + VirtualFlow.this.getCellLength(indexedCell) - VirtualFlow.this.getCellPosition((IndexedCell)VirtualFlow.this.cells.getFirst())) / (double)VirtualFlow.this.cells.size();
                            }
                            if (VirtualFlow.this.lastHeight / d2 < 8.0) {
                                d2 = VirtualFlow.this.lastHeight / 8.0;
                            }
                            d3 = scrollEvent.getTextDeltaY() * d2;
                            break;
                        }
                        case NONE: {
                            d3 = scrollEvent.getDeltaY();
                        }
                    }
                } else {
                    switch (scrollEvent.getTextDeltaXUnits()) {
                        case CHARACTERS: 
                        case NONE: {
                            d2 = scrollEvent.getDeltaX();
                            double d4 = scrollEvent.getDeltaY();
                            double d5 = d3 = Math.abs(d2) > Math.abs(d4) ? d2 : d4;
                        }
                    }
                }
                if (d3 != 0.0 && (d2 = VirtualFlow.this.scrollPixels(-d3)) != 0.0) {
                    scrollEvent.consume();
                }
                VirtualScrollBar virtualScrollBar2 = virtualScrollBar = VirtualFlow.this.isVertical() ? VirtualFlow.this.hbar : VirtualFlow.this.vbar;
                if (VirtualFlow.this.needBreadthBar) {
                    double d6;
                    double d7 = d6 = VirtualFlow.this.isVertical() ? scrollEvent.getDeltaX() : scrollEvent.getDeltaY();
                    if (d6 != 0.0) {
                        double d8 = virtualScrollBar.getValue() - d6;
                        if (d8 < virtualScrollBar.getMin()) {
                            virtualScrollBar.setValue(virtualScrollBar.getMin());
                        } else if (d8 > virtualScrollBar.getMax()) {
                            virtualScrollBar.setValue(virtualScrollBar.getMax());
                        } else {
                            virtualScrollBar.setValue(d8);
                        }
                        scrollEvent.consume();
                    }
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                VirtualFlow.this.mouseDown = true;
                if (Properties.IS_TOUCH_SUPPORTED) {
                    VirtualFlow.this.scrollBarOn();
                }
                if (VirtualFlow.this.isFocusTraversable()) {
                    boolean bl2 = true;
                    Node node = VirtualFlow.this.getScene().getFocusOwner();
                    if (node != null) {
                        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                            if (!parent.equals(VirtualFlow.this)) continue;
                            bl2 = false;
                            break;
                        }
                    }
                    if (bl2) {
                        VirtualFlow.this.requestFocus();
                    }
                }
                VirtualFlow.this.lastX = mouseEvent.getX();
                VirtualFlow.this.lastY = mouseEvent.getY();
                VirtualFlow.this.isPanning = !VirtualFlow.this.vbar.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) && !VirtualFlow.this.hbar.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.mouseDown = false;
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.startSBReleasedAnimation();
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            VirtualScrollBar virtualScrollBar;
            if (Properties.IS_TOUCH_SUPPORTED) {
                this.scrollBarOn();
            }
            if (!this.isPanning || !this.isPannable()) {
                return;
            }
            double d2 = this.lastX - mouseEvent.getX();
            double d3 = this.lastY - mouseEvent.getY();
            double d4 = this.isVertical() ? d3 : d2;
            double d5 = this.scrollPixels(d4);
            if (d5 != 0.0) {
                if (this.isVertical()) {
                    this.lastY = mouseEvent.getY();
                } else {
                    this.lastX = mouseEvent.getX();
                }
            }
            double d6 = this.isVertical() ? d2 : d3;
            VirtualScrollBar virtualScrollBar2 = virtualScrollBar = this.isVertical() ? this.hbar : this.vbar;
            if (virtualScrollBar.isVisible()) {
                double d7 = virtualScrollBar.getValue() + d6;
                if (d7 < virtualScrollBar.getMin()) {
                    virtualScrollBar.setValue(virtualScrollBar.getMin());
                } else if (d7 > virtualScrollBar.getMax()) {
                    virtualScrollBar.setValue(virtualScrollBar.getMax());
                } else {
                    virtualScrollBar.setValue(d7);
                    if (this.isVertical()) {
                        this.lastX = mouseEvent.getX();
                    } else {
                        this.lastY = mouseEvent.getY();
                    }
                }
            }
        });
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.vbar.addEventHandler(MouseEvent.ANY, mouseEvent -> mouseEvent.consume());
        this.getChildren().add(this.vbar);
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.hbar.addEventHandler(MouseEvent.ANY, mouseEvent -> mouseEvent.consume());
        this.getChildren().add(this.hbar);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.getChildren().add(this.corner);
        InvalidationListener invalidationListener = observable -> this.updateHbar();
        this.verticalProperty().addListener(invalidationListener);
        this.hbar.valueProperty().addListener(invalidationListener);
        this.hbar.visibleProperty().addListener(invalidationListener);
        this.visibleProperty().addListener(invalidationListener);
        this.sceneProperty().addListener(invalidationListener);
        ChangeListener<Number> changeListener = (observableValue, number, number2) -> this.clipView.setClipY(this.isVertical() ? 0.0 : this.vbar.getValue());
        this.vbar.valueProperty().addListener(changeListener);
        super.heightProperty().addListener((observableValue, number, number2) -> {
            if (number.doubleValue() == 0.0 && number2.doubleValue() > 0.0) {
                this.recreateCells();
            }
        });
        this.setOnTouchPressed(touchEvent -> {
            this.touchDetected = true;
            this.scrollBarOn();
        });
        this.setOnTouchReleased(touchEvent -> {
            this.touchDetected = false;
            this.startSBReleasedAnimation();
        });
        ParentHelper.setTraversalEngine(this, new ParentTraversalEngine(this, new Algorithm(){

            Node selectNextAfterIndex(int n2, TraversalContext traversalContext) {
                Object t2;
                while ((t2 = VirtualFlow.this.getVisibleCell(++n2)) != null) {
                    if (((Node)t2).isFocusTraversable()) {
                        return t2;
                    }
                    Node node = traversalContext.selectFirstInParent((Parent)t2);
                    if (node == null) continue;
                    return node;
                }
                return null;
            }

            Node selectPreviousBeforeIndex(int n2, TraversalContext traversalContext) {
                Object t2;
                while ((t2 = VirtualFlow.this.getVisibleCell(--n2)) != null) {
                    Node node = traversalContext.selectLastInParent((Parent)t2);
                    if (node != null) {
                        return node;
                    }
                    if (!((Node)t2).isFocusTraversable()) continue;
                    return t2;
                }
                return null;
            }

            @Override
            public Node select(Node node, Direction direction, TraversalContext traversalContext) {
                IndexedCell indexedCell;
                if (VirtualFlow.this.cells.isEmpty()) {
                    return null;
                }
                if (VirtualFlow.this.cells.contains(node)) {
                    indexedCell = (IndexedCell)node;
                } else {
                    indexedCell = this.findOwnerCell(node);
                    Node node2 = traversalContext.selectInSubtree(indexedCell, node, direction);
                    if (node2 != null) {
                        return node2;
                    }
                    if (direction == Direction.NEXT) {
                        direction = Direction.NEXT_IN_LINE;
                    }
                }
                int n2 = indexedCell.getIndex();
                switch (direction) {
                    case PREVIOUS: {
                        return this.selectPreviousBeforeIndex(n2, traversalContext);
                    }
                    case NEXT: {
                        Node node3 = traversalContext.selectFirstInParent(indexedCell);
                        if (node3 != null) {
                            return node3;
                        }
                    }
                    case NEXT_IN_LINE: {
                        return this.selectNextAfterIndex(n2, traversalContext);
                    }
                }
                return null;
            }

            private T findOwnerCell(Node node) {
                Parent parent = node.getParent();
                while (!VirtualFlow.this.cells.contains(parent)) {
                    parent = parent.getParent();
                }
                return (IndexedCell)parent;
            }

            @Override
            public Node selectFirst(TraversalContext traversalContext) {
                IndexedCell indexedCell = (IndexedCell)VirtualFlow.this.cells.getFirst();
                if (indexedCell == null) {
                    return null;
                }
                if (indexedCell.isFocusTraversable()) {
                    return indexedCell;
                }
                Node node = traversalContext.selectFirstInParent(indexedCell);
                if (node != null) {
                    return node;
                }
                return this.selectNextAfterIndex(indexedCell.getIndex(), traversalContext);
            }

            @Override
            public Node selectLast(TraversalContext traversalContext) {
                IndexedCell indexedCell = (IndexedCell)VirtualFlow.this.cells.getLast();
                if (indexedCell == null) {
                    return null;
                }
                Node node = traversalContext.selectLastInParent(indexedCell);
                if (node != null) {
                    return node;
                }
                if (indexedCell.isFocusTraversable()) {
                    return indexedCell;
                }
                return this.selectPreviousBeforeIndex(indexedCell.getIndex(), traversalContext);
            }
        }));
    }

    public final void setVertical(boolean bl2) {
        this.verticalProperty().set(bl2);
    }

    public final boolean isVertical() {
        return this.vertical == null ? true : this.vertical.get();
    }

    public final BooleanProperty verticalProperty() {
        if (this.vertical == null) {
            this.vertical = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    VirtualFlow.this.pile.clear();
                    VirtualFlow.this.sheetChildren.clear();
                    VirtualFlow.this.cells.clear();
                    VirtualFlow.this.lastHeight = -1.0;
                    VirtualFlow.this.lastWidth = -1.0;
                    VirtualFlow.this.setMaxPrefBreadth(-1.0);
                    VirtualFlow.this.setViewportBreadth(0.0);
                    VirtualFlow.this.setViewportLength(0.0);
                    VirtualFlow.this.lastPosition = 0.0;
                    VirtualFlow.this.hbar.setValue(0.0);
                    VirtualFlow.this.vbar.setValue(0.0);
                    VirtualFlow.this.setPosition(0.0);
                    VirtualFlow.this.setNeedsLayout(true);
                    VirtualFlow.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return VirtualFlow.this;
                }

                @Override
                public String getName() {
                    return "vertical";
                }
            };
        }
        return this.vertical;
    }

    public final boolean isPannable() {
        return this.pannable.get();
    }

    public final void setPannable(boolean bl2) {
        this.pannable.set(bl2);
    }

    public final BooleanProperty pannableProperty() {
        return this.pannable;
    }

    public final int getCellCount() {
        return this.cellCount.get();
    }

    public final void setCellCount(int n2) {
        this.cellCount.set(n2);
    }

    public final IntegerProperty cellCountProperty() {
        return this.cellCount;
    }

    public final double getPosition() {
        return this.position.get();
    }

    public final void setPosition(double d2) {
        this.position.set(d2);
    }

    public final DoubleProperty positionProperty() {
        return this.position;
    }

    public final void setFixedCellSize(double d2) {
        this.fixedCellSize.set(d2);
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        return this.fixedCellSize;
    }

    public final void setCellFactory(Callback<VirtualFlow<T>, T> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<VirtualFlow<T>, T> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<VirtualFlow<T>, T>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty<Callback<VirtualFlow<T>, T>>(this, "cellFactory"){

                @Override
                protected void invalidated() {
                    if (this.get() != null) {
                        VirtualFlow.this.setNeedsLayout(true);
                        VirtualFlow.this.recreateCells();
                        if (VirtualFlow.this.getParent() != null) {
                            VirtualFlow.this.getParent().requestLayout();
                        }
                    }
                    if (VirtualFlow.this.accumCellParent != null) {
                        VirtualFlow.this.accumCellParent.getChildren().clear();
                    }
                    VirtualFlow.this.accumCell = null;
                }
            };
        }
        return this.cellFactory;
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
    }

    void adjustAbsoluteOffset() {
        this.absoluteOffset = (this.estimatedSize - this.viewportLength) * this.getPosition();
    }

    void adjustPosition() {
        if (this.viewportLength >= this.estimatedSize) {
            this.setPosition(0.0);
        } else {
            this.setPosition(this.absoluteOffset / (this.estimatedSize - this.viewportLength));
        }
    }

    @Override
    protected void layoutChildren() {
        boolean bl2;
        double d2;
        boolean bl3;
        Object object;
        int n2;
        int n3;
        int n4;
        if (this.needsRecreateCells) {
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            this.releaseCell(this.accumCell);
            this.sheet.getChildren().clear();
            n4 = this.cells.size();
            for (n3 = 0; n3 < n4; ++n3) {
                ((IndexedCell)this.cells.get(n3)).updateIndex(-1);
            }
            this.cells.clear();
            this.pile.clear();
            this.releaseAllPrivateCells();
        } else if (this.needsRebuildCells) {
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            this.releaseCell(this.accumCell);
            n4 = this.cells.size();
            for (n3 = 0; n3 < n4; ++n3) {
                ((IndexedCell)this.cells.get(n3)).updateIndex(-1);
            }
            this.addAllToPile();
            this.releaseAllPrivateCells();
        } else if (this.needsReconfigureCells) {
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
        }
        if (!this.dirtyCells.isEmpty()) {
            n4 = this.cells.size();
            while ((n3 = this.dirtyCells.nextSetBit(0)) != -1 && n3 < n4) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(n3);
                if (indexedCell != null) {
                    indexedCell.requestLayout();
                }
                this.dirtyCells.clear(n3);
            }
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
        }
        n3 = this.sizeChanged;
        n4 = this.needsRebuildCells || this.needsRecreateCells || this.sizeChanged ? 1 : 0;
        this.needsRecreateCells = false;
        this.needsReconfigureCells = false;
        this.needsRebuildCells = false;
        this.sizeChanged = false;
        if (this.needsCellsLayout) {
            int n5 = this.cells.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                Cell cell = (Cell)this.cells.get(i2);
                if (cell == null) continue;
                cell.requestLayout();
            }
            this.needsCellsLayout = false;
            return;
        }
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        boolean bl4 = this.isVertical();
        double d5 = this.getPosition();
        if (d3 <= 0.0 || d4 <= 0.0) {
            this.addAllToPile();
            this.lastWidth = d3;
            this.lastHeight = d4;
            this.hbar.setVisible(false);
            this.vbar.setVisible(false);
            this.corner.setVisible(false);
            return;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        if (Properties.IS_TOUCH_SUPPORTED && (this.tempVisibility && (!this.hbar.isVisible() || !this.vbar.isVisible()) || !this.tempVisibility && (this.hbar.isVisible() || this.vbar.isVisible()))) {
            bl6 = true;
        }
        if (!bl5) {
            for (n2 = 0; n2 < this.cells.size() && !(bl5 = ((Parent)(object = (Cell)this.cells.get(n2))).isNeedsLayout()); ++n2) {
            }
        }
        n2 = this.getCellCount();
        object = this.getFirstVisibleCell();
        if (!bl5 && !bl6) {
            bl3 = false;
            if (object != null) {
                double d6 = this.getCellBreadth((Cell)object);
                d2 = this.getCellLength(object);
                bl3 = d6 != this.lastCellBreadth || d2 != this.lastCellLength;
                this.lastCellBreadth = d6;
                this.lastCellLength = d2;
            }
            if (d3 == this.lastWidth && d4 == this.lastHeight && n2 == this.lastCellCount && bl4 == this.lastVertical && d5 == this.lastPosition && !bl3) {
                return;
            }
        }
        bl3 = false;
        boolean bl7 = bl2 = bl5 || bl4 != this.lastVertical || this.cells.isEmpty() || this.getMaxPrefBreadth() == -1.0 || d5 != this.lastPosition || n2 != this.lastCellCount || n3 != 0 || bl4 && d4 < this.lastHeight || !bl4 && d3 < this.lastWidth;
        if (!bl2) {
            double d7 = this.getMaxPrefBreadth();
            boolean bl8 = false;
            for (int i3 = 0; i3 < this.cells.size(); ++i3) {
                double d8 = this.getCellBreadth((Cell)this.cells.get(i3));
                if (d7 == d8) {
                    bl8 = true;
                    continue;
                }
                if (!(d8 > d7)) continue;
                bl2 = true;
                break;
            }
            if (!bl8) {
                bl2 = true;
            }
        }
        if (!bl2 && (bl4 && d4 > this.lastHeight || !bl4 && d3 > this.lastWidth)) {
            bl3 = true;
        }
        this.initViewport();
        int n6 = this.computeCurrentIndex();
        if (this.lastCellCount != n2) {
            if (d5 != 0.0 && d5 != 1.0 && n6 >= n2) {
                this.setPosition(1.0);
            }
            n6 = this.computeCurrentIndex();
        }
        if (bl2) {
            this.setMaxPrefBreadth(-1.0);
            this.addAllToPile();
            d2 = -this.computeViewportOffset(this.getPosition());
            this.addLeadingCells(n6, d2);
            this.addTrailingCells(true);
        } else if (bl3) {
            this.addTrailingCells(true);
        }
        this.computeBarVisiblity();
        this.recalculateAndImproveEstimatedSize(0);
        n4 = n4 != 0 || bl2 ? 1 : 0;
        this.updateScrollBarsAndCells(n4 != 0);
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        this.lastCellCount = this.getCellCount();
        this.lastVertical = this.isVertical();
        this.lastPosition = this.getPosition();
        this.recalculateEstimatedSize();
        this.cleanPile();
    }

    @Override
    protected void setWidth(double d2) {
        if (d2 != this.lastWidth) {
            super.setWidth(d2);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            this.requestLayout();
        }
    }

    @Override
    protected void setHeight(double d2) {
        if (d2 != this.lastHeight) {
            super.setHeight(d2);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            this.requestLayout();
        }
    }

    protected T getAvailableCell(int n2) {
        Node node = null;
        int n3 = this.pile.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i2);
            assert (indexedCell != null);
            if (this.getCellIndex(indexedCell) != n2) continue;
            node = indexedCell;
            this.pile.remove(i2);
            break;
        }
        if (node == null && !this.pile.isEmpty()) {
            node = (IndexedCell)this.pile.removeLast();
        }
        if (node == null) {
            node = (IndexedCell)this.getCellFactory().call(this);
            node.getProperties().put(NEW_CELL, null);
        }
        if (node.getParent() == null) {
            this.sheetChildren.add(node);
        }
        return (T)node;
    }

    protected void addAllToPile() {
        int n2 = this.cells.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addToPile((IndexedCell)this.cells.removeFirst());
        }
    }

    public T getVisibleCell(int n2) {
        IndexedCell indexedCell;
        if (this.cells.isEmpty()) {
            return null;
        }
        IndexedCell indexedCell2 = (IndexedCell)this.cells.getLast();
        int n3 = this.getCellIndex(indexedCell2);
        if (n2 == n3) {
            return (T)indexedCell2;
        }
        IndexedCell indexedCell3 = (IndexedCell)this.cells.getFirst();
        int n4 = this.getCellIndex(indexedCell3);
        if (n2 == n4) {
            return (T)indexedCell3;
        }
        if (n2 > n4 && n2 < n3 && this.getCellIndex(indexedCell = (IndexedCell)this.cells.get(n2 - n4)) == n2) {
            return (T)indexedCell;
        }
        return null;
    }

    public T getLastVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i2 = this.cells.size() - 1; i2 >= 0; --i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            if (indexedCell.isEmpty()) continue;
            return (T)indexedCell;
        }
        return null;
    }

    public T getFirstVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
        return (T)(indexedCell.isEmpty() ? null : indexedCell);
    }

    public void scrollToTop(T t2) {
        if (t2 != null) {
            this.scrollPixels(this.getCellPosition(t2));
        }
    }

    public void scrollToBottom(T t2) {
        if (t2 != null) {
            this.scrollPixels(this.getCellPosition(t2) + this.getCellLength(t2) - this.getViewportLength());
        }
    }

    public void scrollTo(T t2) {
        if (t2 != null) {
            double d2 = this.getCellPosition(t2);
            double d3 = this.getCellLength(t2);
            double d4 = d2 + d3;
            double d5 = this.getViewportLength();
            if (d2 < 0.0) {
                this.scrollPixels(d2);
            } else if (d4 > d5) {
                this.scrollPixels(d4 - d5);
            }
        }
    }

    public void scrollTo(int n2) {
        T t2 = this.getVisibleCell(n2);
        if (t2 != null) {
            this.scrollTo(t2);
        } else {
            if (this.tryScrollOneCell(n2, true)) {
                return;
            }
            if (this.tryScrollOneCell(n2, false)) {
                return;
            }
            this.adjustPositionToIndex(n2);
            this.addAllToPile();
            this.requestLayout();
        }
    }

    private boolean tryScrollOneCell(int n2, boolean bl2) {
        int n3 = bl2 ? -1 : 1;
        T t2 = this.getVisibleCell(n2 + n3);
        if (t2 != null) {
            T t3 = this.getAvailableCell(n2);
            this.setCellIndex(t3, n2);
            this.resizeCell(t3);
            this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)t3)));
            ((Node)t3).setVisible(true);
            if (bl2) {
                this.cells.addLast(t3);
                this.scrollPixels(this.getCellLength(t3));
            } else {
                this.cells.addFirst(t3);
                this.scrollPixels(-this.getCellLength(t3));
            }
            return true;
        }
        return false;
    }

    public void scrollToTop(int n2) {
        this.getCellSizesInExpectedViewport(n2);
        boolean bl2 = false;
        if (n2 > this.getCellCount() - 1) {
            this.setPosition(1.0);
            bl2 = true;
        } else if (n2 < 0) {
            this.setPosition(0.0);
            bl2 = true;
        }
        if (!bl2) {
            this.adjustPositionToIndex(n2);
        }
        this.requestLayout();
    }

    public double scrollPixels(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        boolean bl2 = this.isVertical();
        if (bl2 && (!this.tempVisibility ? !this.vbar.isVisible() : !this.needLengthBar) || !bl2 && (this.tempVisibility ? !this.needLengthBar : !this.hbar.isVisible())) {
            return 0.0;
        }
        double d3 = this.getPosition();
        if (d3 == 0.0 && d2 < 0.0) {
            return 0.0;
        }
        if (d3 == 1.0 && d2 > 0.0) {
            return 0.0;
        }
        this.recalculateEstimatedSize();
        double d4 = this.adjustByPixelAmount(d2);
        if (d3 == this.getPosition()) {
            return 0.0;
        }
        if (this.cells.size() > 0) {
            double d5;
            int n2;
            for (int i2 = 0; i2 < this.cells.size(); ++i2) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
                assert (indexedCell != null);
                this.positionCell(indexedCell, this.getCellPosition(indexedCell) - d2);
            }
            IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
            double d6 = indexedCell == null ? 0.0 : this.getCellPosition(indexedCell);
            for (n2 = 0; n2 < this.cells.size(); ++n2) {
                IndexedCell indexedCell2 = (IndexedCell)this.cells.get(n2);
                assert (indexedCell2 != null);
                double d7 = this.getCellPosition(indexedCell2);
                if (Math.abs(d7 - d6) > 0.001) {
                    this.positionCell(indexedCell2, d6);
                }
                d6 += this.getCellLength(indexedCell2);
            }
            this.cull();
            indexedCell = (IndexedCell)this.cells.getFirst();
            if (indexedCell != null) {
                n2 = this.getCellIndex(indexedCell);
                d5 = this.getCellLength(n2 - 1);
                this.addLeadingCells(n2 - 1, this.getCellPosition(indexedCell) - d5);
            } else {
                n2 = this.computeCurrentIndex();
                d5 = -this.computeViewportOffset(this.getPosition());
                this.addLeadingCells(n2, d5);
            }
            if (!this.addTrailingCells(false)) {
                double d8;
                T t2 = this.getLastVisibleCell();
                d5 = this.getCellLength(t2);
                double d9 = this.getCellPosition(t2) + d5;
                if (d9 < (d8 = this.getViewportLength())) {
                    int n3;
                    double d10 = d8 - d9;
                    for (n3 = 0; n3 < this.cells.size(); ++n3) {
                        IndexedCell indexedCell3 = (IndexedCell)this.cells.get(n3);
                        this.positionCell(indexedCell3, this.getCellPosition(indexedCell3) + d10);
                    }
                    this.setPosition(1.0);
                    indexedCell = (IndexedCell)this.cells.getFirst();
                    n3 = this.getCellIndex(indexedCell);
                    double d11 = this.getCellLength(n3 - 1);
                    this.addLeadingCells(n3 - 1, this.getCellPosition(indexedCell) - d11);
                }
            }
        }
        this.cull();
        this.updateScrollBarsAndCells(false);
        this.lastPosition = this.getPosition();
        return d4;
    }

    @Override
    protected double computePrefWidth(double d2) {
        double d3 = this.isVertical() ? this.getPrefBreadth(d2) : this.getPrefLength();
        return d3 + this.vbar.prefWidth(-1.0);
    }

    @Override
    protected double computePrefHeight(double d2) {
        double d3 = this.isVertical() ? this.getPrefLength() : this.getPrefBreadth(d2);
        return d3 + this.hbar.prefHeight(-1.0);
    }

    public T getCell(int n2) {
        Callback<VirtualFlow<T>, T> callback;
        T t2;
        if (!this.cells.isEmpty() && (t2 = this.getVisibleCell(n2)) != null) {
            return t2;
        }
        for (int i2 = 0; i2 < this.pile.size(); ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i2);
            if (this.getCellIndex(indexedCell) != n2) continue;
            this.resizeCell(indexedCell);
            return (T)indexedCell;
        }
        if (this.accumCell == null && (callback = this.getCellFactory()) != null) {
            this.accumCell = (IndexedCell)callback.call(this);
            ((Node)this.accumCell).getProperties().put(NEW_CELL, null);
            this.accumCellParent.getChildren().setAll((Node[])new Node[]{this.accumCell});
            ((Node)this.accumCell).setAccessibleRole(AccessibleRole.NODE);
            ((Parent)this.accumCell).getChildrenUnmodifiable().addListener(observable -> {
                for (Node node : ((Parent)this.accumCell).getChildrenUnmodifiable()) {
                    node.setAccessibleRole(AccessibleRole.NODE);
                }
            });
        }
        this.setCellIndex(this.accumCell, n2);
        this.resizeCell(this.accumCell);
        return this.accumCell;
    }

    protected void setCellIndex(T t2, int n2) {
        assert (t2 != null);
        ((IndexedCell)t2).updateIndex(n2);
        if (((Parent)t2).isNeedsLayout() && ((Node)t2).getScene() != null || ((Node)t2).getProperties().containsKey(NEW_CELL)) {
            ((Node)t2).applyCss();
            ((Node)t2).getProperties().remove(NEW_CELL);
        }
    }

    protected int getCellIndex(T t2) {
        return ((IndexedCell)t2).getIndex();
    }

    protected final ScrollBar getHbar() {
        return this.hbar;
    }

    protected final ScrollBar getVbar() {
        return this.vbar;
    }

    private final void setMaxPrefBreadth(double d2) {
        this.maxPrefBreadth = d2;
    }

    final double getMaxPrefBreadth() {
        return this.maxPrefBreadth;
    }

    private final void setViewportBreadth(double d2) {
        this.viewportBreadth = d2;
    }

    private final double getViewportBreadth() {
        return this.viewportBreadth;
    }

    void setViewportLength(double d2) {
        if (d2 == this.viewportLength) {
            return;
        }
        this.viewportLength = d2;
        this.absoluteOffset = this.getPosition() * (this.estimatedSize - this.viewportLength);
        this.recalculateEstimatedSize();
    }

    double getViewportLength() {
        return this.viewportLength;
    }

    double getCellLength(int n2) {
        if (this.fixedCellSizeEnabled) {
            return this.getFixedCellSize();
        }
        T t2 = this.getCell(n2);
        double d2 = this.getCellLength(t2);
        this.releaseCell(t2);
        return d2;
    }

    double getCellBreadth(int n2) {
        T t2 = this.getCell(n2);
        double d2 = this.getCellBreadth((Cell)t2);
        this.releaseCell(t2);
        return d2;
    }

    double getCellLength(T t2) {
        if (t2 == null) {
            return 0.0;
        }
        if (this.fixedCellSizeEnabled) {
            return this.getFixedCellSize();
        }
        return this.isVertical() ? ((Node)t2).getLayoutBounds().getHeight() : ((Node)t2).getLayoutBounds().getWidth();
    }

    double getCellBreadth(Cell cell) {
        return this.isVertical() ? cell.prefWidth(-1.0) : cell.prefHeight(-1.0);
    }

    double getCellPosition(T t2) {
        if (t2 == null) {
            return 0.0;
        }
        return this.isVertical() ? ((Node)t2).getLayoutY() : ((Node)t2).getLayoutX();
    }

    private void positionCell(T t2, double d2) {
        this.updateCellSize(t2);
        if (this.isVertical()) {
            ((Node)t2).setLayoutX(0.0);
            ((Node)t2).setLayoutY(this.snapSpaceY(d2));
        } else {
            ((Node)t2).setLayoutX(this.snapSpaceX(d2));
            ((Node)t2).setLayoutY(0.0);
        }
    }

    protected void resizeCell(T t2) {
        if (t2 == null) {
            return;
        }
        if (this.isVertical()) {
            double d2 = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
            ((Region)t2).resize(d2, this.fixedCellSizeEnabled ? this.getFixedCellSize() : Utils.boundedSize(((Region)t2).prefHeight(d2), ((Region)t2).minHeight(d2), ((Region)t2).maxHeight(d2)));
        } else {
            double d3 = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
            ((Region)t2).resize(this.fixedCellSizeEnabled ? this.getFixedCellSize() : Utils.boundedSize(((Region)t2).prefWidth(d3), ((Region)t2).minWidth(d3), ((Region)t2).maxWidth(d3)), d3);
        }
        this.recalculateAndImproveEstimatedSize(0);
    }

    protected List<T> getCells() {
        return this.cells;
    }

    protected T getLastVisibleCellWithinViewport() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        double d2 = this.getViewportLength();
        for (int i2 = this.cells.size() - 1; i2 >= 0; --i2) {
            double d3;
            double d4;
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            if (indexedCell.isEmpty() || !((d4 = (d3 = this.getCellPosition(indexedCell)) + this.getCellLength(indexedCell)) <= d2 + 2.0)) continue;
            return (T)indexedCell;
        }
        return null;
    }

    protected T getFirstVisibleCellWithinViewport() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i2 = 0; i2 < this.cells.size(); ++i2) {
            double d2;
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            if (indexedCell.isEmpty() || !((d2 = this.getCellPosition(indexedCell)) >= 0.0)) continue;
            return (T)indexedCell;
        }
        return null;
    }

    void addLeadingCells(int n2, double d2) {
        double d3 = d2;
        int n3 = n2;
        boolean bl2 = true;
        IndexedCell indexedCell = null;
        if (n3 == this.getCellCount() && d3 == this.getViewportLength()) {
            --n3;
            bl2 = false;
        }
        while (n3 >= 0 && (d3 > 0.0 || bl2)) {
            indexedCell = (IndexedCell)this.getAvailableCell(n3);
            this.setCellIndex(indexedCell, n3);
            this.resizeCell(indexedCell);
            this.cells.addFirst(indexedCell);
            if (bl2) {
                bl2 = false;
            } else {
                d3 -= this.getCellLength(indexedCell);
            }
            this.positionCell(indexedCell, d3);
            this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth(indexedCell)));
            indexedCell.setVisible(true);
            --n3;
        }
        if (this.cells.size() > 0) {
            indexedCell = (IndexedCell)this.cells.getFirst();
            int n4 = this.getCellIndex(indexedCell);
            double d4 = this.getCellPosition(indexedCell);
            if (n4 == 0 && d4 > 0.0) {
                this.setPosition(0.0);
                d3 = 0.0;
                for (int i2 = 0; i2 < this.cells.size(); ++i2) {
                    indexedCell = (IndexedCell)this.cells.get(i2);
                    this.positionCell(indexedCell, d3);
                    d3 += this.getCellLength(indexedCell);
                }
            }
        } else {
            this.vbar.setValue(0.0);
            this.hbar.setValue(0.0);
        }
    }

    boolean addTrailingCells(boolean bl2) {
        Object object;
        int n2;
        if (this.cells.isEmpty()) {
            return false;
        }
        IndexedCell indexedCell = (IndexedCell)this.cells.getLast();
        double d2 = this.getCellPosition(indexedCell) + this.getCellLength(indexedCell);
        int n3 = this.getCellIndex(indexedCell) + 1;
        boolean bl3 = n3 <= (n2 = this.getCellCount());
        double d3 = this.getViewportLength();
        if (d2 < 0.0 && !bl2) {
            return false;
        }
        double d4 = d3;
        while (d2 < d3) {
            if (n3 >= n2) {
                if (d2 < d3) {
                    bl3 = false;
                }
                if (!bl2) {
                    return bl3;
                }
                if ((double)n3 > d4) {
                    object = Logging.getControlsLogger();
                    if (((PlatformLogger)object).isLoggable(PlatformLogger.Level.INFO)) {
                        ((PlatformLogger)object).info("index exceeds maxCellCount. Check size calculations for " + indexedCell.getClass());
                    }
                    return bl3;
                }
            }
            object = this.getAvailableCell(n3);
            this.setCellIndex(object, n3);
            this.resizeCell(object);
            this.cells.addLast(object);
            this.positionCell(object, d2);
            this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)object)));
            d2 += this.getCellLength(object);
            ((Node)object).setVisible(true);
            ++n3;
        }
        object = (IndexedCell)this.cells.getFirst();
        n3 = this.getCellIndex(object);
        T t2 = this.getLastVisibleCell();
        double d5 = this.getCellPosition(object);
        double d6 = this.getCellPosition(t2) + this.getCellLength(t2);
        if ((n3 != 0 || n3 == 0 && d5 < 0.0) && bl2 && t2 != null && this.getCellIndex(t2) == n2 - 1 && d6 < d3) {
            double d7;
            double d8 = d3 - d6;
            for (double d9 = d6; d9 < d3 && n3 != 0 && -d5 < d8; d9 += d7) {
                T t3 = this.getAvailableCell(--n3);
                this.setCellIndex(t3, n3);
                this.resizeCell(t3);
                this.cells.addFirst(t3);
                d7 = this.getCellLength(t3);
                this.positionCell(t3, d5 -= d7);
                this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)t3)));
                ((Node)t3).setVisible(true);
            }
            object = (IndexedCell)this.cells.getFirst();
            d5 = this.getCellPosition(object);
            double d10 = d3 - d6;
            if (this.getCellIndex(object) == 0 && d10 > -d5) {
                d10 = -d5;
            }
            for (int i2 = 0; i2 < this.cells.size(); ++i2) {
                IndexedCell indexedCell2 = (IndexedCell)this.cells.get(i2);
                this.positionCell(indexedCell2, this.getCellPosition(indexedCell2) + d10);
            }
            d5 = this.getCellPosition(object);
            if (this.getCellIndex(object) == 0 && d5 == 0.0) {
                this.setPosition(0.0);
            } else if (this.getPosition() != 1.0) {
                this.setPosition(1.0);
            }
        }
        return bl3;
    }

    protected void reconfigureCells() {
        this.needsReconfigureCells = true;
        this.requestLayout();
    }

    protected void recreateCells() {
        this.needsRecreateCells = true;
        this.requestLayout();
    }

    protected void rebuildCells() {
        this.needsRebuildCells = true;
        this.requestLayout();
    }

    protected void requestCellLayout() {
        this.needsCellsLayout = true;
        this.requestLayout();
    }

    void setCellDirty(int n2) {
        this.dirtyCells.set(n2);
        this.requestLayout();
    }

    void getCellSizesInExpectedViewport(int n2) {
        double d2;
        int n3 = n2;
        for (d2 = this.getOrCreateCellSize(n2); d2 < this.viewportLength && ++n3 < this.getCellCount(); d2 += this.getOrCreateCellSize(n3)) {
        }
        if (d2 < this.viewportLength) {
            int n4 = n2;
            while (d2 < this.viewportLength && n4-- > 0) {
                d2 += this.getOrCreateCellSize(n4);
            }
        }
        this.recalculateEstimatedSize();
    }

    private void startSBReleasedAnimation() {
        if (this.sbTouchTimeline == null) {
            this.sbTouchTimeline = new Timeline();
            this.sbTouchKF1 = new KeyFrame(Duration.millis(0.0), actionEvent -> {
                this.tempVisibility = true;
                this.requestLayout();
            }, new KeyValue[0]);
            this.sbTouchKF2 = new KeyFrame(Duration.millis(1000.0), actionEvent -> {
                if (!this.touchDetected && !this.mouseDown) {
                    this.tempVisibility = false;
                    this.requestLayout();
                }
            }, new KeyValue[0]);
            this.sbTouchTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.sbTouchKF1, this.sbTouchKF2});
        }
        this.sbTouchTimeline.playFromStart();
    }

    private void scrollBarOn() {
        this.tempVisibility = true;
        this.requestLayout();
    }

    void updateHbar() {
        if (!this.isVisible() || this.getScene() == null) {
            return;
        }
        if (this.isVertical()) {
            if (this.needBreadthBar) {
                this.clipView.setClipX(this.hbar.getValue());
            } else {
                this.clipView.setClipX(0.0);
                this.hbar.setValue(0.0);
            }
        }
    }

    private boolean computeBarVisiblity() {
        if (this.cells.isEmpty()) {
            this.needLengthBar = false;
            this.needBreadthBar = false;
            return true;
        }
        boolean bl2 = this.isVertical();
        boolean bl3 = false;
        VirtualScrollBar virtualScrollBar = bl2 ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = bl2 ? this.vbar : this.hbar;
        double d2 = this.getViewportBreadth();
        int n2 = this.cells.size();
        int n3 = this.getCellCount();
        for (int i2 = 0; i2 < 2; ++i2) {
            boolean bl4;
            boolean bl5;
            boolean bl6 = bl5 = this.getPosition() > 0.0 || n3 > n2 || n3 == n2 && this.getCellPosition((IndexedCell)this.cells.getLast()) + this.getCellLength((IndexedCell)this.cells.getLast()) > this.getViewportLength() || n3 == n2 - 1 && bl3 && this.needBreadthBar;
            if (bl5 ^ this.needLengthBar) {
                this.needLengthBar = bl5;
                bl3 = true;
            }
            boolean bl7 = bl4 = this.maxPrefBreadth > d2;
            if (!(bl4 ^ this.needBreadthBar)) continue;
            this.needBreadthBar = bl4;
            bl3 = true;
        }
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.updateViewportDimensions();
            virtualScrollBar.setVisible(this.needBreadthBar);
            virtualScrollBar2.setVisible(this.needLengthBar);
        } else {
            virtualScrollBar.setVisible(this.needBreadthBar && this.tempVisibility);
            virtualScrollBar2.setVisible(this.needLengthBar && this.tempVisibility);
        }
        return bl3;
    }

    private void updateViewportDimensions() {
        double d2;
        boolean bl2 = this.isVertical();
        double d3 = bl2 ? this.snapSizeY(this.hbar.prefHeight(-1.0)) : this.snapSizeX(this.vbar.prefWidth(-1.0));
        double d4 = d2 = bl2 ? this.snapSizeX(this.vbar.prefWidth(-1.0)) : this.snapSizeY(this.hbar.prefHeight(-1.0));
        if (!Properties.IS_TOUCH_SUPPORTED) {
            this.setViewportBreadth((bl2 ? this.getWidth() : this.getHeight()) - (this.needLengthBar ? d2 : 0.0));
            this.setViewportLength((bl2 ? this.getHeight() : this.getWidth()) - (this.needBreadthBar ? d3 : 0.0));
        } else {
            this.setViewportBreadth(bl2 ? this.getWidth() : this.getHeight());
            this.setViewportLength(bl2 ? this.getHeight() : this.getWidth());
        }
    }

    private void initViewport() {
        boolean bl2 = this.isVertical();
        this.updateViewportDimensions();
        VirtualScrollBar virtualScrollBar = bl2 ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = bl2 ? this.vbar : this.hbar;
        virtualScrollBar.setVirtual(false);
        virtualScrollBar2.setVirtual(true);
    }

    private void shiftDown() {
        T t2 = this.getLastVisibleCell();
        IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
        int n2 = this.getCellIndex(indexedCell);
        double d2 = this.getCellPosition(t2) + this.getCellLength(t2);
        double d3 = this.viewportLength - d2;
        if (n2 > 0 && d3 > 0.0) {
            for (int i2 = 0; i2 < this.cells.size(); ++i2) {
                IndexedCell indexedCell2 = (IndexedCell)this.cells.get(i2);
                this.positionCell(indexedCell2, this.getCellPosition(indexedCell2) + d3);
            }
        }
    }

    private void updateScrollBarsAndCells(boolean bl2) {
        double d2;
        double d3;
        boolean bl3 = this.isVertical();
        VirtualScrollBar virtualScrollBar = bl3 ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = bl3 ? this.vbar : this.hbar;
        this.fitCells();
        if (!this.cells.isEmpty()) {
            IndexedCell indexedCell;
            int n2;
            d3 = -this.computeViewportOffset(this.getPosition());
            int n3 = this.computeCurrentIndex() - ((IndexedCell)this.cells.getFirst()).getIndex();
            int n4 = this.cells.size();
            d2 = d3;
            for (n2 = n3 - 1; n2 >= 0 && n2 < n4; --n2) {
                indexedCell = (IndexedCell)this.cells.get(n2);
                this.positionCell(indexedCell, d2 -= this.getCellLength(indexedCell));
            }
            d2 = d3;
            for (n2 = n3; n2 >= 0 && n2 < n4; ++n2) {
                indexedCell = (IndexedCell)this.cells.get(n2);
                this.positionCell(indexedCell, d2);
                d2 += this.getCellLength(indexedCell);
            }
            this.shiftDown();
        }
        this.corner.setVisible(virtualScrollBar.isVisible() && virtualScrollBar2.isVisible());
        d3 = 0.0;
        double d4 = (bl3 ? this.getHeight() : this.getWidth()) - (virtualScrollBar.isVisible() ? virtualScrollBar.prefHeight(-1.0) : 0.0);
        d2 = this.getViewportBreadth();
        double d5 = this.getViewportLength();
        if (virtualScrollBar.isVisible()) {
            double d6;
            if (!Properties.IS_TOUCH_SUPPORTED) {
                if (bl3) {
                    this.hbar.resizeRelocate(0.0, d5, d2, this.hbar.prefHeight(d2));
                } else {
                    this.vbar.resizeRelocate(d5, 0.0, this.vbar.prefWidth(d2), d2);
                }
            } else if (bl3) {
                d6 = this.hbar.prefHeight(d2);
                this.hbar.resizeRelocate(0.0, d5 - d6, d2, d6);
            } else {
                d6 = this.vbar.prefWidth(d2);
                this.vbar.resizeRelocate(d5 - d6, 0.0, d6, d2);
            }
            if (this.getMaxPrefBreadth() != -1.0 && (d6 = Math.max(1.0, this.getMaxPrefBreadth() - d2)) != virtualScrollBar.getMax()) {
                boolean bl4;
                virtualScrollBar.setMax(d6);
                double d7 = virtualScrollBar.getValue();
                boolean bl5 = bl4 = d7 != 0.0 && d6 == d7;
                if (bl4 || d7 > d6) {
                    virtualScrollBar.setValue(d6);
                }
                virtualScrollBar.setVisibleAmount(d2 / this.getMaxPrefBreadth() * d6);
            }
        }
        if (bl2 && (virtualScrollBar2.isVisible() || Properties.IS_TOUCH_SUPPORTED)) {
            int n5 = this.getCellCount();
            int n6 = 0;
            int n7 = this.cells.size();
            for (int i2 = 0; i2 < n7; ++i2) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
                if (indexedCell == null || indexedCell.isEmpty()) continue;
                if ((d3 += bl3 ? indexedCell.getHeight() : indexedCell.getWidth()) > d4) break;
                ++n6;
            }
            virtualScrollBar2.setMax(1.0);
            if (n6 == 0 && n5 == 1) {
                virtualScrollBar2.setVisibleAmount(d4 / d3);
            } else {
                virtualScrollBar2.setVisibleAmount(d5 / this.estimatedSize);
            }
        }
        if (virtualScrollBar2.isVisible()) {
            if (!Properties.IS_TOUCH_SUPPORTED) {
                if (bl3) {
                    this.vbar.resizeRelocate(d2, 0.0, this.vbar.prefWidth(d5), d5);
                } else {
                    this.hbar.resizeRelocate(0.0, d2, d5, this.hbar.prefHeight(-1.0));
                }
            } else if (bl3) {
                double d8 = this.vbar.prefWidth(d5);
                this.vbar.resizeRelocate(d2 - d8, 0.0, d8, d5);
            } else {
                double d9 = this.hbar.prefHeight(-1.0);
                this.hbar.resizeRelocate(0.0, d2 - d9, d5, d9);
            }
        }
        if (this.corner.isVisible()) {
            if (!Properties.IS_TOUCH_SUPPORTED) {
                this.corner.resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + this.hbar.getWidth(), this.vbar.getLayoutY() + this.vbar.getHeight());
            } else {
                this.corner.resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + (this.hbar.getWidth() - this.vbar.getWidth()), this.vbar.getLayoutY() + (this.vbar.getHeight() - this.hbar.getHeight()));
                this.hbar.resize(this.hbar.getWidth() - this.vbar.getWidth(), this.hbar.getHeight());
                this.vbar.resize(this.vbar.getWidth(), this.vbar.getHeight() - this.hbar.getHeight());
            }
        }
        this.clipView.resize(this.snapSizeX(bl3 ? d2 : d5), this.snapSizeY(bl3 ? d5 : d2));
        if (this.getPosition() != virtualScrollBar2.getValue()) {
            virtualScrollBar2.setValue(this.getPosition());
        }
    }

    private void fitCells() {
        double d2 = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
        boolean bl2 = this.isVertical();
        for (int i2 = 0; i2 < this.cells.size(); ++i2) {
            Cell cell = (Cell)this.cells.get(i2);
            if (bl2) {
                cell.resize(d2, cell.prefHeight(d2));
                continue;
            }
            cell.resize(cell.prefWidth(d2), d2);
        }
    }

    private void cull() {
        double d2 = this.getViewportLength();
        for (int i2 = this.cells.size() - 1; i2 >= 0; --i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            double d3 = this.getCellLength(indexedCell);
            double d4 = this.getCellPosition(indexedCell);
            double d5 = d4 + d3;
            if (!(d4 >= d2) && !(d5 < 0.0)) continue;
            this.addToPile((IndexedCell)this.cells.remove(i2));
        }
    }

    private void releaseCell(T t2) {
        if (this.accumCell != null && t2 == this.accumCell) {
            ((Node)this.accumCell).setVisible(false);
            ((IndexedCell)this.accumCell).updateIndex(-1);
        }
    }

    protected T getPrivateCell(int n2) {
        Callback<VirtualFlow<T>, T> callback;
        Parent parent = null;
        if (!this.cells.isEmpty() && (parent = (Parent)this.getVisibleCell(n2)) != null) {
            parent.layout();
            return (T)parent;
        }
        if (parent == null) {
            for (int i2 = 0; i2 < this.sheetChildren.size(); ++i2) {
                IndexedCell indexedCell = (IndexedCell)this.sheetChildren.get(i2);
                if (this.getCellIndex(indexedCell) != n2) continue;
                return (T)indexedCell;
            }
        }
        if ((callback = this.getCellFactory()) != null) {
            parent = (IndexedCell)callback.call(this);
        }
        if (parent != null) {
            this.setCellIndex(parent, n2);
            this.resizeCell(parent);
            parent.setVisible(false);
            this.sheetChildren.add(parent);
            this.privateCells.add(parent);
        }
        return (T)parent;
    }

    private void releaseAllPrivateCells() {
        this.sheetChildren.removeAll((Collection<?>)this.privateCells);
        this.privateCells.clear();
    }

    private void addToPile(T t2) {
        assert (t2 != null);
        this.pile.addLast(t2);
    }

    private void cleanPile() {
        boolean bl2 = false;
        int n2 = this.pile.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i2);
            bl2 = bl2 || this.doesCellContainFocus(indexedCell);
            indexedCell.setVisible(false);
        }
        if (bl2) {
            this.requestFocus();
        }
    }

    private boolean doesCellContainFocus(Cell<?> cell) {
        Node node;
        Scene scene = cell.getScene();
        Node node2 = node = scene == null ? null : scene.getFocusOwner();
        if (node != null) {
            if (cell.equals(node)) {
                return true;
            }
            for (Parent parent = node.getParent(); parent != null && !(parent instanceof VirtualFlow); parent = parent.getParent()) {
                if (!cell.equals(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private double getPrefBreadth(double d2) {
        double d3 = this.getMaxCellWidth(10);
        if (d2 > -1.0) {
            double d4 = this.getPrefLength();
            d3 = Math.max(d3, d4 * 0.618033987);
        }
        return d3;
    }

    private double getPrefLength() {
        double d2 = 0.0;
        int n2 = Math.min(10, this.getCellCount());
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += this.getCellLength(i2);
        }
        return d2;
    }

    double getMaxCellWidth(int n2) {
        double d2 = 0.0;
        int n3 = Math.max(1, n2 == -1 ? this.getCellCount() : n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            d2 = Math.max(d2, this.getCellBreadth(i2));
        }
        return d2;
    }

    private double computeViewportOffset(double d2) {
        double d3 = com.sun.javafx.util.Utils.clamp(0.0, d2, 1.0);
        double d4 = 0.0;
        double d5 = this.estimatedSize / (double)this.getCellCount();
        for (int i2 = 0; i2 < this.getCellCount(); ++i2) {
            double d6 = this.getCellSize(i2);
            if (d6 < 0.0) {
                d6 = d5;
            }
            if (d4 + d6 > this.absoluteOffset) {
                return this.absoluteOffset - d4;
            }
            d4 += d6;
        }
        return 0.0;
    }

    private void adjustPositionToIndex(int n2) {
        if (n2 > 0) {
            this.getOrCreateCellSize(n2 - 1);
        }
        this.getOrCreateCellSize(n2);
        this.recalculateEstimatedSize();
        int n3 = this.getCellCount();
        if (n3 <= 0) {
            this.setPosition(0.0);
        } else {
            double d2 = 0.0;
            double d3 = this.estimatedSize / (double)n3;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d4 = this.getCellSize(i2);
                if (d4 < 0.0) {
                    d4 = d3;
                }
                d2 += d4;
            }
            this.absoluteOffset = this.estimatedSize < this.viewportLength ? 0.0 : d2;
            this.adjustPosition();
        }
    }

    private double adjustByPixelAmount(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        if (this.absoluteOffset <= 0.0 && d2 < 0.0) {
            return 0.0;
        }
        double d3 = this.absoluteOffset;
        this.absoluteOffset = Math.max(0.0, this.absoluteOffset + d2);
        double d4 = Math.min(1.0, this.absoluteOffset / (this.estimatedSize - this.viewportLength));
        if (d2 > 0.0 && d4 < this.getPosition()) {
            d4 = this.getPosition() * 1.01;
        }
        if (d2 < 0.0 && d4 > this.getPosition()) {
            d4 = this.getPosition() * 0.99;
        }
        if (d4 > 0.95) {
            for (int i2 = this.computeCurrentIndex(); i2 < this.getCellCount(); ++i2) {
                this.getOrCreateCellSize(i2);
            }
            this.recalculateEstimatedSize();
        }
        if (d4 >= 1.0) {
            this.absoluteOffset = this.estimatedSize - this.viewportLength;
        }
        this.setPosition(d4);
        return this.absoluteOffset - d3;
    }

    private int computeCurrentIndex() {
        double d2 = 0.0;
        int n2 = this.getCellCount();
        double d3 = this.estimatedSize / (double)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = this.getCellSize(i2);
            if (d4 < 0.0) {
                d4 = d3;
            }
            if (!((d2 += d4) > this.absoluteOffset)) continue;
            return i2;
        }
        return n2 == 0 ? 0 : n2 - 1;
    }

    private double computeOffsetForCell(int n2) {
        double d2 = this.getCellCount();
        double d3 = com.sun.javafx.util.Utils.clamp(0.0, (double)n2, d2) / d2;
        return -(this.getViewportLength() * d3);
    }

    double getCellSize(int n2) {
        return this.getOrCreateCellSize(n2, false);
    }

    double getOrCreateCellSize(int n2) {
        return this.getOrCreateCellSize(n2, true);
    }

    private double getOrCreateCellSize(int n2, boolean bl2) {
        if (n2 < 0) {
            return -1.0;
        }
        if (this.itemSizeCache.size() > n2 && this.itemSizeCache.get(n2) != null) {
            return this.itemSizeCache.get(n2);
        }
        if (!bl2) {
            return -1.0;
        }
        boolean bl3 = false;
        while (n2 >= this.itemSizeCache.size()) {
            this.itemSizeCache.add(this.itemSizeCache.size(), null);
        }
        double d2 = 1.0;
        if (this.getFixedCellSize() > 0.0) {
            d2 = this.getFixedCellSize();
            this.itemSizeCache.set(n2, d2);
        } else {
            T t2 = this.getVisibleCell(n2);
            if (t2 == null) {
                t2 = this.getCell(n2);
                bl3 = true;
            }
            d2 = this.isVertical() ? ((Node)t2).getLayoutBounds().getHeight() : ((Node)t2).getLayoutBounds().getWidth();
            this.itemSizeCache.set(n2, d2);
            if (bl3) {
                this.releaseCell(t2);
            }
        }
        return d2;
    }

    void updateCellSize(T t2) {
        int n2 = ((IndexedCell)t2).getIndex();
        if (this.itemSizeCache.size() > n2) {
            if (this.isVertical()) {
                double d2 = ((Node)t2).getLayoutBounds().getHeight();
                this.itemSizeCache.set(n2, d2);
            } else {
                double d3 = ((Node)t2).getLayoutBounds().getWidth();
                this.itemSizeCache.set(n2, d3);
            }
        }
    }

    private void recalculateEstimatedSize() {
        this.recalculateAndImproveEstimatedSize(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateAndImproveEstimatedSize(int n2) {
        if (this.recalculating) {
            return;
        }
        this.recalculating = true;
        try {
            int n3 = this.getCellCount();
            int n4 = this.itemSizeCache.size();
            boolean bl2 = n4 > 0 && !Double.isInfinite(this.absoluteOffset);
            int n5 = this.computeCurrentIndex();
            double d2 = this.computeViewportOffset(this.getPosition());
            for (int i2 = 0; n3 > this.itemSizeCache.size() && i2 < n2; ++i2) {
                this.getOrCreateCellSize(this.itemSizeCache.size());
            }
            n4 = this.itemSizeCache.size();
            int n6 = 0;
            double d3 = 0.0;
            for (int i3 = 0; i3 < n3 && i3 < n4; ++i3) {
                Double d4 = this.itemSizeCache.get(i3);
                if (d4 == null) continue;
                d3 += d4.doubleValue();
                ++n6;
            }
            this.estimatedSize = n6 == 0 ? 1.0 : d3 * (double)n3 / (double)n6;
            double d5 = this.estimatedSize / (double)n3;
            if (bl2) {
                double d6 = 0.0;
                for (int i4 = 0; i4 < n5; ++i4) {
                    double d7 = this.getCellSize(i4);
                    if (d7 < 0.0) {
                        d7 = d5;
                    }
                    d6 += d7;
                }
                this.absoluteOffset = d6 + d2;
                this.adjustPosition();
            }
        }
        finally {
            this.recalculating = false;
        }
    }

    private void resetSizeEstimates() {
        this.itemSizeCache.clear();
        this.estimatedSize = 1.0;
    }

    static class ArrayLinkedList<T>
    extends AbstractList<T> {
        private final ArrayList<T> array = new ArrayList(50);
        private int firstIndex = -1;
        private int lastIndex = -1;

        public ArrayLinkedList() {
            for (int i2 = 0; i2 < 50; ++i2) {
                this.array.add(null);
            }
        }

        @Override
        public T getFirst() {
            return this.firstIndex == -1 ? null : (T)this.array.get(this.firstIndex);
        }

        @Override
        public T getLast() {
            return this.lastIndex == -1 ? null : (T)this.array.get(this.lastIndex);
        }

        @Override
        public void addFirst(T t2) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.firstIndex, t2);
            } else if (this.firstIndex == 0) {
                this.array.add(0, t2);
                ++this.lastIndex;
            } else {
                this.array.set(--this.firstIndex, t2);
            }
        }

        @Override
        public void addLast(T t2) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.lastIndex, t2);
            } else if (this.lastIndex == this.array.size() - 1) {
                this.array.add(++this.lastIndex, t2);
            } else {
                this.array.set(++this.lastIndex, t2);
            }
        }

        @Override
        public int size() {
            return this.firstIndex == -1 ? 0 : this.lastIndex - this.firstIndex + 1;
        }

        @Override
        public boolean isEmpty() {
            return this.firstIndex == -1;
        }

        @Override
        public T get(int n2) {
            if (n2 > this.lastIndex - this.firstIndex || n2 < 0) {
                return null;
            }
            return this.array.get(this.firstIndex + n2);
        }

        @Override
        public void clear() {
            for (int i2 = 0; i2 < this.array.size(); ++i2) {
                this.array.set(i2, null);
            }
            this.lastIndex = -1;
            this.firstIndex = -1;
        }

        @Override
        public T removeFirst() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(0);
        }

        @Override
        public T removeLast() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(this.lastIndex - this.firstIndex);
        }

        @Override
        public T remove(int n2) {
            if (n2 > this.lastIndex - this.firstIndex || n2 < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n2 == 0) {
                T t2 = this.array.get(this.firstIndex);
                this.array.set(this.firstIndex, null);
                if (this.firstIndex == this.lastIndex) {
                    this.lastIndex = -1;
                    this.firstIndex = -1;
                } else {
                    ++this.firstIndex;
                }
                return t2;
            }
            if (n2 == this.lastIndex - this.firstIndex) {
                T t3 = this.array.get(this.lastIndex);
                this.array.set(this.lastIndex--, null);
                return t3;
            }
            T t4 = this.array.get(this.firstIndex + n2);
            this.array.set(this.firstIndex + n2, null);
            for (int i2 = this.firstIndex + n2 + 1; i2 <= this.lastIndex; ++i2) {
                this.array.set(i2 - 1, this.array.get(i2));
            }
            this.array.set(this.lastIndex--, null);
            return t4;
        }
    }

    static class ClippedContainer
    extends Region {
        private Node node;
        private final Rectangle clipRect;

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
            this.getChildren().clear();
            this.getChildren().add(this.node);
        }

        public void setClipX(double d2) {
            this.setLayoutX(-d2);
            this.clipRect.setLayoutX(d2);
        }

        public void setClipY(double d2) {
            this.setLayoutY(-d2);
            this.clipRect.setLayoutY(d2);
        }

        public ClippedContainer(VirtualFlow<?> virtualFlow) {
            if (virtualFlow == null) {
                throw new IllegalArgumentException("VirtualFlow can not be null");
            }
            this.getStyleClass().add("clipped-container");
            this.clipRect = new Rectangle();
            this.clipRect.setSmooth(false);
            this.setClip(this.clipRect);
            super.widthProperty().addListener(observable -> this.clipRect.setWidth(this.getWidth()));
            super.heightProperty().addListener(observable -> this.clipRect.setHeight(this.getHeight()));
        }
    }
}

