/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.SplitPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class SplitPaneSkin
extends SkinBase<SplitPane> {
    private ObservableList<Content> contentRegions;
    private ObservableList<ContentDivider> contentDividers;
    private boolean horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
    private boolean duringLayout;
    private double previousSize = -1.0;
    private int lastDividerUpdate = 0;
    private boolean resize = false;
    private boolean checkDividerPos = true;

    public SplitPaneSkin(SplitPane splitPane) {
        super(splitPane);
        this.contentRegions = FXCollections.observableArrayList();
        this.contentDividers = FXCollections.observableArrayList();
        int n2 = 0;
        for (Node object : ((SplitPane)this.getSkinnable()).getItems()) {
            this.addContent(n2++, object);
        }
        this.initializeContentListener();
        for (SplitPane.Divider divider : ((SplitPane)this.getSkinnable()).getDividers()) {
            this.addDivider(divider);
        }
        this.registerChangeListener(splitPane.orientationProperty(), observableValue -> {
            this.horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
            this.previousSize = -1.0;
            for (ContentDivider contentDivider : this.contentDividers) {
                contentDivider.setGrabberStyle(this.horizontal);
            }
            ((SplitPane)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener(splitPane.widthProperty(), observableValue -> ((SplitPane)this.getSkinnable()).requestLayout());
        this.registerChangeListener(splitPane.heightProperty(), observableValue -> ((SplitPane)this.getSkinnable()).requestLayout());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        int n2;
        int n3;
        double d6;
        block61: {
            double d7;
            double d8;
            block60: {
                int n4;
                boolean bl2;
                ArrayList<Content> arrayList;
                block56: {
                    block59: {
                        SplitPane splitPane = (SplitPane)this.getSkinnable();
                        d8 = splitPane.getWidth();
                        d7 = splitPane.getHeight();
                        if (this.horizontal) {
                            if (d8 == 0.0) {
                                return;
                            }
                        } else if (d7 == 0.0) return;
                        if (this.contentRegions.isEmpty()) {
                            return;
                        }
                        double d9 = d6 = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
                        if (this.contentDividers.size() <= 0 || this.previousSize == -1.0 || this.previousSize == (this.horizontal ? d8 : d7)) break block59;
                        arrayList = new ArrayList<Content>();
                        for (Content content : this.contentRegions) {
                            if (!content.isResizableWithParent()) continue;
                            arrayList.add(content);
                        }
                        double d10 = (this.horizontal ? splitPane.getWidth() : splitPane.getHeight()) - this.previousSize;
                        bl2 = d10 > 0.0;
                        if ((d10 = Math.abs(d10)) == 0.0 || arrayList.isEmpty()) break block60;
                        n3 = (int)d10 / arrayList.size();
                        n2 = (int)d10 % arrayList.size();
                        n4 = 0;
                        if (n3 == 0) {
                            n3 = n2;
                            n4 = n2;
                            n2 = 0;
                            break block56;
                        } else {
                            n4 = n3 * arrayList.size();
                        }
                        break block56;
                    }
                    this.previousSize = this.horizontal ? d8 : d7;
                    break block61;
                }
                while (n4 > 0 && !arrayList.isEmpty()) {
                    double d11;
                    Content content;
                    block57: {
                        double d12;
                        int n5;
                        if (bl2) {
                            ++this.lastDividerUpdate;
                        } else {
                            --this.lastDividerUpdate;
                            if (this.lastDividerUpdate < 0) {
                                this.lastDividerUpdate = this.contentRegions.size() - 1;
                            }
                        }
                        if (!(content = (Content)this.contentRegions.get(n5 = this.lastDividerUpdate % this.contentRegions.size())).isResizableWithParent() || !arrayList.contains(content)) continue;
                        d11 = content.getArea();
                        if (bl2) {
                            double d13 = d12 = this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0);
                            if (d11 + (double)n3 <= d12) {
                                d11 += (double)n3;
                                break block57;
                            } else {
                                arrayList.remove(content);
                                continue;
                            }
                        }
                        double d14 = d12 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                        if (d11 - (double)n3 >= d12) {
                            d11 -= (double)n3;
                        } else {
                            arrayList.remove(content);
                            continue;
                        }
                    }
                    content.setArea(d11);
                    if ((n4 -= n3) == 0 && n2 != 0) {
                        n3 = n2;
                        n4 = n2;
                        n2 = 0;
                        continue;
                    }
                    if (n4 != 0) continue;
                }
                for (Content content : this.contentRegions) {
                    content.setResizableWithParentArea(content.getArea());
                    content.setAvailable(0.0);
                }
                this.resize = true;
            }
            this.previousSize = this.horizontal ? d8 : d7;
        }
        this.duringLayout = true;
        double d15 = this.totalMinSize();
        if (!(d15 > (this.horizontal ? d4 : d5))) {
        } else {
            double d16 = 0.0;
            n3 = 0;
            while (true) {
                if (n3 >= this.contentRegions.size()) {
                    this.setupContentAndDividerForLayout();
                    this.layoutDividersAndContent(d4, d5);
                    this.resize = false;
                    this.duringLayout = false;
                    return;
                }
                Content content = (Content)this.contentRegions.get(n3);
                double d17 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                d16 = d17 / d15;
                if (this.horizontal) {
                    content.setArea(this.snapSpaceX(d16 * d4));
                } else {
                    content.setArea(this.snapSpaceY(d16 * d5));
                }
                content.setAvailable(0.0);
                ++n3;
            }
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            ContentDivider contentDivider = null;
            ContentDivider contentDivider2 = null;
            for (n2 = 0; n2 < this.contentRegions.size(); ++n2) {
                double d18 = 0.0;
                if (n2 < this.contentDividers.size()) {
                    contentDivider2 = (ContentDivider)this.contentDividers.get(n2);
                    if (contentDivider2.posExplicit) {
                        this.checkDividerPosition(contentDivider2, this.posToDividerPos(contentDivider2, contentDivider2.d.getPosition()), contentDivider2.getDividerPos());
                    }
                    if (n2 == 0) {
                        d18 = this.getAbsoluteDividerPos(contentDivider2);
                    } else {
                        double d19 = this.getAbsoluteDividerPos(contentDivider) + d6;
                        if (this.getAbsoluteDividerPos(contentDivider2) <= this.getAbsoluteDividerPos(contentDivider)) {
                            this.setAndCheckAbsoluteDividerPos(contentDivider2, d19);
                        }
                        d18 = this.getAbsoluteDividerPos(contentDivider2) - d19;
                    }
                } else if (n2 == this.contentDividers.size()) {
                    d18 = (this.horizontal ? d4 : d5) - (contentDivider != null ? this.getAbsoluteDividerPos(contentDivider) + d6 : 0.0);
                }
                if (!this.resize || contentDivider2.posExplicit) {
                    ((Content)this.contentRegions.get(n2)).setArea(d18);
                }
                contentDivider = contentDivider2;
            }
            double d20 = 0.0;
            double d21 = 0.0;
            for (Content content : this.contentRegions) {
                double d22;
                if (content == null) continue;
                double d23 = this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0);
                double d24 = d22 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                if (content.getArea() >= d23) {
                    d21 += content.getArea() - d23;
                    content.setArea(d23);
                }
                content.setAvailable(content.getArea() - d22);
                if (!(content.getAvailable() < 0.0)) continue;
                d20 += content.getAvailable();
            }
            d20 = Math.abs(d20);
            ArrayList arrayList = new ArrayList();
            ArrayList<Content> arrayList2 = new ArrayList<Content>();
            ArrayList<Content> arrayList3 = new ArrayList<Content>();
            double d25 = 0.0;
            for (Content content : this.contentRegions) {
                if (content.getAvailable() >= 0.0) {
                    d25 += content.getAvailable();
                    arrayList.add(content);
                }
                if (this.resize && !content.isResizableWithParent()) {
                    if (content.getArea() >= content.getResizableWithParentArea()) {
                        d21 += content.getArea() - content.getResizableWithParentArea();
                    } else {
                        d20 += content.getResizableWithParentArea() - content.getArea();
                    }
                    content.setAvailable(0.0);
                }
                if (this.resize) {
                    if (content.isResizableWithParent()) {
                        arrayList2.add(content);
                    }
                } else {
                    arrayList2.add(content);
                }
                if (!(content.getAvailable() < 0.0)) continue;
                arrayList3.add(content);
            }
            if (d21 > 0.0) {
                d21 = this.distributeTo(arrayList2, d21);
                d20 = 0.0;
                arrayList3.clear();
                d25 = 0.0;
                arrayList.clear();
                for (Content content : this.contentRegions) {
                    if (content.getAvailable() < 0.0) {
                        d20 += content.getAvailable();
                        arrayList3.add(content);
                        continue;
                    }
                    d25 += content.getAvailable();
                    arrayList.add(content);
                }
                d20 = Math.abs(d20);
            }
            if (d25 >= d20) {
                for (Content content : arrayList3) {
                    double d26 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                    content.setArea(d26);
                    content.setAvailable(0.0);
                }
                if (d20 > 0.0 && !arrayList3.isEmpty()) {
                    this.distributeFrom(d20, arrayList);
                }
                if (this.resize) {
                    double d27 = 0.0;
                    for (Content content : this.contentRegions) {
                        if (content.isResizableWithParent()) {
                            d27 += content.getArea();
                            continue;
                        }
                        d27 += content.getResizableWithParentArea();
                    }
                    d27 += d6 * (double)this.contentDividers.size();
                    double d28 = this.horizontal ? d4 : d5;
                    if (d27 < d28) {
                        this.distributeTo(arrayList2, d21 += (this.horizontal ? d4 : d5) - d27);
                    } else {
                        this.distributeFrom(d20 += d27 - (this.horizontal ? d4 : d5), arrayList2);
                    }
                }
            }
            this.setupContentAndDividerForLayout();
            boolean bl3 = true;
            for (Content content : this.contentRegions) {
                double d29;
                double d30 = this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0);
                double d31 = d29 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                if (!(content.getArea() < d29) && !(content.getArea() > d30)) continue;
                bl3 = false;
                break;
            }
            if (bl3) break;
        }
        this.layoutDividersAndContent(d4, d5);
        this.duringLayout = false;
        this.resize = false;
    }

    @Override
    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d7 += stackPane.minWidth(-1.0);
            d8 = Math.max(d8, stackPane.minWidth(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d7 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d7 + d6 + d4;
        }
        return d8 + d6 + d4;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d7 += stackPane.minHeight(-1.0);
            d8 = Math.max(d8, stackPane.minHeight(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d7 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d8 + d3 + d5;
        }
        return d7 + d3 + d5;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d7 += stackPane.prefWidth(-1.0);
            d8 = Math.max(d8, stackPane.prefWidth(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d7 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d7 + d6 + d4;
        }
        return d8 + d6 + d4;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        for (Content stackPane : this.contentRegions) {
            d7 += stackPane.prefHeight(-1.0);
            d8 = Math.max(d8, stackPane.prefHeight(-1.0));
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            d7 += contentDivider.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return d8 + d3 + d5;
        }
        return d7 + d3 + d5;
    }

    private void addContent(int n2, Node node) {
        Content content = new Content(node);
        this.contentRegions.add(n2, content);
        this.getChildren().add(n2, content);
    }

    private void removeContent(Node node) {
        for (Content content : this.contentRegions) {
            if (!content.getContent().equals(node)) continue;
            content.dispose();
            this.getChildren().remove(content);
            this.contentRegions.remove(content);
            break;
        }
    }

    private void initializeContentListener() {
        ((SplitPane)this.getSkinnable()).getItems().addListener(change -> {
            while (change.next()) {
                int n2;
                if (change.wasPermutated() || change.wasUpdated()) {
                    this.getChildren().clear();
                    this.contentRegions.clear();
                    n2 = 0;
                    for (Node node : change.getList()) {
                        this.addContent(n2++, node);
                    }
                    continue;
                }
                for (Node node : change.getRemoved()) {
                    this.removeContent(node);
                }
                n2 = change.getFrom();
                for (Node node : change.getAddedSubList()) {
                    this.addContent(n2++, node);
                }
            }
            this.removeAllDividers();
            for (SplitPane.Divider divider : ((SplitPane)this.getSkinnable()).getDividers()) {
                this.addDivider(divider);
            }
        });
    }

    private void checkDividerPosition(ContentDivider contentDivider, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7 = contentDivider.prefWidth(-1.0);
        Content content = this.getLeft(contentDivider);
        Content content2 = this.getRight(contentDivider);
        double d8 = content == null ? 0.0 : (d6 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0));
        double d9 = content2 == null ? 0.0 : (d5 = this.horizontal ? content2.minWidth(-1.0) : content2.minHeight(-1.0));
        double d10 = content == null ? 0.0 : (content.getContent() != null ? (this.horizontal ? content.getContent().maxWidth(-1.0) : content.getContent().maxHeight(-1.0)) : (d4 = 0.0));
        double d11 = content2 == null ? 0.0 : (content2.getContent() != null ? (this.horizontal ? content2.getContent().maxWidth(-1.0) : content2.getContent().maxHeight(-1.0)) : 0.0);
        double d12 = 0.0;
        double d13 = this.getSize();
        int n2 = this.contentDividers.indexOf(contentDivider);
        if (n2 - 1 >= 0 && (d12 = ((ContentDivider)this.contentDividers.get(n2 - 1)).getDividerPos()) == -1.0) {
            d12 = this.getAbsoluteDividerPos((ContentDivider)this.contentDividers.get(n2 - 1));
        }
        if (n2 + 1 < this.contentDividers.size() && (d13 = ((ContentDivider)this.contentDividers.get(n2 + 1)).getDividerPos()) == -1.0) {
            d13 = this.getAbsoluteDividerPos((ContentDivider)this.contentDividers.get(n2 + 1));
        }
        this.checkDividerPos = false;
        if (d2 > d3) {
            double d14;
            double d15 = d12 == 0.0 ? d4 : d12 + d7 + d4;
            double d16 = Math.min(d15, d14 = d13 - d5 - d7);
            if (d2 >= d16) {
                this.setAbsoluteDividerPos(contentDivider, d16);
            } else {
                double d17 = d13 - d11 - d7;
                if (d2 <= d17) {
                    this.setAbsoluteDividerPos(contentDivider, d17);
                } else {
                    this.setAbsoluteDividerPos(contentDivider, d2);
                }
            }
        } else {
            double d18 = d13 - d11 - d7;
            double d19 = d12 == 0.0 ? d6 : d12 + d6 + d7;
            double d20 = Math.max(d18, d19);
            if (d2 <= d20) {
                this.setAbsoluteDividerPos(contentDivider, d20);
            } else {
                double d21 = d12 + d4 + d7;
                if (d2 >= d21) {
                    this.setAbsoluteDividerPos(contentDivider, d21);
                } else {
                    this.setAbsoluteDividerPos(contentDivider, d2);
                }
            }
        }
        this.checkDividerPos = true;
    }

    private void addDivider(SplitPane.Divider divider) {
        ContentDivider contentDivider = new ContentDivider(divider);
        contentDivider.setInitialPos(divider.getPosition());
        contentDivider.setDividerPos(-1.0);
        PosPropertyListener posPropertyListener = new PosPropertyListener(contentDivider);
        contentDivider.setPosPropertyListener(posPropertyListener);
        divider.positionProperty().addListener(posPropertyListener);
        this.initializeDividerEventHandlers(contentDivider);
        this.contentDividers.add(contentDivider);
        this.getChildren().add(contentDivider);
    }

    private void removeAllDividers() {
        ListIterator listIterator = this.contentDividers.listIterator();
        while (listIterator.hasNext()) {
            ContentDivider contentDivider = (ContentDivider)listIterator.next();
            this.getChildren().remove(contentDivider);
            contentDivider.getDivider().positionProperty().removeListener(contentDivider.getPosPropertyListener());
            listIterator.remove();
        }
        this.lastDividerUpdate = 0;
    }

    private void initializeDividerEventHandlers(ContentDivider contentDivider) {
        contentDivider.addEventHandler(MouseEvent.ANY, mouseEvent -> mouseEvent.consume());
        contentDivider.setOnMousePressed(mouseEvent -> {
            if (this.horizontal) {
                contentDivider.setInitialPos(contentDivider.getDividerPos());
                contentDivider.setPressPos(mouseEvent.getSceneX());
                contentDivider.setPressPos(((SplitPane)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? ((SplitPane)this.getSkinnable()).getWidth() - mouseEvent.getSceneX() : mouseEvent.getSceneX());
            } else {
                contentDivider.setInitialPos(contentDivider.getDividerPos());
                contentDivider.setPressPos(mouseEvent.getSceneY());
            }
            mouseEvent.consume();
        });
        contentDivider.setOnMouseDragged(mouseEvent -> {
            double d2 = 0.0;
            d2 = this.horizontal ? (((SplitPane)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? ((SplitPane)this.getSkinnable()).getWidth() - mouseEvent.getSceneX() : mouseEvent.getSceneX()) : mouseEvent.getSceneY();
            this.setAndCheckAbsoluteDividerPos(contentDivider, Math.ceil(contentDivider.getInitialPos() + (d2 -= contentDivider.getPressPos())));
            mouseEvent.consume();
        });
    }

    private Content getLeft(ContentDivider contentDivider) {
        int n2 = this.contentDividers.indexOf(contentDivider);
        if (n2 != -1) {
            return (Content)this.contentRegions.get(n2);
        }
        return null;
    }

    private Content getRight(ContentDivider contentDivider) {
        int n2 = this.contentDividers.indexOf(contentDivider);
        if (n2 != -1) {
            return (Content)this.contentRegions.get(n2 + 1);
        }
        return null;
    }

    private void setAbsoluteDividerPos(ContentDivider contentDivider, double d2) {
        if (((SplitPane)this.getSkinnable()).getWidth() > 0.0 && ((SplitPane)this.getSkinnable()).getHeight() > 0.0 && contentDivider != null) {
            SplitPane.Divider divider = contentDivider.getDivider();
            contentDivider.setDividerPos(d2);
            double d3 = this.getSize();
            if (d3 != 0.0) {
                double d4 = d2 + contentDivider.prefWidth(-1.0) / 2.0;
                divider.setPosition(d4 / d3);
            } else {
                divider.setPosition(0.0);
            }
        }
    }

    private double getAbsoluteDividerPos(ContentDivider contentDivider) {
        if (((SplitPane)this.getSkinnable()).getWidth() > 0.0 && ((SplitPane)this.getSkinnable()).getHeight() > 0.0 && contentDivider != null) {
            SplitPane.Divider divider = contentDivider.getDivider();
            double d2 = this.posToDividerPos(contentDivider, divider.getPosition());
            contentDivider.setDividerPos(d2);
            return d2;
        }
        return 0.0;
    }

    private double posToDividerPos(ContentDivider contentDivider, double d2) {
        double d3 = this.getSize() * d2;
        d3 = d2 == 1.0 ? (d3 -= contentDivider.prefWidth(-1.0)) : (d3 -= contentDivider.prefWidth(-1.0) / 2.0);
        return Math.round(d3);
    }

    private double totalMinSize() {
        double d2 = !this.contentDividers.isEmpty() ? (double)this.contentDividers.size() * ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0) : 0.0;
        double d3 = 0.0;
        for (Content content : this.contentRegions) {
            if (this.horizontal) {
                d3 += content.minWidth(-1.0);
                continue;
            }
            d3 += content.minHeight(-1.0);
        }
        return d3 + d2;
    }

    private double getSize() {
        SplitPane splitPane = (SplitPane)this.getSkinnable();
        double d2 = this.totalMinSize();
        if (this.horizontal) {
            if (splitPane.getWidth() > d2) {
                d2 = splitPane.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
            }
        } else if (splitPane.getHeight() > d2) {
            d2 = splitPane.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        }
        return d2;
    }

    private double distributeTo(List<Content> list, double d2) {
        if (list.isEmpty()) {
            return d2;
        }
        d2 = this.horizontal ? this.snapSizeX(d2) : this.snapSizeY(d2);
        int n2 = (int)d2 / list.size();
        while (d2 > 0.0 && !list.isEmpty()) {
            Iterator<Content> iterator = list.iterator();
            while (iterator.hasNext()) {
                double d3;
                Content content = iterator.next();
                double d4 = Math.min(this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0), Double.MAX_VALUE);
                double d5 = d3 = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                if (content.getArea() >= d4) {
                    content.setAvailable(content.getArea() - d3);
                    iterator.remove();
                    continue;
                }
                if ((double)n2 >= d4 - content.getArea()) {
                    d2 -= d4 - content.getArea();
                    content.setArea(d4);
                    content.setAvailable(d4 - d3);
                    iterator.remove();
                } else {
                    content.setArea(content.getArea() + (double)n2);
                    content.setAvailable(content.getArea() - d3);
                    d2 -= (double)n2;
                }
                if ((int)d2 != 0) continue;
                return d2;
            }
            if (list.isEmpty()) {
                return d2;
            }
            n2 = (int)d2 / list.size();
            int n3 = (int)d2 % list.size();
            if (n2 != 0 || n3 == 0) continue;
            n2 = n3;
            n3 = 0;
        }
        return d2;
    }

    private double distributeFrom(double d2, List<Content> list) {
        if (list.isEmpty()) {
            return d2;
        }
        d2 = this.horizontal ? this.snapSizeX(d2) : this.snapSizeY(d2);
        int n2 = (int)d2 / list.size();
        while (d2 > 0.0 && !list.isEmpty()) {
            Iterator<Content> iterator = list.iterator();
            while (iterator.hasNext()) {
                Content content = iterator.next();
                if ((double)n2 >= content.getAvailable()) {
                    content.setArea(content.getArea() - content.getAvailable());
                    d2 -= content.getAvailable();
                    content.setAvailable(0.0);
                    iterator.remove();
                } else {
                    content.setArea(content.getArea() - (double)n2);
                    content.setAvailable(content.getAvailable() - (double)n2);
                    d2 -= (double)n2;
                }
                if ((int)d2 != 0) continue;
                return d2;
            }
            if (list.isEmpty()) {
                return d2;
            }
            n2 = (int)d2 / list.size();
            int n3 = (int)d2 % list.size();
            if (n2 != 0 || n3 == 0) continue;
            n2 = n3;
            n3 = 0;
        }
        return d2;
    }

    private void setupContentAndDividerForLayout() {
        double d2 = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        double d3 = 0.0;
        double d4 = 0.0;
        for (Content stackPane : this.contentRegions) {
            if (this.resize && !stackPane.isResizableWithParent()) {
                stackPane.setArea(stackPane.getResizableWithParentArea());
            }
            stackPane.setX(d3);
            stackPane.setY(d4);
            if (this.horizontal) {
                d3 += stackPane.getArea() + d2;
                continue;
            }
            d4 += stackPane.getArea() + d2;
        }
        d3 = 0.0;
        d4 = 0.0;
        this.checkDividerPos = false;
        for (int i2 = 0; i2 < this.contentDividers.size(); ++i2) {
            ContentDivider contentDivider = (ContentDivider)this.contentDividers.get(i2);
            if (this.horizontal) {
                d3 += this.getLeft(contentDivider).getArea() + (i2 == 0 ? 0.0 : d2);
            } else {
                d4 += this.getLeft(contentDivider).getArea() + (i2 == 0 ? 0.0 : d2);
            }
            contentDivider.setX(d3);
            contentDivider.setY(d4);
            this.setAbsoluteDividerPos(contentDivider, this.horizontal ? contentDivider.getX() : contentDivider.getY());
            contentDivider.posExplicit = false;
        }
        this.checkDividerPos = true;
    }

    private void layoutDividersAndContent(double d2, double d3) {
        double d4 = this.snappedLeftInset();
        double d5 = this.snappedTopInset();
        double d6 = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        for (Content stackPane : this.contentRegions) {
            if (this.horizontal) {
                stackPane.setClipSize(stackPane.getArea(), d3);
                this.layoutInArea(stackPane, stackPane.getX() + d4, stackPane.getY() + d5, stackPane.getArea(), d3, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            stackPane.setClipSize(d2, stackPane.getArea());
            this.layoutInArea(stackPane, stackPane.getX() + d4, stackPane.getY() + d5, d2, stackPane.getArea(), 0.0, HPos.CENTER, VPos.CENTER);
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            if (this.horizontal) {
                contentDivider.resize(d6, d3);
                this.positionInArea(contentDivider, contentDivider.getX() + d4, contentDivider.getY() + d5, d6, d3, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            contentDivider.resize(d2, d6);
            this.positionInArea(contentDivider, contentDivider.getX() + d4, contentDivider.getY() + d5, d2, d6, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    private void setAndCheckAbsoluteDividerPos(ContentDivider contentDivider, double d2) {
        double d3 = contentDivider.getDividerPos();
        this.setAbsoluteDividerPos(contentDivider, d2);
        this.checkDividerPosition(contentDivider, d2, d3);
    }

    class ContentDivider
    extends StackPane {
        private double initialPos;
        private double dividerPos;
        private double pressPos;
        private SplitPane.Divider d;
        private StackPane grabber;
        private double x;
        private double y;
        private boolean posExplicit;
        private ChangeListener<Number> listener;

        public ContentDivider(SplitPane.Divider divider) {
            this.getStyleClass().setAll((String[])new String[]{"split-pane-divider"});
            this.d = divider;
            this.initialPos = 0.0;
            this.dividerPos = 0.0;
            this.pressPos = 0.0;
            this.grabber = new StackPane(){

                @Override
                protected double computeMinWidth(double d2) {
                    return 0.0;
                }

                @Override
                protected double computeMinHeight(double d2) {
                    return 0.0;
                }

                @Override
                protected double computePrefWidth(double d2) {
                    return this.snappedLeftInset() + this.snappedRightInset();
                }

                @Override
                protected double computePrefHeight(double d2) {
                    return this.snappedTopInset() + this.snappedBottomInset();
                }

                @Override
                protected double computeMaxWidth(double d2) {
                    return this.computePrefWidth(-1.0);
                }

                @Override
                protected double computeMaxHeight(double d2) {
                    return this.computePrefHeight(-1.0);
                }
            };
            this.setGrabberStyle(SplitPaneSkin.this.horizontal);
            this.getChildren().add(this.grabber);
        }

        public SplitPane.Divider getDivider() {
            return this.d;
        }

        public final void setGrabberStyle(boolean bl2) {
            this.grabber.getStyleClass().clear();
            this.grabber.getStyleClass().setAll((String[])new String[]{"vertical-grabber"});
            this.setCursor(Cursor.V_RESIZE);
            if (bl2) {
                this.grabber.getStyleClass().setAll((String[])new String[]{"horizontal-grabber"});
                this.setCursor(Cursor.H_RESIZE);
            }
        }

        public double getInitialPos() {
            return this.initialPos;
        }

        public void setInitialPos(double d2) {
            this.initialPos = d2;
        }

        public double getDividerPos() {
            return this.dividerPos;
        }

        public void setDividerPos(double d2) {
            this.dividerPos = d2;
        }

        public double getPressPos() {
            return this.pressPos;
        }

        public void setPressPos(double d2) {
            this.pressPos = d2;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d2) {
            this.x = d2;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d2) {
            this.y = d2;
        }

        public ChangeListener<Number> getPosPropertyListener() {
            return this.listener;
        }

        public void setPosPropertyListener(ChangeListener<Number> changeListener) {
            this.listener = changeListener;
        }

        @Override
        protected double computeMinWidth(double d2) {
            return this.computePrefWidth(d2);
        }

        @Override
        protected double computeMinHeight(double d2) {
            return this.computePrefHeight(d2);
        }

        @Override
        protected double computePrefWidth(double d2) {
            return this.snappedLeftInset() + this.snappedRightInset();
        }

        @Override
        protected double computePrefHeight(double d2) {
            return this.snappedTopInset() + this.snappedBottomInset();
        }

        @Override
        protected double computeMaxWidth(double d2) {
            return this.computePrefWidth(d2);
        }

        @Override
        protected double computeMaxHeight(double d2) {
            return this.computePrefHeight(d2);
        }

        @Override
        protected void layoutChildren() {
            double d2 = this.grabber.prefWidth(-1.0);
            double d3 = this.grabber.prefHeight(-1.0);
            double d4 = (this.getWidth() - d2) / 2.0;
            double d5 = (this.getHeight() - d3) / 2.0;
            this.grabber.resize(d2, d3);
            this.positionInArea(this.grabber, d4, d5, d2, d3, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    static class Content
    extends StackPane {
        private Node content;
        private Rectangle clipRect = new Rectangle();
        private double x;
        private double y;
        private double area;
        private double resizableWithParentArea;
        private double available;

        public Content(Node node) {
            this.setClip(this.clipRect);
            this.content = node;
            if (node != null) {
                this.getChildren().add(node);
            }
            this.x = 0.0;
            this.y = 0.0;
        }

        public Node getContent() {
            return this.content;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d2) {
            this.x = d2;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d2) {
            this.y = d2;
        }

        public double getArea() {
            return this.area;
        }

        public void setArea(double d2) {
            this.area = d2;
        }

        public double getAvailable() {
            return this.available;
        }

        public void setAvailable(double d2) {
            this.available = d2;
        }

        public boolean isResizableWithParent() {
            return SplitPane.isResizableWithParent(this.content);
        }

        public double getResizableWithParentArea() {
            return this.resizableWithParentArea;
        }

        public void setResizableWithParentArea(double d2) {
            this.resizableWithParentArea = !this.isResizableWithParent() ? d2 : 0.0;
        }

        protected void setClipSize(double d2, double d3) {
            this.clipRect.setWidth(d2);
            this.clipRect.setHeight(d3);
        }

        private void dispose() {
            this.getChildren().remove(this.content);
        }

        @Override
        protected double computeMaxWidth(double d2) {
            return this.snapSizeX(this.content.maxWidth(d2));
        }

        @Override
        protected double computeMaxHeight(double d2) {
            return this.snapSizeY(this.content.maxHeight(d2));
        }
    }

    class PosPropertyListener
    implements ChangeListener<Number> {
        ContentDivider divider;

        public PosPropertyListener(ContentDivider contentDivider) {
            this.divider = contentDivider;
        }

        @Override
        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            if (SplitPaneSkin.this.checkDividerPos) {
                this.divider.posExplicit = true;
            }
            if (!SplitPaneSkin.this.duringLayout) {
                ((SplitPane)SplitPaneSkin.this.getSkinnable()).requestLayout();
            }
        }
    }
}

