/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.css.PseudoClass;
import javafx.scene.control.Cell;

public class IndexedCell<T>
extends Cell<T> {
    private int oldIndex = -1;
    private ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper(this, "index", -1){

        @Override
        protected void invalidated() {
            int n2 = this.get();
            boolean bl2 = n2 % 2 == 0;
            IndexedCell.this.pseudoClassStateChanged(PSEUDO_CLASS_EVEN, bl2);
            IndexedCell.this.pseudoClassStateChanged(PSEUDO_CLASS_ODD, !bl2);
            IndexedCell.this.indexChanged(IndexedCell.this.oldIndex, n2);
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "indexed-cell";
    private static final PseudoClass PSEUDO_CLASS_ODD = PseudoClass.getPseudoClass("odd");
    private static final PseudoClass PSEUDO_CLASS_EVEN = PseudoClass.getPseudoClass("even");

    public IndexedCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final int getIndex() {
        return this.index.get();
    }

    public final ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    public void updateIndex(int n2) {
        this.oldIndex = this.index.get();
        if (this.oldIndex == n2) {
            this.indexChanged(this.oldIndex, n2);
        } else {
            this.index.set(n2);
        }
    }

    void indexChanged(int n2, int n3) {
    }
}

