/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.builder.api;

import com.fasterxml.jackson.annotation.JsonValue;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.BuildingException;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.EntityBuilder;
import java.util.Collection;
import java.util.List;
import org.geojson.GeoJsonObject;

public abstract class AbstractFeatureOfInterestBuilder<U extends AbstractFeatureOfInterestBuilder<U>>
extends EntityBuilder<FeatureOfInterest, U> {
    @Override
    protected FeatureOfInterest newBuildingInstance() {
        return new FeatureOfInterest();
    }

    public U name(String name) {
        ((FeatureOfInterest)this.getBuildingInstance()).setName(name);
        return (U)((AbstractFeatureOfInterestBuilder)this.getSelf());
    }

    public U description(String description) {
        ((FeatureOfInterest)this.getBuildingInstance()).setDescription(description);
        return (U)((AbstractFeatureOfInterestBuilder)this.getSelf());
    }

    public U encodingType(ValueCode encodingType) {
        ((FeatureOfInterest)this.getBuildingInstance()).setEncodingType(encodingType.getValue());
        return (U)((AbstractFeatureOfInterestBuilder)this.getSelf());
    }

    public U feature(Object feature) {
        if (!(feature instanceof GeoJsonObject)) {
            throw new BuildingException("Whereas the OGC SensorThings API specifies the FeatureOfInterest#feature as an Any type (so any Object can be used), the FROST-Client only accepts GeoJSONObject type");
        }
        ((FeatureOfInterest)this.getBuildingInstance()).setFeature((GeoJsonObject)feature);
        return (U)((AbstractFeatureOfInterestBuilder)this.getSelf());
    }

    public U observations(List<Observation> observations) {
        ((FeatureOfInterest)this.getBuildingInstance()).getObservations().addAll((Collection<Observation>)observations);
        return (U)((AbstractFeatureOfInterestBuilder)this.getSelf());
    }

    public U observation(Observation observation) {
        ((FeatureOfInterest)this.getBuildingInstance()).getObservations().add(observation);
        return (U)((AbstractFeatureOfInterestBuilder)this.getSelf());
    }

    public static enum ValueCode {
        GeoJSON("application/vnd.geo+json");

        private final String value;

        private ValueCode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

