/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.NotFoundException;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.FeatureOfInterest;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.TimeObject;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public class Observation
extends Entity<Observation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Observation.class);
    private TimeObject phenomenonTime;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private Object result;
    private ZonedDateTime resultTime;
    private Object resultQuality;
    private Interval validTime;
    private Map<String, Object> parameters;
    @JsonProperty(value="Datastream")
    private Datastream datastream;
    @JsonProperty(value="MultiDatastream")
    private MultiDatastream multiDatastream;
    @JsonProperty(value="FeatureOfInterest")
    private FeatureOfInterest featureOfInterest;
    @JsonIgnore
    private boolean resultSet = false;

    public Observation() {
        super(EntityType.OBSERVATION);
    }

    public Observation(Object result, Datastream datastream) {
        this();
        this.result = result;
        this.datastream = datastream;
        this.resultSet = true;
    }

    public Observation(Object result, MultiDatastream multiDatastream) {
        this();
        this.result = result;
        this.multiDatastream = multiDatastream;
        this.resultSet = true;
    }

    public Observation(Object result, ZonedDateTime phenomenonTime) {
        this();
        this.result = result;
        this.phenomenonTime = new TimeObject(phenomenonTime);
        this.resultSet = true;
    }

    public Observation(Object result, Interval phenomenonTime) {
        this();
        this.result = result;
        this.phenomenonTime = new TimeObject(phenomenonTime);
        this.resultSet = true;
    }

    @Override
    protected void ensureServiceOnChildren(SensorThingsService service) {
        if (this.datastream != null) {
            this.datastream.setService(service);
        }
        if (this.multiDatastream != null) {
            this.multiDatastream.setService(service);
        }
        if (this.featureOfInterest != null) {
            this.featureOfInterest.setService(service);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Observation other = (Observation)obj;
        if (!Objects.equals(this.phenomenonTime, other.phenomenonTime)) {
            return false;
        }
        if (!Objects.equals(this.result, other.result)) {
            return false;
        }
        if (!Objects.equals(this.resultTime, other.resultTime)) {
            return false;
        }
        if (!Objects.equals(this.resultQuality, other.resultQuality)) {
            return false;
        }
        if (!Objects.equals(this.validTime, other.validTime)) {
            return false;
        }
        if (!Objects.equals(this.parameters, other.parameters)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + Objects.hashCode(this.phenomenonTime);
        hash = 89 * hash + Objects.hashCode(this.result);
        hash = 89 * hash + Objects.hashCode(this.resultTime);
        hash = 89 * hash + Objects.hashCode(this.resultQuality);
        hash = 89 * hash + Objects.hashCode(this.validTime);
        hash = 89 * hash + Objects.hashCode(this.parameters);
        return hash;
    }

    public TimeObject getPhenomenonTime() {
        return this.phenomenonTime;
    }

    @JsonIgnore
    public void setPhenomenonTimeFrom(ZonedDateTime phenomenonTime) {
        this.phenomenonTime = new TimeObject(phenomenonTime);
    }

    @JsonIgnore
    public void setPhenomenonTimeFrom(Interval phenomenonTime) {
        this.phenomenonTime = new TimeObject(phenomenonTime);
    }

    public void setPhenomenonTime(TimeObject phenomenonTime) {
        this.phenomenonTime = phenomenonTime;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
        this.resultSet = true;
    }

    @JsonIgnore
    public boolean isResultSet() {
        return this.resultSet;
    }

    public ZonedDateTime getResultTime() {
        return this.resultTime;
    }

    public void setResultTime(ZonedDateTime resultTime) {
        this.resultTime = resultTime;
    }

    public Object getResultQuality() {
        return this.resultQuality;
    }

    public void setResultQuality(Object resultQuality) {
        this.resultQuality = resultQuality;
    }

    public Interval getValidTime() {
        return this.validTime;
    }

    public void setValidTime(Interval validTime) {
        this.validTime = validTime;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Datastream getDatastream() throws ServiceFailureException {
        if (this.datastream == null && this.getService() != null) {
            try {
                this.datastream = (Datastream)this.getService().datastreams().find(this);
            }
            catch (NotFoundException ex2) {
                LOGGER.trace("Observation has no Datastream.", ex2);
            }
            catch (Exception ex3) {
                LOGGER.trace("Could not find Datastream for Observation", ex3);
            }
        }
        return this.datastream;
    }

    public void setDatastream(Datastream datastream) {
        this.datastream = datastream;
    }

    public MultiDatastream getMultiDatastream() throws ServiceFailureException {
        if (this.multiDatastream == null && this.getService() != null) {
            try {
                this.multiDatastream = (MultiDatastream)this.getService().multiDatastreams().find(this);
            }
            catch (NotFoundException ex2) {
                LOGGER.trace("Observation has no MultiDatastream.", ex2);
            }
            catch (Exception ex3) {
                LOGGER.trace("Could not find MultiDatastream for Observation", ex3);
            }
        }
        return this.multiDatastream;
    }

    public void setMultiDatastream(MultiDatastream multiDatastream) {
        this.multiDatastream = multiDatastream;
    }

    public FeatureOfInterest getFeatureOfInterest() throws ServiceFailureException {
        if (this.featureOfInterest == null && this.getService() != null) {
            try {
                this.featureOfInterest = (FeatureOfInterest)this.getService().featuresOfInterest().find(this);
            }
            catch (NotFoundException ex2) {
                LOGGER.trace("Observation has no FeatureOfInterest.", ex2);
            }
            catch (Exception ex3) {
                LOGGER.trace("Could not find FeatureOfInterest for Observation", ex3);
            }
        }
        return this.featureOfInterest;
    }

    public void setFeatureOfInterest(FeatureOfInterest featureOfInterest) {
        this.featureOfInterest = featureOfInterest;
    }

    @Override
    public BaseDao<Observation> getDao(SensorThingsService service) {
        return new ObservationDao(service);
    }

    @Override
    public Observation withOnlyId() {
        Observation copy = new Observation();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getPhenomenonTime() + " " + this.getResult();
    }
}

