/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.HistoricalLocationDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class HistoricalLocation
extends Entity<HistoricalLocation> {
    private ZonedDateTime time;
    private final EntityList<Location> locations = new EntityList(EntityType.LOCATIONS);
    @JsonProperty(value="Thing")
    private Thing thing;

    public HistoricalLocation() {
        super(EntityType.HISTORICAL_LOCATION);
    }

    public HistoricalLocation(ZonedDateTime time) {
        this();
        this.time = time;
    }

    @Override
    protected void ensureServiceOnChildren(SensorThingsService service) {
        if (this.thing != null) {
            this.thing.setService(service);
        }
        this.locations.setService(service, Location.class);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoricalLocation other = (HistoricalLocation)obj;
        if (!Objects.equals(this.time, other.time)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 53 * hash + Objects.hashCode(this.time);
        return hash;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public void setTime(ZonedDateTime time) {
        this.time = time;
    }

    public BaseDao<Location> locations() {
        return this.getService().locations().setParent(this);
    }

    @JsonProperty(value="Locations")
    public EntityList<Location> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="Locations")
    public void setLocations(List<Location> locations) {
        this.locations.replaceAll(locations);
    }

    public Thing getThing() throws ServiceFailureException {
        if (this.thing == null && this.getService() != null) {
            this.thing = (Thing)this.getService().things().find(this);
        }
        return this.thing;
    }

    public void setThing(Thing thing) {
        this.thing = thing;
    }

    @Override
    public BaseDao<HistoricalLocation> getDao(SensorThingsService service) {
        return new HistoricalLocationDao(service);
    }

    @Override
    public HistoricalLocation withOnlyId() {
        HistoricalLocation copy = new HistoricalLocation();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.time.toString();
    }
}

