/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorHelper.class);
    private static final long SHUTDOWN_WAIT_STEP_IN_MILLIS = 100L;

    private ProcessorHelper() {
    }

    public static <T> ExecutorService createProcessors(int threadCount, BlockingQueue<T> queue, Consumer<T> consumer, String name) {
        return ProcessorHelper.createProcessors(threadCount, queue, consumer, name, new ArrayList<Processor<T>>());
    }

    public static <T> ExecutorService createProcessors(int threadCount, BlockingQueue<T> queue, Consumer<T> consumer, String name, List<Processor<T>> processorList) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name + "-%d").build();
        ExecutorService result = Executors.newFixedThreadPool(threadCount, factory);
        for (int i2 = 0; i2 < threadCount; ++i2) {
            Processor<T> processor = new Processor<T>(queue, consumer, name);
            processorList.add(processor);
            result.submit(processor);
        }
        return result;
    }

    public static void shutdownProcessors(ExecutorService executorService, BlockingQueue<?> queue, long timeout, TimeUnit timeUnit) {
        if (executorService != null) {
            executorService.shutdown();
            try {
                for (long timeoutInMillis = timeUnit.toMillis(timeout); queue != null && !queue.isEmpty() && timeoutInMillis > 0L; timeoutInMillis -= 100L) {
                    Thread.sleep(100L);
                }
                executorService.shutdownNow();
                if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.debug("executoreService did not terminate in time");
                }
            }
            catch (InterruptedException ie2) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class Processor<T>
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class);
        private final BlockingQueue<T> queue;
        private final Consumer<T> consumer;
        private final String name;
        private Status status = Status.STOPPED;
        private Instant workStarted;

        private Processor(BlockingQueue<T> queue, Consumer<T> consumer, String name) {
            if (queue == null) {
                throw new IllegalArgumentException("queue must be non-null");
            }
            if (consumer == null) {
                throw new IllegalArgumentException("handler must be non-null");
            }
            this.name = name == null || name.isEmpty() ? this.getClass().getName() : name;
            this.queue = queue;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            LOGGER.debug("starting {}-Thread", (Object)this.name);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.status = Status.WAITING;
                    T event = this.queue.take();
                    this.status = Status.WORKING;
                    this.workStarted = Instant.now();
                    this.consumer.accept(event);
                }
                catch (InterruptedException ex2) {
                    LOGGER.trace("{} interrupted", (Object)this.name, (Object)ex2);
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception ex3) {
                    LOGGER.warn("Exception while executing {}", (Object)this.name, (Object)ex3);
                }
            }
            LOGGER.debug("exiting {}-Thread", (Object)this.name);
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isFine(Instant threshold) {
            if (this.status != Status.WORKING) {
                return true;
            }
            return this.workStarted.isAfter(threshold);
        }

        public static enum Status {
            STOPPED,
            WAITING,
            WORKING;

        }
    }
}

