/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.StringWriter;
import org.slf4j.Logger;

public class LiquibaseUtils {
    private LiquibaseUtils() {
    }

    public static boolean maybeUpdateDatabase(Logger logger, LiquibaseUser user) {
        boolean retry = false;
        StringWriter updateLog = new StringWriter();
        try {
            logger.info("Running database update for {}", (Object)user.getClass().getName());
            boolean success = user.doUpgrades(updateLog);
            boolean bl2 = retry = !success;
            if (success) {
                logger.info("Database-update successful.");
            } else {
                logger.info("Database-update not successful, trying again later.");
            }
        }
        catch (UpgradeFailedException ex2) {
            logger.error("Database upgrade failed.", ex2);
            retry = false;
        }
        catch (IOException ex3) {
            logger.error("Database upgrade failed.", ex3);
        }
        String logString = updateLog.toString();
        if (!logString.isEmpty()) {
            logger.info("Database-update-log:\n{}", (Object)logString);
        }
        return retry;
    }
}

