/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigUtils;
import de.fraunhofer.iosb.ilt.frostserver.settings.PropertyMissingException;
import de.fraunhofer.iosb.ilt.frostserver.settings.PropertyTypeException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    private static final String NOT_SET_USING_DEFAULT_VALUE = "Not set {}{}, using default value '{}'.";
    private static final String NOT_SET_NO_DEFAULT_VALUE = "Not set {}, and no default value!";
    private static final String ERROR_GETTING_SETTINGS_VALUE = "error getting settings value";
    private static final String SETTING_HAS_VALUE = "Setting {}{} has value '{}'.";
    private static final String HIDDEN_VALUE = "*****";
    private final Properties properties;
    private boolean logSensitiveData;
    private String prefix;

    private static Properties addEnvironment(Properties wrapped) {
        Map<String, String> environment = System.getenv();
        Properties wrapper = new Properties(wrapped);
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            String key = entry.getKey().replace("_", ".");
            LOGGER.debug("Added environment variable: {}", (Object)key);
            wrapper.setProperty(key, entry.getValue());
        }
        return wrapper;
    }

    public Settings() {
        this(new Properties(), "", true, false);
    }

    public Settings(String prefix) {
        this(new Properties(), prefix, true, false);
    }

    public Settings(Properties properties) {
        this(properties, "", true, false);
    }

    public Settings(Properties properties, String prefix, boolean wrapInEnvironment, boolean logSensitiveData) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must be non-null");
        }
        this.properties = wrapInEnvironment ? Settings.addEnvironment(properties) : properties;
        this.prefix = prefix == null ? "" : prefix;
        this.logSensitiveData = logSensitiveData;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean getLogSensitiveData() {
        return this.logSensitiveData;
    }

    public void setLogSensitiveData(boolean logSensitiveData) {
        this.logSensitiveData = logSensitiveData;
    }

    private String getPropertyKey(String propertyName) {
        return this.prefix + propertyName.replace("_", ".");
    }

    public boolean containsName(String name) {
        String val = this.properties.getProperty(this.getPropertyKey(name));
        return val != null;
    }

    private void checkExists(String key) {
        if (this.properties.getProperty(key) != null) {
            return;
        }
        LOGGER.error(NOT_SET_NO_DEFAULT_VALUE, (Object)key);
        throw new PropertyMissingException(key);
    }

    public void set(String name, String value) {
        this.properties.put(this.getPropertyKey(name), value);
    }

    public void set(String name, boolean value) {
        this.properties.put(this.getPropertyKey(name), Boolean.toString(value));
    }

    public String get(String name) {
        return this.get(name, true);
    }

    public String get(String name, boolean nonSensitiveValue) {
        String key = this.getPropertyKey(name);
        this.checkExists(key);
        String value = this.properties.getProperty(key);
        this.logHasValue(nonSensitiveValue, name, value);
        return value;
    }

    public String get(String name, String defaultValue) {
        return this.get(name, defaultValue, true);
    }

    public String get(String name, String defaultValue, boolean nonSensitiveValue) {
        String key = this.getPropertyKey(name);
        String value = this.properties.getProperty(key);
        if (value == null) {
            this.logDefaultValue(nonSensitiveValue, name, defaultValue);
            return defaultValue;
        }
        this.logHasValue(nonSensitiveValue, name, value);
        return value;
    }

    public String get(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        return this.get(name, defaultsProvider, true);
    }

    public String get(String name, Class<? extends ConfigDefaults> defaultsProvider, boolean nonSensitiveValue) {
        String key = this.getPropertyKey(name);
        String value = this.properties.getProperty(key);
        if (value == null) {
            String defaultValue = ConfigUtils.getDefaultValue(defaultsProvider, name);
            this.logDefaultValue(nonSensitiveValue, name, defaultValue);
            return defaultValue;
        }
        this.logHasValue(nonSensitiveValue, name, value);
        return value;
    }

    public int getInt(String name) {
        try {
            return Integer.parseInt(this.get(name));
        }
        catch (NumberFormatException ex2) {
            throw new PropertyTypeException(name, Integer.class, ex2);
        }
    }

    public int getInt(String name, int defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getInt(name);
            }
            catch (Exception ex2) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex2);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public int getInt(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.containsName(name)) {
            try {
                return this.getInt(name);
            }
            catch (Exception ex2) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex2);
            }
        }
        int defaultValue = ConfigUtils.getDefaultValueInt(defaultsProvider, name);
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public long getLong(String name) {
        try {
            return Long.parseLong(this.get(name));
        }
        catch (NumberFormatException ex2) {
            throw new PropertyTypeException(name, Long.class, ex2);
        }
    }

    public long getLong(String name, long defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getLong(name);
            }
            catch (Exception ex2) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex2);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public long getLong(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.containsName(name)) {
            try {
                return this.getLong(name);
            }
            catch (Exception ex2) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex2);
            }
        }
        int defaultValue = ConfigUtils.getDefaultValueInt(defaultsProvider, name);
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public double getDouble(String name) {
        try {
            return Double.parseDouble(this.get(name));
        }
        catch (NumberFormatException ex2) {
            throw new PropertyTypeException(name, Double.class, ex2);
        }
    }

    public double getDouble(String name, double defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getDouble(name);
            }
            catch (Exception ex2) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex2);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public boolean getBoolean(String name) {
        try {
            return Boolean.valueOf(this.get(name));
        }
        catch (PropertyMissingException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new PropertyTypeException(name, Boolean.class, ex3);
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getBoolean(name);
            }
            catch (Exception ex2) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex2);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public boolean getBoolean(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.containsName(name)) {
            try {
                return this.getBoolean(name);
            }
            catch (Exception ex2) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex2);
            }
        }
        boolean defaultValue = ConfigUtils.getDefaultValueBoolean(defaultsProvider, name);
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    private void logHasValue(boolean nonSensitiveValue, String name, String value) {
        if (nonSensitiveValue || this.logSensitiveData) {
            LOGGER.info(SETTING_HAS_VALUE, this.prefix, name, value);
        } else {
            LOGGER.info(SETTING_HAS_VALUE, this.prefix, name, HIDDEN_VALUE);
        }
    }

    private void logDefaultValue(boolean nonSensitiveValue, String name, String defaultValue) {
        if (nonSensitiveValue || this.logSensitiveData) {
            LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        } else {
            LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, HIDDEN_VALUE);
        }
    }
}

