/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueInt;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String UNABLE_TO_ACCESS_FIELD_ON_OBJECT = "Unable to access field '{}' on object: {}.";

    private ConfigUtils() {
    }

    public static <T extends ConfigDefaults> Set<String> getConfigTags(Class<T> target) {
        HashSet<String> configTags = new HashSet<String>();
        for (Field f2 : target.getFields()) {
            try {
                if (!f2.isAnnotationPresent(DefaultValue.class) && !f2.isAnnotationPresent(DefaultValueInt.class) && !f2.isAnnotationPresent(DefaultValueBoolean.class)) continue;
                configTags.add(f2.get(target).toString());
            }
            catch (IllegalAccessException e2) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f2.getName(), (Object)target);
            }
        }
        return configTags;
    }

    public static <T extends ConfigDefaults> Map<String, String> getConfigDefaults(Class<T> target) {
        HashMap<String, String> configDefaults = new HashMap<String, String>();
        for (Field f2 : target.getFields()) {
            String defaultValue = null;
            if (f2.isAnnotationPresent(DefaultValue.class)) {
                defaultValue = f2.getAnnotation(DefaultValue.class).value();
            } else if (f2.isAnnotationPresent(DefaultValueInt.class)) {
                defaultValue = Integer.toString(f2.getAnnotation(DefaultValueInt.class).value());
            } else if (f2.isAnnotationPresent(DefaultValueBoolean.class)) {
                defaultValue = Boolean.toString(f2.getAnnotation(DefaultValueBoolean.class).value());
            }
            try {
                if (defaultValue == null) continue;
                String key = f2.get(target).toString();
                configDefaults.put(key, defaultValue);
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f2.getName(), (Object)target);
            }
        }
        return configDefaults;
    }

    public static <T extends ConfigDefaults> Map<String, Integer> getConfigDefaultsInt(Class<T> target) {
        HashMap<String, Integer> configDefaults = new HashMap<String, Integer>();
        List<Field> fields2 = FieldUtils.getFieldsListWithAnnotation(target, DefaultValueInt.class);
        for (Field f2 : fields2) {
            try {
                configDefaults.put(f2.get(target).toString(), f2.getAnnotation(DefaultValueInt.class).value());
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f2.getName(), (Object)target);
            }
        }
        return configDefaults;
    }

    public static <T extends ConfigDefaults> Map<String, Boolean> getConfigDefaultsBoolean(Class<T> target) {
        HashMap<String, Boolean> configDefaults = new HashMap<String, Boolean>();
        List<Field> fields2 = FieldUtils.getFieldsListWithAnnotation(target, DefaultValueBoolean.class);
        for (Field f2 : fields2) {
            try {
                configDefaults.put(f2.get(target).toString(), f2.getAnnotation(DefaultValueBoolean.class).value());
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f2.getName(), (Object)target);
            }
        }
        return configDefaults;
    }

    public static <T extends ConfigDefaults> String getDefaultValue(Class<T> target, String fieldValue) {
        for (Field f2 : target.getFields()) {
            try {
                if (!fieldValue.equals(f2.get(target).toString())) continue;
                if (f2.isAnnotationPresent(DefaultValue.class)) {
                    return f2.getAnnotation(DefaultValue.class).value();
                }
                if (f2.isAnnotationPresent(DefaultValueInt.class)) {
                    return Integer.toString(f2.getAnnotation(DefaultValueInt.class).value());
                }
                if (!f2.isAnnotationPresent(DefaultValueBoolean.class)) continue;
                return Boolean.toString(f2.getAnnotation(DefaultValueBoolean.class).value());
            }
            catch (IllegalAccessException e2) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f2.getName(), (Object)target);
            }
        }
        throw new IllegalArgumentException(target.getName() + " has no default-annotated field " + fieldValue);
    }

    public static <T extends ConfigDefaults> int getDefaultValueInt(Class<T> target, String fieldValue) {
        for (Field f2 : target.getFields()) {
            if (!f2.isAnnotationPresent(DefaultValueInt.class)) continue;
            try {
                if (!f2.get(target).toString().equals(fieldValue)) continue;
                return f2.getAnnotation(DefaultValueInt.class).value();
            }
            catch (IllegalAccessException e2) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f2.getName(), (Object)target);
            }
        }
        throw new IllegalArgumentException(target.getName() + " has no integer-default-annotated field " + fieldValue);
    }

    public static <T extends ConfigDefaults> boolean getDefaultValueBoolean(Class<T> target, String fieldValue) {
        for (Field f2 : target.getFields()) {
            if (!f2.isAnnotationPresent(DefaultValueBoolean.class)) continue;
            try {
                if (!f2.get(target).toString().equals(fieldValue)) continue;
                return f2.getAnnotation(DefaultValueBoolean.class).value();
            }
            catch (IllegalAccessException e2) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f2.getName(), (Object)target);
            }
        }
        throw new IllegalArgumentException(target.getName() + " has no boolean-default-annotated field " + fieldValue);
    }
}

