/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CachedSettings
extends Settings {
    private final Map<String, String> valuesString = new HashMap<String, String>();
    private final Map<String, Integer> valuesInt = new HashMap<String, Integer>();
    private final Map<String, Long> valuesLong = new HashMap<String, Long>();
    private final Map<String, Boolean> valuesBoolean = new HashMap<String, Boolean>();
    private final Map<String, Double> valuesDouble = new HashMap<String, Double>();

    public CachedSettings(String prefix) {
        super(prefix);
    }

    public CachedSettings(Properties properties) {
        super(properties);
    }

    public CachedSettings(Properties properties, String prefix, boolean wrapInEnvironment, boolean logSensitiveData) {
        super(properties, prefix, wrapInEnvironment, logSensitiveData);
    }

    @Override
    public String get(String name) {
        if (this.valuesString.containsKey(name)) {
            return this.valuesString.get(name);
        }
        String value = super.get(name);
        this.valuesString.put(name, value);
        return value;
    }

    @Override
    public String get(String name, String defaultValue) {
        if (this.valuesString.containsKey(name)) {
            return this.valuesString.get(name);
        }
        String value = super.get(name, defaultValue);
        this.valuesString.put(name, value);
        return value;
    }

    @Override
    public String get(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.valuesString.containsKey(name)) {
            return this.valuesString.get(name);
        }
        String value = super.get(name, defaultsProvider);
        this.valuesString.put(name, value);
        return value;
    }

    @Override
    public void set(String name, String value) {
        this.valuesString.put(name, value);
    }

    @Override
    public void set(String name, boolean value) {
        this.valuesBoolean.put(name, value);
    }

    @Override
    public boolean getBoolean(String name) {
        if (this.valuesBoolean.containsKey(name)) {
            return this.valuesBoolean.get(name);
        }
        boolean value = super.getBoolean(name);
        this.valuesBoolean.put(name, value);
        return value;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.valuesBoolean.containsKey(name)) {
            return this.valuesBoolean.get(name);
        }
        boolean value = super.getBoolean(name, defaultValue);
        this.valuesBoolean.put(name, value);
        return value;
    }

    @Override
    public boolean getBoolean(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.valuesBoolean.containsKey(name)) {
            return this.valuesBoolean.get(name);
        }
        boolean value = super.getBoolean(name, defaultsProvider);
        this.valuesBoolean.put(name, value);
        return value;
    }

    @Override
    public int getInt(String name) {
        if (this.valuesInt.containsKey(name)) {
            return this.valuesInt.get(name);
        }
        int value = super.getInt(name);
        this.valuesInt.put(name, value);
        return value;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        if (this.valuesInt.containsKey(name)) {
            return this.valuesInt.get(name);
        }
        int value = super.getInt(name, defaultValue);
        this.valuesInt.put(name, value);
        return value;
    }

    @Override
    public int getInt(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.valuesInt.containsKey(name)) {
            return this.valuesInt.get(name);
        }
        int value = super.getInt(name, defaultsProvider);
        this.valuesInt.put(name, value);
        return value;
    }

    @Override
    public long getLong(String name) {
        if (this.valuesLong.containsKey(name)) {
            return this.valuesLong.get(name);
        }
        long value = super.getLong(name);
        this.valuesLong.put(name, value);
        return value;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        if (this.valuesLong.containsKey(name)) {
            return this.valuesLong.get(name);
        }
        long value = super.getLong(name, defaultValue);
        this.valuesLong.put(name, value);
        return value;
    }

    @Override
    public long getLong(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.valuesLong.containsKey(name)) {
            return this.valuesLong.get(name);
        }
        long value = super.getLong(name, defaultsProvider);
        this.valuesLong.put(name, value);
        return value;
    }

    @Override
    public double getDouble(String name) {
        if (this.valuesDouble.containsKey(name)) {
            return this.valuesDouble.get(name);
        }
        double value = super.getDouble(name);
        this.valuesDouble.put(name, value);
        return value;
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        if (this.valuesDouble.containsKey(name)) {
            return this.valuesDouble.get(name);
        }
        double value = super.getDouble(name, defaultValue);
        this.valuesDouble.put(name, value);
        return value;
    }
}

