/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.InputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ServiceRequestBuilder {
    private Optional<String> requestType;
    private Optional<String> url;
    private Optional<String> urlPath;
    private Optional<String> urlQuery;
    private Optional<String> contentString;
    private Optional<InputStream> contentBinary;
    private Optional<String> contentType;
    private Optional<Map<String, List<String>>> parameterMap;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private final CoreSettings coreSettings;
    private final Version version;
    private Principal userPrincipal;

    public ServiceRequestBuilder(CoreSettings coreSettings, Version version) {
        this.coreSettings = coreSettings;
        this.version = version;
        this.requestType = Optional.empty();
        this.url = Optional.empty();
        this.urlPath = Optional.empty();
        this.urlQuery = Optional.empty();
        this.contentBinary = Optional.empty();
        this.contentType = Optional.empty();
        this.parameterMap = Optional.empty();
    }

    public ServiceRequestBuilder withUrl(String url) {
        this.url = Optional.ofNullable(url);
        return this;
    }

    public ServiceRequestBuilder withUrlPath(String urlPath) {
        this.urlPath = Optional.ofNullable(urlPath);
        return this;
    }

    public ServiceRequestBuilder withUrlQuery(String urlQuery) {
        this.urlQuery = Optional.ofNullable(urlQuery);
        return this;
    }

    public ServiceRequestBuilder withContent(InputStream content) {
        this.contentBinary = Optional.ofNullable(content);
        return this;
    }

    public ServiceRequestBuilder withContent(String content) {
        this.contentString = Optional.ofNullable(content);
        return this;
    }

    public ServiceRequestBuilder withContentType(String contentType) {
        this.contentType = Optional.ofNullable(contentType);
        return this;
    }

    public ServiceRequestBuilder withParameterMap(Map<String, List<String>> parameterMap) {
        this.parameterMap = Optional.ofNullable(parameterMap);
        return this;
    }

    public ServiceRequestBuilder withRequestType(String requestType) {
        this.requestType = Optional.of(requestType);
        return this;
    }

    public ServiceRequestBuilder withAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
        return this;
    }

    public ServiceRequestBuilder withUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
        return this;
    }

    public ServiceRequest build() {
        ServiceRequest result = new ServiceRequest();
        result.setVersion(this.version);
        result.setCoreSettings(this.coreSettings);
        if (this.url.isPresent()) {
            result.setUrl(this.url.get());
        }
        if (this.urlPath.isPresent()) {
            result.setUrlPath(this.urlPath.get());
        }
        if (this.urlQuery.isPresent()) {
            result.setUrlQuery(this.urlQuery.get());
        }
        if (this.contentBinary.isPresent()) {
            result.setContent(this.contentBinary.get());
        } else if (this.contentString.isPresent()) {
            result.setContent(this.contentString.get());
        }
        if (this.contentType.isPresent()) {
            result.setContentType(this.contentType.get());
        }
        if (this.parameterMap.isPresent()) {
            result.setParameterMap(this.parameterMap.get());
        }
        if (this.requestType.isPresent()) {
            result.setRequestType(this.requestType.get());
        }
        result.setAttributeMap(this.attributeMap);
        result.setUserPrincipal(this.userPrincipal);
        return result;
    }
}

