/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.fge.jsonpatch.JsonPatch;
import de.fraunhofer.iosb.ilt.frostserver.extensions.Extension;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.PathParser;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManagerFactory;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponseDefault;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.ForbiddenException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UnauthorizedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
implements AutoCloseable {
    public static final String KEY_SERVER_SETTINGS = "serverSettings";
    public static final String KEY_CONFORMANCE_LIST = "conformance";
    private static final Logger LOGGER = LoggerFactory.getLogger(Service.class);
    private static final String EXCEPTION = "Exception:";
    private static final String NOT_A_VALID_PATH = "Not a valid path";
    private static final String POST_ONLY_ALLOWED_TO_COLLECTIONS = "POST only allowed to Collections.";
    private static final String COULD_NOT_PARSE_JSON = "Could not parse json.";
    private static final String FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG = "Failed to handle request (details in debug): {}";
    private static final String FAILED_TO_UPDATE_ENTITY = "Failed to update entity.";
    private static final String NOTHING_FOUND_RESPONSE = "Nothing found.";
    private final CoreSettings settings;
    private final ModelRegistry modelRegistry;
    private PersistenceManager persistenceManager;
    private boolean transactionActive = false;

    public Service(CoreSettings settings) {
        this.settings = settings;
        this.modelRegistry = settings.getModelRegistry();
        PersistenceManagerFactory.init(settings);
    }

    public String getRequestType(HttpMethod method, Version version, String path, String contentType) {
        PluginService plugin = this.settings.getPluginManager().getServiceForPath(version, path);
        String requestType = null;
        if (plugin != null) {
            requestType = plugin.getRequestTypeFor(version, path, method, contentType);
        }
        if (requestType == null) {
            String cleanedPath = StringHelper.cleanForLogging(path);
            LOGGER.error("Unhandled request; Method {}, path {}", (Object)method, (Object)cleanedPath);
            throw new IllegalArgumentException("Unhandled request; Method " + method + ", path " + cleanedPath);
        }
        return requestType;
    }

    public ServiceResponse execute(ServiceRequest request, ServiceResponse response) {
        String requestType;
        if (response == null) {
            response = new ServiceResponseDefault();
        }
        switch (requestType = request.getRequestType()) {
            case "getCapabilities": {
                return this.executeGetCapabilities(request, response);
            }
            case "create": {
                return this.executePost(request, response);
            }
            case "read": {
                return this.executeGet(request, response);
            }
            case "delete": {
                return this.executeDelete(request, response);
            }
            case "updateAll": {
                return this.executePut(request, response);
            }
            case "updateChanged": {
                return this.executePatch(request, response, false);
            }
            case "updateChangeset": {
                return this.executePatch(request, response, true);
            }
        }
        PluginService plugin = this.settings.getPluginManager().getServiceForRequestType(request.getVersion(), requestType);
        if (plugin == null) {
            return Service.errorResponse(response, 500, "Illegal request type.");
        }
        return plugin.execute(this, request, response);
    }

    public Service startTransaction() {
        this.transactionActive = true;
        return this;
    }

    public Service commitTransaction() {
        this.transactionActive = false;
        this.getPm().commit();
        return this;
    }

    public Service rollbackTransaction() {
        this.transactionActive = false;
        this.getPm().rollback();
        return this;
    }

    @Override
    public void close() {
        this.transactionActive = false;
        if (this.persistenceManager != null) {
            this.persistenceManager.close();
        }
    }

    public void maybeCommitAndClose() {
        if (!this.transactionActive) {
            this.getPm().commitAndClose();
            this.persistenceManager = null;
        }
    }

    public void rollbackAndClose(PersistenceManager pm2) {
        if (pm2 != null) {
            pm2.rollbackAndClose();
        }
    }

    public void maybeRollbackAndClose() {
        if (!this.transactionActive) {
            this.getPm().rollbackAndClose();
            this.persistenceManager = null;
        }
    }

    public PersistenceManager getPm() {
        if (this.persistenceManager == null) {
            this.persistenceManager = PersistenceManagerFactory.getInstance(this.settings).create();
        }
        return this.persistenceManager;
    }

    public CoreSettings getSettings() {
        return this.settings;
    }

    private ServiceResponse executeGetCapabilities(ServiceRequest request, ServiceResponse response) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Set<Extension> enabledSettings = this.settings.getEnabledExtensions();
        Version version = request.getVersion();
        ArrayList<Map<String, String>> capList = new ArrayList<Map<String, String>>();
        result.put("value", capList);
        try {
            for (EntityType entityType : this.modelRegistry.getEntityTypes()) {
                URL collectionUri = URI.create(this.settings.getQueryDefaults().getServiceRootUrl() + "/" + version.urlPart + "/" + entityType.plural).normalize().toURL();
                capList.add(this.createCapability(entityType.plural, collectionUri));
            }
        }
        catch (MalformedURLException ex2) {
            LOGGER.error("Failed to build url.", ex2);
            return Service.errorResponse(response, 500, ex2.getMessage());
        }
        if (version == Version.V_1_1) {
            LinkedHashMap<String, Object> serverSettings = new LinkedHashMap<String, Object>();
            result.put(KEY_SERVER_SETTINGS, serverSettings);
            TreeSet<String> extensionList = new TreeSet<String>();
            serverSettings.put(KEY_CONFORMANCE_LIST, extensionList);
            for (Extension setting : enabledSettings) {
                if (!setting.isExposedFeature()) continue;
                extensionList.addAll(setting.getRequirements());
            }
            this.settings.getMqttSettings().fillServerSettings(serverSettings);
        }
        this.settings.getPluginManager().modifyServiceDocument(request, result);
        response.setCode(200);
        response.setResult(result);
        return this.formatResponse(request, response, result);
    }

    private ServiceResponse formatResponse(ServiceRequest request, ServiceResponse response, Object result) {
        ResultFormatter formatter;
        try {
            formatter = this.settings.getFormatter(request.getVersion(), "default");
        }
        catch (IncorrectRequestException ex2) {
            LOGGER.error("Formatter not available.", ex2);
            return Service.errorResponse(response, 500, "Failed to instantiate formatter");
        }
        return this.formatResponse(response, formatter, null, null, result);
    }

    private ServiceResponse formatResponse(ServiceResponse response, ResultFormatter formatter, Query query, ResourcePath path, Object result) {
        response.setContentType(formatter.getContentType());
        try {
            formatter.format(path, query, result, this.settings.getQueryDefaults().useAbsoluteNavigationLinks()).writeFormatted(response.getWriter());
        }
        catch (IOException ex2) {
            LOGGER.error("Formatter not available.", ex2);
            return Service.errorResponse(response, 500, "Failed to format");
        }
        return response;
    }

    private Map<String, String> createCapability(String name, URL url) {
        HashMap<String, String> val = new HashMap<String, String>();
        val.put("name", name);
        val.put("url", url.toString());
        return Collections.unmodifiableMap(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executeGet(ServiceRequest request, ServiceResponse response) {
        PersistenceManager pm2 = this.getPm();
        try {
            ServiceResponse serviceResponse = this.handleGet(pm2, request, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e2) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e2.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e3) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e3.getMessage());
            return serviceResponse;
        }
        catch (Exception e4) {
            LOGGER.error(FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG, (Object)e4.getMessage());
            LOGGER.debug(EXCEPTION, e4);
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Failed to execute query. See logs for details.");
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse handleGet(PersistenceManager pm2, ServiceRequest request, ServiceResponse response) {
        ResultFormatter formatter;
        Query query;
        ResourcePath path;
        Version version = request.getVersion();
        try {
            path = PathParser.parsePath(this.modelRegistry, this.settings.getQueryDefaults().getServiceRootUrl(), version, request.getUrlPath());
        }
        catch (IllegalArgumentException | IllegalStateException e2) {
            return Service.errorResponse(response, 404, "Not a valid path: " + e2.getMessage());
        }
        try {
            query = QueryParser.parseQuery(request.getUrlQuery(), this.settings, path).validate();
            formatter = this.settings.getFormatter(version, query.getFormat());
            formatter.preProcessRequest(path, query);
        }
        catch (IncorrectRequestException | IllegalArgumentException ex2) {
            return Service.errorResponse(response, 400, ex2.getMessage());
        }
        if (!pm2.validatePath(path)) {
            this.maybeCommitAndClose();
            return Service.errorResponse(response, version.getCannedResponse(Version.CannedResponseType.NOTHING_FOUND));
        }
        try {
            Object object = pm2.get(path, query);
            if (object == null) {
                if (path.isValue() || path.isEntityProperty()) {
                    ServiceResponse serviceResponse = Service.successResponse(response, 204, "No Content");
                    return serviceResponse;
                }
                ServiceResponse serviceResponse = Service.errorResponse(response, version.getCannedResponse(Version.CannedResponseType.NOTHING_FOUND));
                return serviceResponse;
            }
            response.setResult(object);
            response.setCode(200);
            ServiceResponse serviceResponse = this.formatResponse(response, formatter, query, path, object);
            return serviceResponse;
        }
        catch (UnsupportedOperationException e3) {
            LOGGER.error("Unsupported operation.", e3);
            pm2.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Unsupported operation: " + e3.getMessage());
            return serviceResponse;
        }
        catch (IllegalArgumentException e4) {
            LOGGER.debug("Illegal operation.", e4);
            pm2.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, "Illegal operation: " + e4.getMessage());
            return serviceResponse;
        }
        catch (ClassCastException e5) {
            LOGGER.error("Result did not match expected format", e5);
            pm2.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Illegal result type: " + e5.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeCommitAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executePost(ServiceRequest request, ServiceResponse response) {
        String urlPath = request.getUrlPath();
        if (urlPath == null || urlPath.equals("/")) {
            return Service.errorResponse(response, 400, POST_ONLY_ALLOWED_TO_COLLECTIONS);
        }
        PersistenceManager pm2 = this.getPm();
        try {
            ServiceResponse serviceResponse = this.handlePost(pm2, urlPath, response, request);
            return serviceResponse;
        }
        catch (UnauthorizedException e2) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e2.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e3) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e3.getMessage());
            return serviceResponse;
        }
        catch (IllegalArgumentException e4) {
            LOGGER.debug("User Error: {}", (Object)e4.getMessage());
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, "Incorrect request: " + e4.getMessage());
            return serviceResponse;
        }
        catch (IOException | RuntimeException e5) {
            LOGGER.error(FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG, (Object)e5.getMessage());
            LOGGER.debug(EXCEPTION, e5);
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Failed to store data.");
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handlePost(PersistenceManager pm2, String urlPath, ServiceResponse response, ServiceRequest request) throws IOException {
        Entity entity;
        ResultFormatter formatter;
        Query query;
        ResourcePath path;
        Version version = request.getVersion();
        try {
            path = PathParser.parsePath(this.modelRegistry, this.settings.getQueryDefaults().getServiceRootUrl(), version, urlPath);
        }
        catch (IllegalArgumentException | IllegalStateException e2) {
            return Service.errorResponse(response, 404, "Not a valid path: " + e2.getMessage());
        }
        if (!(path.getMainElement() instanceof PathElementEntitySet)) {
            return Service.errorResponse(response, 400, POST_ONLY_ALLOWED_TO_COLLECTIONS);
        }
        try {
            query = QueryParser.parseQuery(request.getUrlQuery(), this.settings, path);
            query.validate();
            formatter = this.findFormatter(query, request, version);
        }
        catch (IncorrectRequestException | IllegalArgumentException ex2) {
            return Service.errorResponse(response, 400, ex2.getMessage());
        }
        if (!pm2.validatePath(path)) {
            this.maybeCommitAndClose();
            return Service.errorResponse(response, 404, NOTHING_FOUND_RESPONSE);
        }
        PathElementEntitySet mainSet = (PathElementEntitySet)path.getMainElement();
        EntityType type = mainSet.getEntityType();
        JsonReader jsonReader = new JsonReader(this.modelRegistry);
        try {
            entity = jsonReader.parseEntity(type, request.getContentReader());
            entity.complete(mainSet);
            this.settings.getCustomLinksHelper().cleanPropertiesMap(entity);
        }
        catch (JsonParseException | JsonMappingException | IncompleteEntityException | IllegalStateException ex3) {
            LOGGER.debug("Post failed: {}", (Object)ex3.getMessage());
            LOGGER.trace(EXCEPTION, ex3);
            return Service.errorResponse(response, 400, ex3.getMessage());
        }
        try {
            if (!pm2.insert(entity)) {
                LOGGER.debug("No need to insert entity.");
            }
            this.maybeCommitAndClose();
            entity.setQuery(query);
            response.setResult(entity);
            response.setCode(201);
            if (query.getMetadata() != Metadata.OFF) {
                String url = UrlHelper.generateSelfLink(null, path, entity);
                response.addHeader("Location", url);
            }
            return this.formatResponse(response, formatter, query, path, entity);
        }
        catch (IncompleteEntityException | NoSuchEntityException | IllegalArgumentException e3) {
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, e3.getMessage());
        }
    }

    public ResultFormatter findFormatter(Query query, ServiceRequest request, Version version) throws IncorrectRequestException {
        String format = query.getFormat();
        if (format == null) {
            format = request.getParameter("$format");
        }
        ResultFormatter formatter = this.settings.getFormatter(version, format);
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executePatch(ServiceRequest request, ServiceResponse response, boolean isChangeSet) {
        PersistenceManager pm2 = null;
        try {
            if (request.getUrlPath() == null || request.getUrlPath().equals("/")) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "PATCH only allowed on Entities.");
                return serviceResponse;
            }
            pm2 = this.getPm();
            if (isChangeSet) {
                ServiceResponse serviceResponse = this.handleChangeSet(pm2, request, response);
                return serviceResponse;
            }
            ServiceResponse serviceResponse = this.handlePatch(pm2, request, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e2) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e2.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e3) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e3.getMessage());
            return serviceResponse;
        }
        catch (IncompleteEntityException | IOException | RuntimeException exc) {
            LOGGER.error(FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG, (Object)exc.getMessage());
            LOGGER.debug(EXCEPTION, exc);
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Failed to store data.");
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handlePatch(PersistenceManager pm2, ServiceRequest request, ServiceResponse response) throws IOException {
        Entity entity;
        PathElementEntity mainElement;
        try {
            mainElement = this.parsePathForPutPatch(pm2, request);
            JsonReader entityParser = new JsonReader(this.modelRegistry);
            entity = entityParser.parseEntity(mainElement.getEntityType(), request.getContentReader());
            this.settings.getCustomLinksHelper().cleanPropertiesMap(entity);
            entity.getEntityType().validateUpdate(entity);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("Path not valid for patch.", exc);
            return Service.errorResponse(response, 400, exc.getMessage());
        }
        catch (JsonParseException | JsonMappingException exc) {
            LOGGER.debug(COULD_NOT_PARSE_JSON, exc);
            return Service.errorResponse(response, 400, "Could not parse json. " + exc.getMessage());
        }
        catch (IncompleteEntityException | NoSuchEntityException exc) {
            return Service.errorResponse(response, 404, exc.getMessage());
        }
        try {
            if (pm2.update(mainElement, entity)) {
                this.maybeCommitAndClose();
                response.setCode(200);
                return response;
            }
            LOGGER.debug("Failed to patch entity.");
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, "Failed to patch entity.");
        }
        catch (IncompleteEntityException | NoSuchEntityException | IllegalArgumentException e2) {
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, e2.getMessage());
        }
    }

    private ServiceResponse handleChangeSet(PersistenceManager pm2, ServiceRequest request, ServiceResponse response) throws IOException, IncompleteEntityException {
        JsonPatch jsonPatch;
        PathElementEntity mainElement;
        try {
            mainElement = this.parsePathForPutPatch(pm2, request);
            jsonPatch = SimpleJsonMapper.getSimpleObjectMapper().readValue(request.getContentReader(), JsonPatch.class);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("Path not valid.", exc);
            return Service.errorResponse(response, 400, exc.getMessage());
        }
        catch (JsonParseException exc) {
            LOGGER.debug(COULD_NOT_PARSE_JSON, exc);
            return Service.errorResponse(response, 400, COULD_NOT_PARSE_JSON);
        }
        catch (NoSuchEntityException exc) {
            return Service.errorResponse(response, 404, exc.getMessage());
        }
        try {
            if (pm2.update(mainElement, jsonPatch)) {
                this.maybeCommitAndClose();
                return Service.successResponse(response, 200, "JSON-Patch applied.");
            }
            LOGGER.debug(FAILED_TO_UPDATE_ENTITY);
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, FAILED_TO_UPDATE_ENTITY);
        }
        catch (NoSuchEntityException | IllegalArgumentException e2) {
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, e2.getMessage());
        }
    }

    private PathElementEntity parsePathForPutPatch(PersistenceManager pm2, ServiceRequest request) throws NoSuchEntityException {
        ResourcePath path;
        try {
            path = PathParser.parsePath(this.modelRegistry, this.settings.getQueryDefaults().getServiceRootUrl(), request.getVersion(), request.getUrlPath());
        }
        catch (IllegalArgumentException | IllegalStateException exc) {
            throw new NoSuchEntityException("Not a valid path: " + exc.getMessage());
        }
        if (!pm2.validatePath(path)) {
            throw new NoSuchEntityException("No entity found for path.");
        }
        if (!(path.getMainElement() instanceof PathElementEntity) || path.getMainElement() != path.getLastElement()) {
            throw new IllegalArgumentException("PATCH & PUT only allowed on Entities.");
        }
        PathElementEntity mainElement = (PathElementEntity)path.getMainElement();
        if (mainElement.getId() == null) {
            throw new IllegalArgumentException("PATCH & PUT only allowed on Entities.");
        }
        if (request.getUrlQuery() != null && !request.getUrlQuery().isEmpty()) {
            throw new IllegalArgumentException("No query options allowed on PATCH & PUT.");
        }
        return mainElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executePut(ServiceRequest request, ServiceResponse response) {
        PersistenceManager pm2 = null;
        try {
            if (request.getUrlPath() == null || request.getUrlPath().equals("/")) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "PATCH only allowed on Entities.");
                return serviceResponse;
            }
            pm2 = this.getPm();
            ServiceResponse serviceResponse = this.handlePut(pm2, request, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e2) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e2.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e3) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e3.getMessage());
            return serviceResponse;
        }
        catch (IncompleteEntityException | IOException | RuntimeException e4) {
            LOGGER.error(FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG, (Object)e4.getMessage());
            LOGGER.debug(EXCEPTION, e4);
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, e4.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handlePut(PersistenceManager pm2, ServiceRequest request, ServiceResponse response) throws IOException, IncompleteEntityException {
        Entity entity;
        PathElementEntity mainElement;
        try {
            mainElement = this.parsePathForPutPatch(pm2, request);
            JsonReader entityParser = new JsonReader(this.modelRegistry);
            entity = entityParser.parseEntity(mainElement.getEntityType(), request.getContentReader());
            entity.complete(true);
            this.settings.getCustomLinksHelper().cleanPropertiesMap(entity);
            entity.setEntityPropertiesSet(true, true);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("Path not valid.", exc);
            return Service.errorResponse(response, 400, exc.getMessage());
        }
        catch (JsonParseException | IncompleteEntityException exc) {
            LOGGER.error(COULD_NOT_PARSE_JSON, exc);
            return Service.errorResponse(response, 400, COULD_NOT_PARSE_JSON);
        }
        catch (NoSuchEntityException exc) {
            return Service.errorResponse(response, 404, exc.getMessage());
        }
        try {
            if (pm2.update(mainElement, entity)) {
                this.maybeCommitAndClose();
                return Service.successResponse(response, 200, "Updated.");
            }
            LOGGER.debug(FAILED_TO_UPDATE_ENTITY);
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, FAILED_TO_UPDATE_ENTITY);
        }
        catch (NoSuchEntityException e2) {
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, e2.getMessage());
        }
    }

    private ServiceResponse executeDelete(ServiceRequest request, ServiceResponse response) {
        ResourcePath path;
        if (request.getUrlPath() == null || request.getUrlPath().equals("/")) {
            return Service.errorResponse(response, 400, "DELETE only allowed on Entities and Sets.");
        }
        try {
            path = PathParser.parsePath(this.modelRegistry, this.settings.getQueryDefaults().getServiceRootUrl(), request.getVersion(), request.getUrlPath());
        }
        catch (IllegalArgumentException | IllegalStateException exc) {
            return Service.errorResponse(response, 404, "Not a valid path: " + exc.getMessage());
        }
        if (path.getMainElement() instanceof PathElementEntity) {
            return this.executeDeleteEntity(request, response, path);
        }
        if (this.settings.isFilterDeleteEnabled() && path.getMainElement() instanceof PathElementEntitySet) {
            return this.executeDeleteEntitySet(request, response, path);
        }
        return Service.errorResponse(response, 400, "Not a valid path for DELETE.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executeDeleteEntity(ServiceRequest request, ServiceResponse response, ResourcePath path) {
        PersistenceManager pm2 = null;
        try {
            PathElementEntity mainEntity = (PathElementEntity)path.getMainElement();
            if (mainEntity != path.getLastElement()) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "DELETE not allowed on properties.");
                return serviceResponse;
            }
            if (mainEntity.getId() == null) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "No ID found.");
                return serviceResponse;
            }
            if (request.getUrlQuery() != null && !request.getUrlQuery().isEmpty()) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "No query options allowed on PATH when deleting an entity.");
                return serviceResponse;
            }
            pm2 = this.getPm();
            if (!pm2.validatePath(path)) {
                this.maybeCommitAndClose();
                ServiceResponse serviceResponse = Service.errorResponse(response, 404, NOTHING_FOUND_RESPONSE);
                return serviceResponse;
            }
            ServiceResponse serviceResponse = this.handleDelete(pm2, mainEntity, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e2) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e2.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e3) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e3.getMessage());
            return serviceResponse;
        }
        catch (Exception e4) {
            LOGGER.error("", e4);
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, e4.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handleDelete(PersistenceManager pm2, PathElementEntity mainEntity, ServiceResponse response) {
        try {
            if (pm2.delete(mainEntity)) {
                this.maybeCommitAndClose();
                response.setCode(200);
                return response;
            }
            LOGGER.debug("Failed to delete entity.");
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 400, "Failed to delete entity.");
        }
        catch (NoSuchEntityException e2) {
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 404, e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executeDeleteEntitySet(ServiceRequest request, ServiceResponse response, ResourcePath path) {
        PersistenceManager pm2 = null;
        try {
            PathElementEntitySet mainEntity = (PathElementEntitySet)path.getMainElement();
            if (mainEntity != path.getLastElement()) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "DELETE not allowed on properties.");
                return serviceResponse;
            }
            pm2 = this.getPm();
            if (!pm2.validatePath(path)) {
                this.maybeCommitAndClose();
                ServiceResponse serviceResponse = Service.errorResponse(response, 404, NOTHING_FOUND_RESPONSE);
                return serviceResponse;
            }
            ServiceResponse serviceResponse = this.handleDeleteSet(request, response, pm2, path);
            return serviceResponse;
        }
        catch (ForbiddenException e2) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e2.getMessage());
            return serviceResponse;
        }
        catch (UnauthorizedException e3) {
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e3.getMessage());
            return serviceResponse;
        }
        catch (Exception e4) {
            LOGGER.error("", e4);
            this.rollbackAndClose(pm2);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, e4.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handleDeleteSet(ServiceRequest request, ServiceResponse response, PersistenceManager pm2, ResourcePath path) {
        Query query;
        try {
            query = QueryParser.parseQuery(request.getUrlQuery(), this.settings, path).validate();
        }
        catch (IllegalArgumentException e2) {
            return Service.errorResponse(response, 404, "Failed to parse query: " + e2.getMessage());
        }
        if (query.getCount().isPresent()) {
            return Service.errorResponse(response, 400, "$count not allowed on delete requests.");
        }
        if (!query.getExpand().isEmpty()) {
            return Service.errorResponse(response, 400, "$expand not allowed on delete requests.");
        }
        if (query.getTop().isPresent()) {
            return Service.errorResponse(response, 400, "$top not allowed on delete requests.");
        }
        if (query.getSkip().isPresent()) {
            return Service.errorResponse(response, 400, "$skip not allowed on delete requests.");
        }
        try {
            pm2.delete(path, query);
            this.maybeCommitAndClose();
            return Service.successResponse(response, 200, "Deleted.");
        }
        catch (NoSuchEntityException e3) {
            pm2.rollbackAndClose();
            return Service.errorResponse(response, 404, e3.getMessage());
        }
    }

    public static ServiceResponse successResponse(ServiceResponse response, Version.CannedResponse cr2) {
        return Service.successResponse(response, cr2.code, cr2.message);
    }

    public static ServiceResponse successResponse(ServiceResponse response, int code, String message) {
        return Service.jsonResponse(response, "success", code, message);
    }

    public static ServiceResponse errorResponse(ServiceResponse response, Version.CannedResponse cr2) {
        return Service.errorResponse(response, cr2.code, cr2.message);
    }

    public static ServiceResponse errorResponse(ServiceResponse response, int code, String message) {
        if (response == null) {
            response = new ServiceResponseDefault();
        }
        return Service.jsonResponse(response, "error", code, message);
    }

    public static ServiceResponse jsonResponse(ServiceResponse response, String type, int code, String message) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("type", type);
        body.put("code", code);
        body.put("message", message);
        try {
            return response.setStatus(code, JsonWriter.writeObject(body));
        }
        catch (IOException ex2) {
            LOGGER.error("Failed to serialise error response.", ex2);
            return response.setStatus(code, message);
        }
    }
}

