/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.text.ParseException;
import net.time4j.ZonalDateTime;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public class DateTimeConstant
extends Constant<ZonalDateTime> {
    public static final Timezone TIMEZONE_UTC = Timezone.of(ZonalOffset.UTC);

    public DateTimeConstant(ZonalDateTime value) {
        super(value);
    }

    public DateTimeConstant(String value) throws ParseException {
        if (value.lastIndexOf(45) <= 0) {
            throw new IllegalArgumentException("Not a date: " + value);
        }
        this.value = ZonalDateTime.parse(value, Iso8601Format.EXTENDED_DATE_TIME_OFFSET);
    }

    @Override
    public String toUrl() {
        return StringHelper.FORMAT_MOMENT.print(((ZonalDateTime)this.getValue()).toMoment());
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }

    public static DateTimeConstant parse(String value) {
        try {
            return new DateTimeConstant(value);
        }
        catch (ParseException ex2) {
            throw new IllegalArgumentException("Failed to parse PlainTimestamp " + StringHelper.cleanForLogging(value), ex2);
        }
    }
}

