/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.BooleanConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DoubleConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IdConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IntegerConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.StringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.TimeObjectConstant;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstantFactory.class.getName());

    private ConstantFactory() {
    }

    public static Constant of(Object object) {
        if (object instanceof BigDecimal) {
            return new StringConstant(Objects.toString(object));
        }
        if (object instanceof Boolean) {
            return new BooleanConstant((Boolean)object);
        }
        if (object instanceof Double) {
            return new DoubleConstant((Double)object);
        }
        if (object instanceof Id) {
            return new IdConstant((Id)object);
        }
        if (object instanceof Integer) {
            return new IntegerConstant((Integer)object);
        }
        if (object instanceof Long) {
            return new IntegerConstant((Long)object);
        }
        if (object instanceof String) {
            return new StringConstant(Objects.toString(object));
        }
        if (object instanceof TimeObject) {
            return new TimeObjectConstant((TimeObject)object);
        }
        LOGGER.warn("Can not make constant of {}", (Object)object.getClass());
        return null;
    }
}

