/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyCustom;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Expand {
    private ModelRegistry modelRegistry;
    private List<String> rawPath;
    private NavigationProperty validatedPath;
    private Query parentQuery;
    private Query subQuery;

    public Expand(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public Expand(ModelRegistry modelRegistry, Query subQuery) {
        this.modelRegistry = modelRegistry;
        if (subQuery != null) {
            this.setSubQuery(subQuery);
        }
    }

    public Expand(ModelRegistry modelRegistry, NavigationProperty path) {
        if (path == null) {
            throw new IllegalArgumentException("path must be non-empty");
        }
        this.modelRegistry = modelRegistry;
        this.validatedPath = path;
    }

    public Expand(ModelRegistry modelRegistry, Query subQuery, NavigationProperty path) {
        if (path == null) {
            throw new IllegalArgumentException("paths must be non-empty");
        }
        this.modelRegistry = modelRegistry;
        this.validatedPath = path;
        this.setSubQuery(subQuery);
    }

    public NavigationProperty getPath() {
        return this.validatedPath;
    }

    public void addToRawPath(String subPath) {
        if (this.rawPath == null) {
            this.rawPath = new ArrayList<String>();
        }
        this.rawPath.add(subPath);
    }

    public List<String> getRawPath() {
        if (this.rawPath == null) {
            String[] items = StringUtils.split(this.validatedPath.getName(), '/');
            this.rawPath = Arrays.asList(items);
        }
        return this.rawPath;
    }

    public boolean hasSubQuery() {
        return this.subQuery != null;
    }

    public Query getSubQuery() {
        if (this.subQuery == null) {
            this.setSubQuery(new Query(this.modelRegistry, this.parentQuery.getSettings(), this.parentQuery.getPath()).validate(this.validatedPath.getEntityType()));
        }
        return this.subQuery;
    }

    public final Expand setSubQuery(Query subQuery) {
        this.subQuery = subQuery;
        this.subQuery.setParentExpand(this);
        return this;
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    public void setParentQuery(Query parentQuery) {
        this.parentQuery = parentQuery;
    }

    public void validate(ResourcePath path) {
        PathElement mainElement = path.getMainElement();
        if (mainElement instanceof PathElementProperty || mainElement instanceof PathElementCustomProperty) {
            throw new IllegalArgumentException("No expand allowed on property paths.");
        }
        EntityType entityType = path.getMainElementType();
        if (entityType == null) {
            throw new IllegalStateException("Unkown ResourcePathElementType found.");
        }
        this.validate(entityType);
    }

    protected void validate(EntityType entityType) {
        if (this.validatedPath == null) {
            String firstRawPath = this.rawPath.get(0);
            Property property = entityType.getProperty(firstRawPath);
            int rawCount = this.rawPath.size();
            if (property instanceof NavigationPropertyMain) {
                this.validatedPath = (NavigationPropertyMain)property;
                if (rawCount > 1) {
                    Expand subExpand = new Expand(this.modelRegistry, this.subQuery);
                    for (int i2 = 1; i2 < rawCount; ++i2) {
                        subExpand.addToRawPath(this.rawPath.get(i2));
                    }
                    this.rawPath.clear();
                    this.rawPath.add(firstRawPath);
                    this.subQuery = new Query(this.modelRegistry, this.parentQuery.getSettings(), this.parentQuery.getPath());
                    this.subQuery.addExpand(subExpand);
                    this.subQuery.setParentExpand(this);
                }
            } else if (property instanceof EntityPropertyMain && ((EntityPropertyMain)property).hasCustomProperties) {
                EntityPropertyMain entityPropertyMain = (EntityPropertyMain)property;
                NavigationPropertyCustom tempPath = new NavigationPropertyCustom(this.modelRegistry, entityPropertyMain);
                for (int i3 = 1; i3 < rawCount; ++i3) {
                    tempPath.addToSubPath(this.rawPath.get(i3));
                }
                this.validatedPath = tempPath;
            } else {
                throw new IllegalArgumentException("Invalid custom expand path '" + firstRawPath + "' on entity type " + entityType.entityName);
            }
        }
        if (this.subQuery != null && this.validatedPath != null) {
            if (!this.subQuery.hasMetadata()) {
                this.subQuery.setMetadata(this.parentQuery.getMetadata());
            }
            this.subQuery.validate(this.validatedPath.getEntityType());
        }
    }

    public int hashCode() {
        return Objects.hash(this.validatedPath, this.subQuery);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expand other = (Expand)obj;
        return Objects.equals(this.getRawPath(), other.getRawPath()) && Objects.equals(this.subQuery, other.subQuery);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.validatedPath == null) {
            sb.append(StringUtils.join(this.rawPath, "/"));
        } else {
            sb.append(this.validatedPath.getName());
        }
        if (this.subQuery != null && !this.subQuery.isEmpty()) {
            sb.append('(');
            sb.append(this.subQuery.toString(true));
            sb.append(')');
        }
        return sb.toString();
    }
}

