/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.NavigableElement;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeEntity;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationPropertyCustom
implements NavigationProperty<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigationPropertyCustom.class.getName());
    private static final String NOT_SUPPORTED = "Not supported on NavigationPropertyCustom.";
    private final ModelRegistry modelRegistry;
    private final EntityPropertyMain entityProperty;
    private final List<String> subPath = new ArrayList<String>();
    private String name;
    private EntityType type;
    private final LinkTargetData targetData = new LinkTargetData();

    public NavigationPropertyCustom(ModelRegistry modelRegistry, EntityPropertyMain entityProperty) {
        this.modelRegistry = modelRegistry;
        this.entityProperty = entityProperty;
    }

    @Override
    public EntityType getEntityType() {
        return this.type;
    }

    public List<String> getSubPath() {
        return this.subPath;
    }

    public NavigationPropertyCustom addToSubPath(String subPathElement) {
        this.subPath.add(subPathElement);
        String[] split = StringUtils.split(subPathElement, '.');
        if (split.length == 1) {
            return this;
        }
        String typeName = split[split.length - 1];
        this.name = subPathElement.substring(0, subPathElement.length() - typeName.length() - 1);
        this.type = this.modelRegistry.getEntityTypeForName(typeName);
        return this;
    }

    private void init(Entity entity) {
        if (this.type == null) {
            throw new IllegalArgumentException("Path not to a custom link: " + this.entityProperty + "/" + StringUtils.join(this.subPath, '/'));
        }
        if (!Objects.equals(entity, this.targetData.entity)) {
            this.targetData.findLinkTargetData(entity, this.entityProperty, this.subPath, this.name, this.type);
        }
    }

    @Override
    public boolean validFor(EntityType entityType) {
        return entityType.getProperty(this.entityProperty.name) != null;
    }

    @Override
    public boolean isEntitySet() {
        return false;
    }

    @Override
    public String getName() {
        return this.entityProperty.name + "/" + StringUtils.join(this.subPath, '/');
    }

    @Override
    public String getJsonName() {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public PropertyType getType() {
        return new TypeEntity(this.type);
    }

    public void setElementOn(Entity entity, NavigableElement expandedElement) {
        this.init(entity);
        this.targetData.containingMap.put(this.name + "." + this.type.entityName, expandedElement);
    }

    public Object getTargetIdFrom(Entity entity) {
        this.init(entity);
        return this.targetData.targetId;
    }

    @Override
    public Entity getFrom(Entity entity) {
        this.init(entity);
        if (this.targetData.containingMap == null) {
            return null;
        }
        return (Entity)this.targetData.containingMap.get(this.targetData.fullKeyEntity);
    }

    @Override
    public void setOn(Entity entity, Entity value) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        this.init(entity);
        if (this.targetData.containingMap == null) {
            return false;
        }
        return this.targetData.containingMap.containsKey(this.targetData.fullKeyEntity);
    }

    @Override
    public String getNavigationLink(Entity parent) {
        String selfLink = parent.getSelfLink();
        if (selfLink == null) {
            return null;
        }
        Object link = selfLink + "/" + this.entityProperty.name + "/" + String.join((CharSequence)"/", this.subPath);
        if (!parent.getQuery().getSettings().useAbsoluteNavigationLinks()) {
            Query query = parent.getQuery();
            ResourcePath path = query.getPath();
            String curPath = path.getServiceRootUrl() + path.getPath();
            link = UrlHelper.getRelativePath((String)link, curPath);
        }
        return link;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationPropertyCustom other = (NavigationPropertyCustom)obj;
        if (this.entityProperty != other.entityProperty) {
            return false;
        }
        return Objects.equals(this.subPath, other.subPath);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.entityProperty);
        hash = 37 * hash + Objects.hashCode(this.subPath);
        return hash;
    }

    private static class LinkTargetData {
        private Entity entity;
        private Map<String, Object> containingMap;
        private String fullKeyEntity;
        private Object targetId;

        private LinkTargetData() {
        }

        public void clear() {
            this.entity = null;
            this.containingMap = null;
            this.fullKeyEntity = null;
            this.targetId = null;
        }

        public void findLinkTargetData(Entity entity, EntityPropertyMain entityProperty, List<String> subPath, String name, EntityType type) {
            this.clear();
            Object curTarget = entityProperty.getFrom(entity);
            int count = subPath.size() - 1;
            for (int idx = 0; idx < count; ++idx) {
                String curPathItem = subPath.get(idx);
                if (!(curTarget instanceof Map)) {
                    return;
                }
                Map map = (Map)curTarget;
                curTarget = map.get(curPathItem);
            }
            if (curTarget instanceof Map) {
                this.findLinkEntryInMap((Map)curTarget, name, type);
            }
            this.entity = entity;
        }

        private void findLinkEntryInMap(Map<String, Object> map, String name, EntityType type) {
            this.fullKeyEntity = name + "." + type.entityName;
            String keyId = this.fullKeyEntity + "@iot.id";
            Object keyValue = map.get(keyId);
            if (keyValue == null) {
                LOGGER.trace("Not found in map: {}", (Object)name);
            } else {
                this.containingMap = map;
                this.targetId = keyValue;
            }
        }
    }
}

