/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.util.CollectionsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EntityPropertyCustomSelect
implements EntityProperty<Object> {
    private static final String NOT_SUPPORTED = "Not supported on custom properties.";
    private final String entityPropertyName;
    private EntityPropertyMain entityProperty;
    private final List<String> subPath = new ArrayList<String>();

    public EntityPropertyCustomSelect(String entityPropertyName) {
        this.entityPropertyName = entityPropertyName;
    }

    public String getMainEntityPropertyName() {
        return this.entityPropertyName;
    }

    public List<String> getSubPath() {
        return this.subPath;
    }

    public EntityPropertyCustomSelect addToSubPath(Collection<String> subPathElements) {
        this.subPath.addAll(subPathElements);
        return this;
    }

    public EntityPropertyCustomSelect addToSubPath(String subPathElement) {
        this.subPath.add(subPathElement);
        return this;
    }

    @Override
    public String getName() {
        return this.entityPropertyName + "/" + StringUtils.join(this.subPath, '/');
    }

    @Override
    public String getJsonName() {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    @Override
    public PropertyType getType() {
        return TypeComplex.STA_OBJECT;
    }

    @Override
    public Object getFrom(Entity entity) {
        Object baseProperty;
        if (this.entityProperty == null) {
            this.entityProperty = entity.getEntityType().getEntityProperty(this.entityPropertyName);
        }
        if ((baseProperty = entity.getProperty(this.entityProperty)) instanceof Map) {
            return CollectionsHelper.getFrom((Map)baseProperty, this.subPath);
        }
        return null;
    }

    @Override
    public void setOn(Entity entity, Object value) {
        Object baseProperty;
        if (this.entityProperty == null) {
            this.entityProperty = entity.getEntityType().getEntityProperty(this.entityPropertyName);
        }
        if ((baseProperty = entity.getProperty(this.entityProperty)) == null) {
            LinkedHashMap basePropertyMap = new LinkedHashMap();
            baseProperty = basePropertyMap;
            entity.setProperty(this.entityProperty, baseProperty);
        }
        if (!(baseProperty instanceof Map)) {
            throw new UnsupportedOperationException("Can not set: " + this.entityPropertyName + " value is not a map.");
        }
        CollectionsHelper.setOn((Map<String, Object>)((Map)baseProperty), this.subPath, value);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        throw new UnsupportedOperationException(NOT_SUPPORTED);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return Objects.hash(this.entityPropertyName, this.subPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPropertyCustomSelect other = (EntityPropertyCustomSelect)obj;
        return Objects.equals(this.entityPropertyName, other.entityPropertyName) && Objects.equals(this.subPath, other.subPath);
    }
}

