/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.MomentBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractEp;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import org.jooq.Name;
import org.jooq.Table;

public class FieldMapperTimeValue
extends FieldMapperAbstractEp {
    @ConfigurableField(editor=EditorString.class, label="Start Field", description="The database field to use for the start DateTime.")
    @EditorString.EdOptsString
    private String fieldStart;
    @ConfigurableField(editor=EditorString.class, label="End Field", description="The database field to use for the end DateTime.")
    @EditorString.EdOptsString
    private String fieldEnd;
    @JsonIgnore
    private int fieldStartIdx;
    @JsonIgnore
    private int fieldEndIdx;

    @Override
    public void registerField(PostgresPersistenceManager ppm, StaMainTable staTable) {
        Name tableName = staTable.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        this.fieldStartIdx = FieldMapperTimeValue.getOrRegisterField(this.fieldStart, dbTable, staTable, new MomentBinding());
        this.fieldEndIdx = FieldMapperTimeValue.getOrRegisterField(this.fieldEnd, dbTable, staTable, new MomentBinding());
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(PostgresPersistenceManager ppm, T table) {
        EntityPropertyMain property = this.getParent().getEntityProperty();
        PropertyFieldRegistry<StaMainTable> pfReg = table.getPropertyFieldRegistry();
        int idxStart = this.fieldStartIdx;
        int idxEnd = this.fieldEndIdx;
        pfReg.addEntry((Property)property, new PropertyFieldRegistry.ConverterTimeValue<StaMainTable>(property, t2 -> t2.field(idxStart), t2 -> t2.field(idxEnd)), new PropertyFieldRegistry.NFP<StaMainTable>("start", t2 -> t2.field(idxStart)), new PropertyFieldRegistry.NFP<StaMainTable>("end", t2 -> t2.field(idxEnd)));
    }

    public String getFieldStart() {
        return this.fieldStart;
    }

    public FieldMapperTimeValue setFieldStart(String fieldStart) {
        this.fieldStart = fieldStart;
        return this;
    }

    public String getFieldEnd() {
        return this.fieldEnd;
    }

    public FieldMapperTimeValue setFieldEnd(String fieldEnd) {
        this.fieldEnd = fieldEnd;
        return this;
    }
}

