/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefNavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.RelationOneToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapperAbstractNp;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import org.jooq.Name;
import org.jooq.Table;
import org.jooq.TableField;

public class FieldMapperOneToMany
extends FieldMapperAbstractNp {
    @ConfigurableField(editor=EditorString.class, label="Field", description="The database field to use in 'my' table.")
    @EditorString.EdOptsString
    private String field;
    @ConfigurableField(editor=EditorString.class, label="OtherTable", description="The name of the other table we link to.")
    @EditorString.EdOptsString
    private String otherTable;
    @ConfigurableField(editor=EditorString.class, label="OtherField", description="The field in the other table that is the key in the relation.")
    @EditorString.EdOptsString
    private String otherField;
    @JsonIgnore
    private int fieldIdx;

    @Override
    public void registerField(PostgresPersistenceManager ppm, StaMainTable staTable) {
        Name tableName = staTable.getQualifiedName();
        Table<?> dbTable = ppm.getDbTable(tableName);
        this.fieldIdx = FieldMapperOneToMany.getOrRegisterField(this.field, dbTable, staTable);
    }

    @Override
    public <T extends StaMainTable<T>> void registerMapping(PostgresPersistenceManager ppm, T staTable) {
        StaMainTable staTableOther = (StaMainTable)ppm.getTableCollection().getTableForName(this.otherTable);
        Table<?> dbTableOther = ppm.getDbTable(this.otherTable);
        NavigationPropertyMain navProp = this.getParent().getNavigationProperty();
        PropertyFieldRegistry<StaMainTable> pfReg = staTable.getPropertyFieldRegistry();
        pfReg.addEntry(navProp, t2 -> t2.field(this.fieldIdx));
        int fieldIdxOther = FieldMapperOneToMany.getOrRegisterField(this.otherField, dbTableOther, staTableOther);
        staTable.registerRelation(new RelationOneToMany<T, StaMainTable>(navProp, staTable, staTableOther).setSourceFieldAccessor(t2 -> (TableField)t2.field(this.fieldIdx)).setTargetFieldAccessor(t2 -> (TableField)t2.field(fieldIdxOther)));
        DefNavigationProperty.Inverse inverse = this.getParent().getInverse();
        if (inverse != null) {
            NavigationPropertyMain navPropInverse = this.getParent().getNavigationPropertyInverse();
            PropertyFieldRegistry<StaMainTable> pfRegOther = staTableOther.getPropertyFieldRegistry();
            pfRegOther.addEntry(navPropInverse, t2 -> t2.field(fieldIdxOther));
            staTableOther.registerRelation(new RelationOneToMany<StaMainTable, T>(navPropInverse, staTableOther, staTable).setSourceFieldAccessor(t2 -> (TableField)t2.field(fieldIdxOther)).setTargetFieldAccessor(t2 -> (TableField)t2.field(this.fieldIdx)));
        }
    }

    public String getField() {
        return this.field;
    }

    public FieldMapperOneToMany setField(String field) {
        this.field = field;
        return this;
    }

    public String getOtherTable() {
        return this.otherTable;
    }

    public FieldMapperOneToMany setOtherTable(String otherTable) {
        this.otherTable = otherTable;
        return this;
    }

    public String getOtherField() {
        return this.otherField;
    }

    public FieldMapperOneToMany setOtherField(String otherField) {
        this.otherField = otherField;
        return this;
    }
}

