/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.EntitySetJooqCurser;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.ResultBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import java.util.HashSet;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class QueryState<T extends StaMainTable<T>> {
    private Set<PropertyFieldRegistry.PropertyFields<T>> selectedProperties;
    private Set<Field> sqlSelectFields;
    private final T mainTable;
    private final Field<?> sqlMainIdField;
    private Table sqlFrom;
    private Condition sqlWhere = DSL.noCondition();
    private Condition sqlSkipWhere;
    private Utils.SortSelectFields sqlSortFields;
    private boolean distinctRequired = false;
    private boolean isFilter = false;
    private int aliasNr = 0;

    public QueryState(T table, Set<PropertyFieldRegistry.PropertyFields<T>> sqlSelectFields) {
        this.selectedProperties = sqlSelectFields;
        this.sqlFrom = table;
        this.mainTable = table;
        this.sqlMainIdField = table.getId();
    }

    public T getMainTable() {
        return this.mainTable;
    }

    public Entity entityFromQuery(Record tuple, DataSize dataSize) {
        return this.mainTable.entityFromQuery(tuple, this, dataSize);
    }

    public EntitySet createSetFromRecords(Cursor<Record> tuples, ResultBuilder resultBuilder) {
        return new EntitySetJooqCurser(this.mainTable.getEntityType(), tuples, this, resultBuilder);
    }

    public String getNextAlias() {
        return "e" + ++this.aliasNr;
    }

    public boolean isSqlSortFieldsSet() {
        if (this.sqlSortFields == null) {
            return false;
        }
        return !this.sqlSortFields.getSqlSortFields().isEmpty();
    }

    public Utils.SortSelectFields getSqlSortFields() {
        if (this.sqlSortFields == null) {
            this.sqlSortFields = new Utils.SortSelectFields();
        }
        return this.sqlSortFields;
    }

    public Set<Field> getSqlSelectFields() {
        if (this.sqlSelectFields == null) {
            this.sqlSelectFields = new HashSet<Field>();
            for (PropertyFieldRegistry.PropertyFields<T> sp : this.selectedProperties) {
                for (PropertyFieldRegistry.ExpressionFactory<T> f2 : sp.fields.values()) {
                    this.sqlSelectFields.add(f2.get(this.mainTable));
                }
            }
        }
        return this.sqlSelectFields;
    }

    public Set<PropertyFieldRegistry.PropertyFields<T>> getSelectedProperties() {
        return this.selectedProperties;
    }

    public void setSelectedProperties(Set<PropertyFieldRegistry.PropertyFields<T>> sqlSelectFields) {
        this.selectedProperties = sqlSelectFields;
        this.sqlSelectFields = null;
    }

    public Field<?> getSqlMainIdField() {
        return this.sqlMainIdField;
    }

    public Table<Record> getSqlFrom() {
        return this.sqlFrom;
    }

    public void setSqlFrom(Table sqlFrom) {
        this.sqlFrom = sqlFrom;
    }

    public Condition getFullSqlWhere() {
        if (this.sqlSkipWhere == null) {
            return this.sqlWhere;
        }
        return this.sqlWhere.and(this.sqlSkipWhere);
    }

    public Condition getSqlWhere() {
        return this.sqlWhere;
    }

    public void setSqlWhere(Condition sqlWhere) {
        this.sqlWhere = sqlWhere;
    }

    public Condition getSqlSkipWhere() {
        return this.sqlSkipWhere == null ? DSL.noCondition() : this.sqlSkipWhere;
    }

    public void setSqlSkipWhere(Condition sqlSkipWhere) {
        this.sqlSkipWhere = sqlSkipWhere;
    }

    public void setSqlSortFields(Utils.SortSelectFields sqlSortFields) {
        this.sqlSortFields = sqlSortFields;
    }

    public boolean isDistinctRequired() {
        return this.distinctRequired;
    }

    public void setDistinctRequired(boolean distinctRequired) {
        this.distinctRequired = distinctRequired;
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public void setFilter(boolean isFilter) {
        this.isFilter = isFilter;
    }
}

