/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import de.fraunhofer.iosb.ilt.frostserver.util.exception.UpgradeFailedException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiquibaseHelper.class.getName());

    private LiquibaseHelper() {
    }

    public static String checkForUpgrades(Connection connection, String liquibaseChangelogFilename, Map<String, Object> params) {
        StringWriter out = new StringWriter();
        try {
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            LiquibaseHelper.runLiquibaseCheck(liquibaseChangelogFilename, params, database, out);
        }
        catch (DatabaseException ex2) {
            LiquibaseHelper.outputError((Exception)ex2, out, "Failed to initialise database");
        }
        return out.toString();
    }

    public static boolean doUpgrades(Connection connection, String liquibaseChangelogFilename, Map<String, Object> params, Writer out) throws UpgradeFailedException, IOException {
        try {
            LiquibaseHelper.runLiquibaseUpdate(liquibaseChangelogFilename, params, connection, out);
        }
        catch (DatabaseException ex2) {
            LiquibaseHelper.outputError((Exception)ex2, out, "Failed to initialise database");
            return false;
        }
        return true;
    }

    private static void runLiquibaseCheck(String liquibaseChangelogFilename, Map<String, Object> params, Database database, StringWriter out) {
        try (Liquibase liquibase = new Liquibase(liquibaseChangelogFilename, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);){
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            liquibase.update(new Contexts(), (Writer)out);
        }
        catch (LiquibaseException ex2) {
            LiquibaseHelper.outputError((Exception)ex2, out, "Failed to upgrade database");
        }
        catch (Exception ex3) {
            LOGGER.warn("Exception happened when closing liquibase.", ex3);
        }
    }

    private static void runLiquibaseUpdate(String liquibaseChangelogFilename, Map<String, Object> params, Connection connection, Writer out) throws UpgradeFailedException, IOException, DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
        try (Liquibase liquibase = new Liquibase(liquibaseChangelogFilename, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);){
            String searchPath = LiquibaseHelper.getSearchPath(connection);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
            liquibase.update(new Contexts());
            LiquibaseHelper.setSearchPath(connection, searchPath);
        }
        catch (LiquibaseException ex2) {
            LiquibaseHelper.outputError((Exception)ex2, out, "Failed to upgrade database");
            throw new UpgradeFailedException(ex2);
        }
        catch (Exception ex3) {
            LOGGER.warn("Exception happened when closing liquibase.", ex3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSearchPath(Connection connection) {
        try (PreparedStatement call = connection.prepareStatement("show search_path");){
            call.execute();
            try (ResultSet resultSet = call.getResultSet();){
                if (!resultSet.next()) return "";
                String searchPath = resultSet.getString(1);
                LOGGER.debug("Found search_path: {}", (Object)searchPath);
                String string = searchPath;
                return string;
            }
        }
        catch (SQLException ex2) {
            LOGGER.error("Failed to fetch search_path: ", ex2);
        }
        return "";
    }

    private static void setSearchPath(Connection connection, String wantedSearchPath) {
        String searchPath = LiquibaseHelper.getSearchPath(connection);
        if (wantedSearchPath.equals(searchPath)) {
            return;
        }
        LOGGER.info("Liquibase changed the search_path from '{}' to '{}'. Changing it back.", (Object)wantedSearchPath, (Object)searchPath);
        try (PreparedStatement call = connection.prepareStatement("select set_config('search_path', ?, false)");){
            call.setString(1, wantedSearchPath);
            call.execute();
            connection.commit();
        }
        catch (SQLException ex2) {
            LOGGER.error("Failed to set search_path: ", ex2);
        }
    }

    private static void outputError(Exception exception, StringWriter out, String message) {
        try {
            LiquibaseHelper.outputError(exception, (Writer)out, message);
        }
        catch (IOException exc) {
            LOGGER.error("Error writing output.", exc);
        }
    }

    private static void outputError(Exception exception, Writer out, String message) throws IOException {
        LOGGER.error(message, exception);
        out.append(message + ":\n");
        out.append(exception.getLocalizedMessage());
        out.append("\n");
    }
}

