/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations;

import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.FieldAccessor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.RelationManyToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableLike;

public class RelationManyToManyOrdered<S extends StaMainTable<S>, L extends StaTable<L>, T extends StaMainTable<T>>
extends RelationManyToMany<S, L, T> {
    private FieldAccessor<L> orderFieldAcc;
    private boolean alwaysDistinct = false;

    public RelationManyToManyOrdered(NavigationPropertyMain navProp, S source, L linkTable, T target) {
        super(navProp, source, linkTable, target);
    }

    public RelationManyToManyOrdered<S, L, T> setOrderFieldAcc(FieldAccessor<L> orderFieldAcc) {
        this.orderFieldAcc = orderFieldAcc;
        return this;
    }

    public RelationManyToManyOrdered<S, L, T> setAlwaysDistinct(boolean alwaysDistinct) {
        this.alwaysDistinct = alwaysDistinct;
        return this;
    }

    @Override
    public TableRef join(S source, QueryState<?> queryState, TableRef sourceRef) {
        StaTable targetAliased = this.getTarget().as(queryState.getNextAlias());
        Table linkTableAliased = this.getLinkTable().as(queryState.getNextAlias());
        Field sourceField = this.getSourceFieldAcc().getField(source);
        Field sourceLinkField = this.getSourceLinkFieldAcc().getField(linkTableAliased);
        Field targetLinkField = this.getTargetLinkFieldAcc().getField(linkTableAliased);
        Field targetField = this.getTargetFieldAcc().getField(targetAliased);
        queryState.setSqlFrom(queryState.getSqlFrom().innerJoin(linkTableAliased).on(sourceLinkField.eq(sourceField)));
        queryState.setSqlFrom(queryState.getSqlFrom().innerJoin(targetAliased).on(targetField.eq(targetLinkField)));
        if (this.alwaysDistinct || queryState.isFilter()) {
            queryState.setDistinctRequired(true);
        } else {
            Field orderField = this.orderFieldAcc.getField(linkTableAliased);
            queryState.getSqlSortFields().add(orderField, OrderBy.OrderType.ASCENDING);
        }
        return QueryBuilder.createJoinedRef(sourceRef, this.getTargetType(), targetAliased);
    }

    @Override
    public void link(PostgresPersistenceManager pm2, Object sourceId, Object targetId) {
        DSLContext dslContext = pm2.getDslContext();
        Object linkTable = this.getLinkTable();
        Field sourceLinkField = this.getSourceLinkFieldAcc().getField(linkTable);
        Field targetLinkField = this.getTargetLinkFieldAcc().getField(linkTable);
        Field orderField = this.orderFieldAcc.getField(linkTable);
        dslContext.insertInto(linkTable).set(sourceLinkField, sourceId).set(targetLinkField, targetId).set(orderField, dslContext.selectCount().from((TableLike<?>)linkTable).where(sourceLinkField.equal(sourceId))).execute();
    }
}

