/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonValue.class.getName());
    private Object value;
    private TypeReference type;
    private String stringValue;
    private int stringLength = 0;

    public JsonValue(String stringValue) {
        this.stringValue = stringValue;
        if (stringValue != null) {
            this.stringLength = stringValue.length();
        }
    }

    public JsonValue(JsonNode value) {
        this.value = value;
    }

    public JsonValue(Object value) {
        this.value = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Object getValue() {
        if (this.value == null) {
            return Utils.jsonToTree(this.stringValue);
        }
        return this.value;
    }

    public Map<String, Object> getMapValue() {
        return this.getValue(Utils.TYPE_MAP_STRING_OBJECT);
    }

    public <T> T getValue(TypeReference<T> typeReference) {
        if (this.type != null && !this.type.equals(typeReference)) {
            LOGGER.warn("Type Switch, from {} to {}", (Object)this.type, (Object)typeReference);
            this.type = null;
        }
        if (this.type == null) {
            this.type = typeReference;
            this.value = Utils.jsonToObject(this.stringValue, typeReference);
        }
        return (T)this.value;
    }

    public int getStringLength() {
        return this.stringLength;
    }
}

