/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePathVisitor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PgExpressionHandler;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.PersistenceSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.jooq.AggregateFunction;
import org.jooq.DSLContext;
import org.jooq.Delete;
import org.jooq.DeleteConditionStep;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectIntoStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectSelectStep;
import org.jooq.SelectWithTiesAfterOffsetStep;
import org.jooq.TableLike;
import org.jooq.conf.ParamType;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder
implements ResourcePathVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryBuilder.class);
    private static final String GENERATED_SQL = "Generated SQL:\n{}";
    private static final String TABLESAMPLE_REPLACE_REGEX = "$1 tablesample system (1)";
    private static final String TABLE_SEARCH_REGEX = "(\"[A-Za-z0-9_-]+\" as \"[A-Za-z0-9]+\")";
    private static final Pattern TABLE_SEARCH_PATTERN = Pattern.compile("(\"[A-Za-z0-9_-]+\" as \"[A-Za-z0-9]+\")");
    public static final String ALIAS_PREFIX = "e";
    public static final String DEFAULT_PREFIX = "e0";
    private final PostgresPersistenceManager pm;
    private final CoreSettings coreSettings;
    private final PersistenceSettings settings;
    private final TableCollection tableCollection;
    private Query staQuery;
    private Set<Property> selectedProperties;
    private TableRef lastPath;
    private TableRef mainTable;
    private NavigationPropertyMain lastNavProp;
    private boolean forPath = false;
    private ResourcePath requestedPath;
    private boolean forTypeAndId = false;
    private EntityType requestedEntityType;
    private Id requestedId;
    private boolean forUpdate = false;
    private boolean single = false;
    private boolean parsed = false;
    private QueryState<?> queryState;

    public QueryBuilder(PostgresPersistenceManager pm2, CoreSettings coreSettings, TableCollection tableCollection) {
        this.pm = pm2;
        this.coreSettings = coreSettings;
        this.settings = coreSettings.getPersistenceSettings();
        this.tableCollection = tableCollection;
    }

    public QueryState<?> getQueryState() {
        return this.queryState;
    }

    public ResultQuery<Record> buildSelect() {
        int count;
        SelectIntoStep<Record> selectStep;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            selectStep = dslContext.selectDistinct(this.queryState.getSqlSelectFields());
        } else if (this.queryState.isDistinctRequired()) {
            if (this.queryState.isSqlSortFieldsSet()) {
                if (this.staQuery == null || !this.staQuery.isPkOrder()) {
                    this.queryState.getSqlSortFields().add(this.queryState.getSqlMainIdField(), OrderBy.OrderType.ASCENDING);
                }
                selectStep = dslContext.select(this.queryState.getSqlSelectFields()).distinctOn(this.queryState.getSqlSortFields().getSqlSortSelectFields());
            } else {
                selectStep = dslContext.select(this.queryState.getSqlSelectFields()).distinctOn(this.queryState.getSqlMainIdField());
            }
        } else {
            selectStep = dslContext.select(this.queryState.getSqlSelectFields());
        }
        SelectConditionStep whereStep = selectStep.from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getFullSqlWhere());
        List<OrderField> sortFields = this.queryState.getSqlSortFields().getSqlSortFields();
        SelectSeekStepN orderByStep = whereStep.orderBy((OrderField[])sortFields.toArray(OrderField[]::new));
        int skip = 0;
        if (this.single) {
            count = 2;
        } else if (this.staQuery != null) {
            count = this.staQuery.getTopOrDefault() + 1;
            if (this.staQuery.getSkipFilter() == null) {
                skip = this.staQuery.getSkip(0);
            }
        } else {
            count = 1;
        }
        SelectWithTiesAfterOffsetStep<Record> limit = orderByStep.limit(skip, count);
        if (this.forUpdate) {
            return limit.forUpdate();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)limit.getSQL(ParamType.INDEXED));
        }
        return limit;
    }

    public ResultQuery<Record1<Integer>> buildCount() {
        AggregateFunction<Integer> count;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            Set<Field> sqlSelectFields = this.queryState.getSqlSelectFields();
            count = DSL.countDistinct((Field[])sqlSelectFields.toArray(Field[]::new));
        } else {
            count = this.queryState.isDistinctRequired() ? DSL.countDistinct(this.queryState.getSqlMainIdField()) : DSL.count(this.queryState.getSqlMainIdField());
        }
        SelectConditionStep<Record1<Integer>> query = dslContext.select(count).from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)query.getSQL(ParamType.INDEXED));
        }
        return query;
    }

    public ResultQuery<Record1<Integer>> buildCount(int limit) {
        SelectSelectStep<Record> subSelect;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            Set<Field> sqlSelectFields = this.queryState.getSqlSelectFields();
            subSelect = DSL.selectDistinct((SelectFieldOrAsterisk[])sqlSelectFields.toArray(Field[]::new));
        } else {
            subSelect = this.queryState.isDistinctRequired() ? DSL.selectDistinct(this.queryState.getSqlMainIdField()) : DSL.select(this.queryState.getSqlMainIdField());
        }
        SelectLimitPercentStep selectFromWhere = subSelect.from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere()).limit(limit);
        SelectJoinStep<Record1<Integer>> query = dslContext.selectCount().from((TableLike<?>)selectFromWhere);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)query.getSQL(ParamType.INDEXED));
        }
        return query;
    }

    public CountSampleResult buildEstimateCountSample() {
        ResultQuery<Record1<Integer>> baseQuery = this.buildCount();
        String queryString = baseQuery.getSQL(ParamType.INLINED);
        String extendedQuery = RegExUtils.replaceFirst(queryString, TABLE_SEARCH_PATTERN, TABLESAMPLE_REPLACE_REGEX);
        int replaces = (extendedQuery.length() - queryString.length()) / " tablesample system (1)".length();
        DSLContext dslContext = this.pm.getDslContext();
        ResultQuery<Record> query = dslContext.resultQuery(extendedQuery);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)extendedQuery);
        }
        return new CountSampleResult(query, replaces);
    }

    public ResultQuery<Record1<Integer>> buildEstimateCountExplain() {
        SelectSelectStep<Record> select;
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        if (this.staQuery != null && this.staQuery.isSelectDistinct()) {
            Set<Field> sqlSelectFields = this.queryState.getSqlSelectFields();
            select = dslContext.selectDistinct((SelectFieldOrAsterisk[])sqlSelectFields.toArray(Field[]::new));
        } else {
            select = this.queryState.isDistinctRequired() ? dslContext.selectDistinct(this.queryState.getSqlMainIdField()) : dslContext.select(this.queryState.getSqlMainIdField());
        }
        String selectQuery = select.from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere()).getSQL(ParamType.INLINED);
        Field<Integer> countField = DSL.field("count_estimate({0})", SQLDataType.INTEGER, selectQuery);
        SelectSelectStep<Record1<Integer>> countQuery = dslContext.select(countField);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)countQuery.getSQL(ParamType.INDEXED));
        }
        return countQuery;
    }

    public Delete buildDelete(PathElementEntitySet set) {
        this.gatherData();
        DSLContext dslContext = this.pm.getDslContext();
        StaMainTable<?> table = this.tableCollection.getTablesByType().get(set.getEntityType());
        if (table == null) {
            throw new AssertionError("Don't know how to delete" + set.getEntityType().entityName, new IllegalArgumentException("Unknown type for delete"));
        }
        SelectConditionStep idSelect = DSL.select(this.queryState.getSqlMainIdField()).from((TableLike<?>)this.queryState.getSqlFrom()).where(this.queryState.getSqlWhere());
        DeleteConditionStep delete = dslContext.deleteFrom(table).where(table.getId().in(idSelect));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(GENERATED_SQL, (Object)delete.getSQL(ParamType.INDEXED));
        }
        return delete;
    }

    public QueryBuilder forTypeAndId(EntityType entityType, Id id2) {
        if (this.forPath || this.forTypeAndId) {
            throw new IllegalStateException("QueryBuilder already used.");
        }
        this.forTypeAndId = true;
        this.requestedEntityType = entityType;
        this.requestedId = id2;
        return this;
    }

    public QueryBuilder forPath(ResourcePath path) {
        if (this.forPath || this.forTypeAndId) {
            throw new IllegalStateException("QueryBuilder already used.");
        }
        this.forPath = true;
        this.requestedPath = path;
        this.requestedEntityType = path.getMainElementType();
        return this;
    }

    public QueryBuilder forUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    public QueryBuilder usingQuery(Query query) {
        this.staQuery = query;
        return this;
    }

    private void gatherData() {
        if (!this.parsed) {
            this.parsed = true;
            this.findSelectedProperties(this.staQuery);
            if (this.forPath) {
                this.parsePath();
            }
            if (this.forTypeAndId) {
                this.parseTypeAndId();
            }
            this.mainTable.clearJoins();
            this.parseFilter(this.staQuery);
            this.parseOrder(this.staQuery);
        }
    }

    private void parsePath() {
        int count = this.requestedPath.size();
        for (int i2 = count - 1; i2 >= 0; --i2) {
            PathElement element = this.requestedPath.get(i2);
            element.visit(this);
        }
    }

    private void parseTypeAndId() {
        this.lastPath = this.queryEntityType(new PathElementEntity(this.requestedEntityType, null), this.requestedId, this.lastPath);
        this.single = true;
    }

    private void findSelectedProperties(Query query) {
        this.selectedProperties = new HashSet<Property>();
        if (query == null) {
            return;
        }
        for (Property property : query.getSelect()) {
            if (property instanceof NavigationPropertyMain) {
                this.selectedProperties.add(this.requestedEntityType.getPrimaryKey());
            }
            this.selectedProperties.add(property);
        }
        if (query.isPkOrder() && !query.isSelectDistinct() && !this.selectedProperties.isEmpty()) {
            this.selectedProperties.add(this.requestedEntityType.getPrimaryKey());
        }
        if (!query.getExpand().isEmpty() && !this.selectedProperties.isEmpty()) {
            this.selectedProperties.add(this.requestedEntityType.getPrimaryKey());
            for (Expand expand : query.getExpand()) {
                NavigationProperty expandPath = expand.getPath();
                if (expandPath == null) continue;
                this.selectedProperties.add(expandPath);
            }
        }
    }

    private void parseOrder(Query query) {
        if (query != null) {
            PgExpressionHandler handler = new PgExpressionHandler(this.coreSettings, this, this.mainTable);
            for (OrderBy ob2 : query.getOrderBy()) {
                handler.addOrderbyToQuery(ob2, this.queryState.getSqlSortFields());
            }
        }
    }

    public void parseFilter(Query query) {
        if (query != null) {
            this.queryState.setFilter(true);
            Expression filter = query.getFilter();
            Expression skipFilter = query.getSkipFilter();
            PgExpressionHandler handler = new PgExpressionHandler(this.coreSettings, this, this.mainTable);
            if (filter != null) {
                this.queryState.setSqlWhere(handler.addFilterToWhere(filter, this.queryState.getSqlWhere()));
            }
            if (skipFilter != null) {
                this.queryState.setSqlSkipWhere(handler.addFilterToWhere(skipFilter, this.queryState.getSqlSkipWhere()));
            }
        }
    }

    @Override
    public void visit(PathElementEntity element) {
        this.lastPath = this.queryEntityType(element, element.getId(), this.lastPath);
    }

    @Override
    public void visit(PathElementEntitySet element) {
        this.lastPath = this.queryEntityType(element, null, this.lastPath);
    }

    @Override
    public void visit(PathElementProperty element) {
        this.selectedProperties.add(element.getProperty());
    }

    @Override
    public void visit(PathElementCustomProperty element) {
    }

    @Override
    public void visit(PathElementArrayIndex element) {
    }

    public TableRef queryEntityType(PathElementEntityType pe2, Id targetId, TableRef last) {
        TableRef result;
        TableRef existingJoin;
        EntityType entityType = pe2.getEntityType();
        if (last != null && (existingJoin = last.getJoin(entityType)) != null) {
            return existingJoin;
        }
        if (last == null) {
            StaTable tableForType = this.tableCollection.getTableForType(entityType).as(DEFAULT_PREFIX);
            this.queryState = new QueryState<StaTable>(tableForType, tableForType.getPropertyFieldRegistry().getFieldsForProperties(this.selectedProperties));
            result = QueryBuilder.createJoinedRef(null, entityType, tableForType);
        } else {
            result = entityType.equals(last.getType()) && this.lastNavProp == null ? last : last.createJoin(this.lastNavProp.getInverse().getName(), this.queryState);
        }
        if (targetId != null) {
            Object id2 = targetId.asBasicPersistenceType();
            this.queryState.setSqlWhere(this.queryState.getSqlWhere().and(result.getTable().getId().eq(id2)));
        }
        if (this.mainTable == null) {
            this.mainTable = result;
        }
        this.lastNavProp = pe2.getNavigationProperty();
        return result;
    }

    public TableRef queryEntityType(NavigationProperty np2, TableRef last) {
        if (this.mainTable == null) {
            throw new IllegalStateException("mainTable should not be null");
        }
        if (last == null) {
            throw new IllegalStateException("last result should not be null");
        }
        EntityType entityType = np2.getEntityType();
        TableRef existingJoin = last.getJoin(entityType);
        if (existingJoin != null) {
            return existingJoin;
        }
        if (entityType.equals(last.getType()) && np2 instanceof PathElementEntity && ((PathElementEntity)((Object)np2)).getId() != null) {
            return last;
        }
        return last.createJoin(np2.getName(), this.queryState);
    }

    public TableRef queryEntityType(EntityType targetType, TableRef sourceRef, Field sourceIdField) {
        StaMainTable<?> target = this.tableCollection.getTablesByType().get(targetType);
        StaTable targetAliased = target.as(this.queryState.getNextAlias());
        Field targetField = targetAliased.getId();
        this.queryState.setSqlFrom(this.queryState.getSqlFrom().innerJoin(targetAliased).on(targetField.eq(sourceIdField)));
        return QueryBuilder.createJoinedRef(sourceRef, targetType, targetAliased);
    }

    public TableCollection getTableCollection() {
        return this.tableCollection;
    }

    public static TableRef createJoinedRef(TableRef base, EntityType type, StaMainTable<?> table) {
        TableRef newRef = new TableRef(type, table);
        if (base != null) {
            base.addJoin(type, newRef);
        }
        return newRef;
    }

    public static final class CountSampleResult {
        public final ResultQuery<Record> countQuery;
        public final int sampledTables;

        public CountSampleResult(ResultQuery<Record> countQuery, int sampledTables) {
            this.countQuery = countQuery;
            this.sampledTables = sampledTables;
        }
    }
}

