/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.AbstractSubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionFactory;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;

public class EntitySubscription
extends AbstractSubscription {
    private Query emptyQuery;
    private Predicate<? super Entity> matcher;

    public EntitySubscription(CoreSettings settings, String topic, ResourcePath path) {
        super(topic, path, settings);
        this.init();
    }

    private void init() {
        this.emptyQuery = new Query(this.modelRegistry, this.queryDefaults, this.path).validate();
        if (!SubscriptionFactory.getQueryFromTopic(this.topic).isEmpty()) {
            throw new IllegalArgumentException("Invalid subscription to: '" + this.topic + "': query options not allowed for subscription on an entity.");
        }
        this.entityType = ((PathElementEntity)this.path.getLastElement()).getEntityType();
        int size = this.path.size();
        if (size == 2 && this.path.get(0) instanceof PathElementEntitySet) {
            Id id2 = ((PathElementEntity)this.path.getLastElement()).getId();
            this.matcher = x2 -> x2.getProperty(this.entityType.getPrimaryKey()).equals(id2);
        }
        this.generateFilter(1);
    }

    @Override
    public boolean matches(PersistenceManager persistenceManager, Entity newEntity, Set<Property> fields2) {
        if (this.matcher != null && !this.matcher.test(newEntity)) {
            return false;
        }
        return super.matches(persistenceManager, newEntity, fields2);
    }

    @Override
    public String doFormatMessage(Entity entity) throws IOException {
        try {
            entity.setQuery(this.emptyQuery);
            return this.settings.getFormatter(this.emptyQuery.getVersion(), "default").format(this.path, this.emptyQuery, entity, true).getFormatted();
        }
        catch (IncorrectRequestException ex2) {
            throw new IllegalArgumentException(ex2);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

