/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt;

import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttServer;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.MqttSettings;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttServerFactory.class);
    private static final String ERROR_MSG = "Could not generate MqttServer instance: ";
    private static final Map<String, String> RENAME = new HashMap<String, String>();
    private static MqttServerFactory instance;

    public static MqttServerFactory getInstance() {
        if (instance == null) {
            instance = new MqttServerFactory();
        }
        return instance;
    }

    private MqttServerFactory() {
    }

    public MqttServer get(CoreSettings settings) {
        MqttServer mqttServer = this.get(settings.getMqttSettings());
        if (mqttServer != null) {
            mqttServer.init(settings);
        }
        return mqttServer;
    }

    public MqttServer get(MqttSettings mqttSettings) {
        if (mqttSettings == null || !mqttSettings.isEnableMqtt()) {
            return null;
        }
        MqttServer mqttServer = null;
        try {
            Class<?> clazz;
            String mqttServerClassName = mqttSettings.getMqttServerImplementationClass();
            if (RENAME.containsKey(mqttServerClassName)) {
                String oldName = mqttServerClassName;
                mqttServerClassName = RENAME.get(mqttServerClassName);
                LOGGER.warn("Using MqttServerClass {} instead of old name {}", (Object)mqttServerClassName, (Object)oldName);
            }
            if (!MqttServer.class.isAssignableFrom(clazz = Class.forName(mqttServerClassName))) {
                throw new IllegalArgumentException("MqttImplementationClass must implement interface '" + MqttServer.class.getName() + "'");
            }
            mqttServer = (MqttServer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex2) {
            LOGGER.error("{} Class '{}' could not be found", ERROR_MSG, mqttSettings.getMqttServerImplementationClass(), ex2);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex3) {
            LOGGER.error("{} Class '{}' could not be instantiated", ERROR_MSG, mqttSettings.getMqttServerImplementationClass(), ex3);
        }
        return mqttServer;
    }

    static {
        RENAME.put("de.fraunhofer.iosb.ilt.sensorthingsserver.mqtt.moquette.MoquetteMqttServer", "de.fraunhofer.iosb.ilt.frostserver.mqtt.moquette.MoquetteMqttServer");
    }
}

