/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.loader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefNavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefValidator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigurableClass
public class DefEntityType
implements AnnotatedConfigurable<Void, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefEntityType.class.getName());
    @ConfigurableField(editor=EditorString.class, label="Name", description="The name of the Entity Type.")
    @EditorString.EdOptsString
    private String name;
    @ConfigurableField(editor=EditorString.class, label="Plural", description="The name to use for for sets of this entity type.")
    @EditorString.EdOptsString
    private String plural;
    @ConfigurableField(editor=EditorString.class, label="Table", description="The 'table' that data for this EntityType is stored in. What this exactly means depends on the PersistenceManager.")
    @EditorString.EdOptsString
    private String table;
    @ConfigurableField(editor=EditorList.class, label="EntityProps")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=DefEntityProperty.class)
    private List<DefEntityProperty> entityProperties;
    @ConfigurableField(editor=EditorList.class, label="NavProps")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=DefNavigationProperty.class)
    private List<DefNavigationProperty> navigationProperties;
    @ConfigurableField(editor=EditorList.class, optional=true, label="NavProps")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=DefValidator.class, merge=true, nameField="@class")
    private List<DefValidator> validators = new ArrayList<DefValidator>();
    @ConfigurableField(editor=EditorList.class, label="Annotations", description="The (OData)annotations for this Element.")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=Annotation.class, merge=true, nameField="@class")
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    @JsonIgnore
    private EntityType entityType;

    public void init() {
        for (DefEntityProperty defEntityProperty : this.getEntityProperties()) {
            defEntityProperty.init();
        }
        for (DefNavigationProperty defNavigationProperty : this.getNavigationProperties()) {
            defNavigationProperty.init();
        }
    }

    public EntityType getEntityType(ModelRegistry modelRegistry) {
        if (this.entityType == null) {
            this.entityType = modelRegistry.getEntityTypeForName(this.name);
            if (this.entityType == null) {
                this.entityType = new EntityType(this.name, this.plural);
            }
            for (DefValidator validator : this.validators) {
                validator.createValidators(modelRegistry, this.entityType);
            }
            this.entityType.addAnnotations(this.annotations);
        }
        return this.entityType;
    }

    public void linkProperties(ModelRegistry modelRegistry) {
        LOGGER.debug("  {} ({})", (Object)this.name, (Object)this.plural);
        for (DefEntityProperty defEp : this.entityProperties) {
            defEp.setEntityType(this.entityType);
            defEp.registerProperties(modelRegistry);
        }
        for (DefNavigationProperty defNp : this.navigationProperties) {
            defNp.setSourceEntityType(this.entityType);
            defNp.registerProperties(modelRegistry);
        }
    }

    public String getName() {
        return this.name;
    }

    public DefEntityType setName(String name) {
        this.name = name;
        return this;
    }

    public String getPlural() {
        return this.plural;
    }

    public DefEntityType setPlural(String plural) {
        this.plural = plural;
        return this;
    }

    public List<DefEntityProperty> getEntityProperties() {
        if (this.entityProperties == null) {
            this.entityProperties = new ArrayList<DefEntityProperty>();
        }
        return this.entityProperties;
    }

    public DefEntityType setEntityProperties(List<DefEntityProperty> entityProperties) {
        this.entityProperties = entityProperties;
        return this;
    }

    public DefEntityType addEntityProperty(DefEntityProperty entityProperty) {
        this.getEntityProperties().add(entityProperty);
        return this;
    }

    public DefEntityProperty getPrimaryKey() {
        for (DefEntityProperty property : this.getEntityProperties()) {
            if (!"id".equalsIgnoreCase(property.getType())) continue;
            return property;
        }
        LOGGER.warn("No primary key defined for {}", (Object)this.getName());
        return null;
    }

    public List<DefNavigationProperty> getNavigationProperties() {
        if (this.navigationProperties == null) {
            this.navigationProperties = new ArrayList<DefNavigationProperty>();
        }
        return this.navigationProperties;
    }

    public DefEntityType setNavigationProperties(List<DefNavigationProperty> navigationProperties) {
        this.navigationProperties = navigationProperties;
        return this;
    }

    public DefEntityType addNavigationProperty(DefNavigationProperty navigationProperty) {
        this.getNavigationProperties().add(navigationProperty);
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public DefEntityType setTable(String table) {
        this.table = table;
        return this;
    }

    public List<DefValidator> getValidators() {
        return this.validators;
    }

    public DefEntityType setValidators(List<DefValidator> validators) {
        this.validators = validators;
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public DefEntityType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public DefEntityType addAnnotations(List<Annotation> annotations) {
        this.annotations.addAll(annotations);
        return this;
    }
}

