/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.ext;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.fraunhofer.iosb.ilt.frostserver.property.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.util.Objects;

public class UnitOfMeasurement
implements ComplexValue {
    private String name;
    private String symbol;
    private String definition;

    public UnitOfMeasurement() {
    }

    public UnitOfMeasurement(String name, String symbol, String definition) {
        this.name = name;
        this.symbol = symbol;
        this.definition = definition;
    }

    @Override
    public Object get(String name) {
        switch (name) {
            case "name": {
                return this.getName();
            }
            case "symbol": {
                return this.getSymbol();
            }
            case "definition": {
                return this.getDefinition();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDefinition() {
        return this.definition;
    }

    public UnitOfMeasurement setName(String name) {
        this.name = name;
        return this;
    }

    public UnitOfMeasurement setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public UnitOfMeasurement setDefinition(String definition) {
        this.definition = definition;
        return this;
    }

    public String toString() {
        try {
            return SimpleJsonMapper.getSimpleObjectMapper().writeValueAsString(this);
        }
        catch (JsonProcessingException ex2) {
            return super.toString();
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.symbol, this.definition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitOfMeasurement other = (UnitOfMeasurement)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.symbol, other.symbol)) {
            return false;
        }
        return Objects.equals(this.definition, other.definition);
    }
}

