/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.ext;

import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.text.ParseException;
import java.util.Objects;
import net.time4j.Moment;
import net.time4j.SystemClock;
import net.time4j.format.expert.Iso8601Format;

public class TimeInstant
implements TimeObject {
    private final Moment dateTime;

    public TimeInstant(Moment dateTime) {
        this.dateTime = dateTime;
    }

    public static TimeInstant now() {
        return new TimeInstant(SystemClock.currentMoment());
    }

    public int hashCode() {
        return Objects.hash(this.dateTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInstant other = (TimeInstant)obj;
        if (this.dateTime == null && other.dateTime == null) {
            return true;
        }
        if (this.dateTime == null || other.dateTime == null) {
            return false;
        }
        return this.dateTime.equals(other.dateTime);
    }

    public static TimeInstant parse(String value) {
        try {
            return new TimeInstant(Iso8601Format.EXTENDED_DATE_TIME_OFFSET.parse(value));
        }
        catch (ParseException ex2) {
            throw new IllegalArgumentException("Failed to parse TimeInstant " + StringHelper.cleanForLogging(value), ex2);
        }
    }

    public Moment getDateTime() {
        return this.dateTime;
    }

    @Override
    public boolean isEmpty() {
        return this.dateTime == null;
    }

    @Override
    public String asISO8601() {
        if (this.dateTime == null) {
            return "";
        }
        return StringHelper.FORMAT_MOMENT.print(this.dateTime);
    }

    public String toString() {
        return this.asISO8601();
    }
}

