/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;

public class IdUuid
implements Id {
    public static final String PERSISTENCE_TYPE_BYTEARRAY = "BYTEARRAY";
    private UUID value;

    public IdUuid(UUID value) {
        this.value = value;
    }

    public IdUuid(String value) {
        this.value = UUID.fromString(value);
    }

    @Override
    public String getBasicPersistenceType() {
        return PERSISTENCE_TYPE_BYTEARRAY;
    }

    @Override
    public Object asBasicPersistenceType() {
        return this.value;
    }

    @Override
    public void fromBasicPersitenceType(Object data) {
        this.value = data instanceof UUID ? (UUID)data : UUID.fromString(data.toString());
    }

    @Override
    public UUID getValue() {
        return this.value;
    }

    @Override
    public String getUrl() {
        return "'" + this.value.toString() + "'";
    }

    @Override
    public String getJson() {
        return "\"" + StringEscapeUtils.escapeJson(this.value.toString()) + "\"";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdUuid other = (IdUuid)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return Objects.toString(this.getValue());
    }
}

