/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model;

import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntityValidator;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.core.IdLong;
import de.fraunhofer.iosb.ilt.frostserver.model.core.IdString;
import de.fraunhofer.iosb.ilt.frostserver.model.core.IdUuid;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityType
implements Annotatable,
Comparable<EntityType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityType.class.getName());
    public final String entityName;
    public final String plural;
    private boolean initialised = false;
    private EntityPropertyMain primaryKey;
    private final Map<Property, Boolean> propertyMap = new LinkedHashMap<Property, Boolean>();
    private final Map<String, Property> propertiesByName = new LinkedHashMap<String, Property>();
    private final Set<EntityPropertyMain> entityProperties = new LinkedHashSet<EntityPropertyMain>();
    private final Set<NavigationPropertyMain> navigationProperties = new LinkedHashSet<NavigationPropertyMain>();
    private final Set<NavigationPropertyMain<Entity>> navigationEntities = new LinkedHashSet<NavigationPropertyMain<Entity>>();
    private final Set<NavigationPropertyMain<EntitySet>> navigationSets = new LinkedHashSet<NavigationPropertyMain<EntitySet>>();
    private final Map<EntityType, NavigationPropertyMain> navigationPropertiesByTarget = new HashMap<EntityType, NavigationPropertyMain>();
    private final Map<String, EntityValidator> validatorsCreateEntity = new LinkedHashMap<String, EntityValidator>();
    private final Map<String, EntityValidator> validatorsUpdateEntity = new LinkedHashMap<String, EntityValidator>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private ModelRegistry modelRegistry;

    public EntityType(String singular, String plural) {
        this.entityName = singular;
        this.plural = plural;
    }

    public EntityType registerProperty(Property property, boolean required) {
        this.propertyMap.put(property, required);
        this.propertiesByName.put(property.getName(), property);
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain propertyMain = (EntityPropertyMain)property;
            for (String alias : propertyMain.getAliases()) {
                this.propertiesByName.put(alias, property);
            }
            if (this.primaryKey == null) {
                this.primaryKey = propertyMain;
            }
        }
        return this;
    }

    public void init() {
        if (this.initialised) {
            LOGGER.error("Re-Init of EntityType!");
        }
        this.initialised = true;
        for (Property property : this.propertyMap.keySet()) {
            if (property instanceof EntityPropertyMain) {
                this.entityProperties.add((EntityPropertyMain)property);
            }
            if (!(property instanceof NavigationPropertyMain)) continue;
            NavigationPropertyMain np2 = (NavigationPropertyMain)property;
            if (np2.getEntityType() == null) {
                np2.setEntityType(this.modelRegistry.getEntityTypeForName(np2.getName()));
            }
            this.navigationProperties.add(np2);
            if (np2.isEntitySet()) {
                this.navigationSets.add(np2);
            } else {
                this.navigationEntities.add(np2);
            }
            this.navigationPropertiesByTarget.put(np2.getEntityType(), np2);
        }
    }

    @Deprecated(forRemoval=true)
    public EntityType addValidator(EntityValidator validator) {
        return this.addValidatorForCreate(validator);
    }

    @Deprecated(forRemoval=true)
    public EntityType addValidatorForCreate(EntityValidator validator) {
        int count = this.validatorsCreateEntity.size() + 1;
        while (this.validatorsCreateEntity.containsKey(Integer.toString(count))) {
            ++count;
        }
        return this.addCreateValidator(Integer.toString(count), validator);
    }

    public EntityType addCreateValidator(String name, EntityValidator validator) {
        EntityValidator value = this.validatorsCreateEntity.putIfAbsent(name, validator);
        if (value != null) {
            throw new IllegalArgumentException("A CreateValidator for " + this.entityName + " already exists with name " + name);
        }
        return this;
    }

    public Map<String, EntityValidator> getCreateValidators() {
        return Collections.unmodifiableMap(this.validatorsCreateEntity);
    }

    public EntityValidator removeCreateValidator(String name) {
        return this.validatorsCreateEntity.remove(name);
    }

    @Deprecated(forRemoval=true)
    public EntityType addValidatorForUpdate(EntityValidator validator) {
        int count = this.validatorsUpdateEntity.size() + 1;
        while (this.validatorsUpdateEntity.containsKey(Integer.toString(count))) {
            ++count;
        }
        return this.addUpdateValidator(Integer.toString(count), validator);
    }

    public EntityType addUpdateValidator(String name, EntityValidator validator) {
        EntityValidator value = this.validatorsUpdateEntity.putIfAbsent(name, validator);
        if (value != null) {
            throw new IllegalArgumentException("An UpdateValidator for " + this.entityName + " already exists with name " + name);
        }
        return this;
    }

    public Map<String, EntityValidator> getUpdateValidators() {
        return Collections.unmodifiableMap(this.validatorsUpdateEntity);
    }

    public EntityValidator removeUpdateValidator(String name) {
        return this.validatorsUpdateEntity.remove(name);
    }

    public EntityPropertyMain<Id> getPrimaryKey() {
        return this.primaryKey;
    }

    public Property getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    public EntityPropertyMain getEntityProperty(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof EntityPropertyMain) {
            return (EntityPropertyMain)property;
        }
        return null;
    }

    public NavigationPropertyMain getNavigationProperty(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof NavigationPropertyMain) {
            return (NavigationPropertyMain)property;
        }
        return null;
    }

    public Set<Property> getPropertySet() {
        return this.propertyMap.keySet();
    }

    public Set<EntityPropertyMain> getEntityProperties() {
        return this.entityProperties;
    }

    public Set<NavigationPropertyMain> getNavigationProperties() {
        return this.navigationProperties;
    }

    public Set<NavigationPropertyMain<Entity>> getNavigationEntities() {
        return this.navigationEntities;
    }

    public Set<NavigationPropertyMain<EntitySet>> getNavigationSets() {
        return this.navigationSets;
    }

    public NavigationPropertyMain getNavigationProperty(EntityType to) {
        return this.navigationPropertiesByTarget.get(to);
    }

    public boolean isRequired(Property property) {
        return this.propertyMap.getOrDefault(property, false);
    }

    public void complete(Entity entity, boolean entityPropertiesOnly) throws IncompleteEntityException {
        for (Property property : this.getPropertySet()) {
            if (entityPropertiesOnly && !(property instanceof EntityPropertyMain) || !this.isRequired(property) || entity.isSetProperty(property)) continue;
            throw new IncompleteEntityException("Missing required property '" + property.getJsonName() + "'");
        }
        for (EntityValidator validator : this.validatorsCreateEntity.values()) {
            validator.validate(entity, entityPropertiesOnly);
        }
    }

    public void complete(Entity entity, PathElementEntitySet containingSet) throws IncompleteEntityException {
        EntityType type = containingSet.getEntityType();
        if (type != entity.getEntityType()) {
            throw new IllegalArgumentException("Set of type " + type + " can not contain a " + entity.getEntityType());
        }
        this.checkParent(containingSet, entity);
        this.complete(entity, false);
    }

    public void validateUpdate(Entity entity) throws IncompleteEntityException {
        for (EntityValidator validator : this.validatorsUpdateEntity.values()) {
            validator.validate(entity, false);
        }
    }

    private void checkParent(PathElementEntitySet containingSet, Entity entity) throws IncompleteEntityException {
        PathElement parent = containingSet.getParent();
        if (parent instanceof PathElementEntity) {
            PathElementEntity parentEntity = (PathElementEntity)parent;
            Id parentId = parentEntity.getId();
            if (parentId == null) {
                return;
            }
            this.checkParent(entity, containingSet.getNavigationProperty().getInverse(), parentId);
        }
    }

    private void checkParent(Entity entity, NavigationPropertyMain navPropToParent, Id parentId) throws IncompleteEntityException {
        if (navPropToParent == null) {
            LOGGER.error("Incorrect 'parent' entity type for {}: {}", (Object)this.entityName, (Object)navPropToParent);
            throw new IncompleteEntityException("Incorrect 'parent' entity type for " + this.entityName + ": " + navPropToParent);
        }
        EntityType parentType = navPropToParent.getEntityType();
        if (navPropToParent.isEntitySet()) {
            entity.addNavigationEntity(new DefaultEntity(parentType).setId(parentId));
        } else {
            entity.setProperty(navPropToParent, new DefaultEntity(parentType).setId(parentId));
        }
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public void setModelRegistry(ModelRegistry modelRegistry) {
        if (this.modelRegistry != null && this.modelRegistry != modelRegistry) {
            throw new IllegalArgumentException("Changing the ModelRegistry on an EntityType is not allowed.");
        }
        this.modelRegistry = modelRegistry;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public EntityType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public EntityType addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public String toString() {
        return this.entityName;
    }

    @Override
    public int compareTo(EntityType o2) {
        return this.entityName.compareTo(o2.entityName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityType)) {
            return false;
        }
        EntityType other = (EntityType)obj;
        if (this.entityName.equals(other.entityName)) {
            LOGGER.error("Found other instance of {}", (Object)this.entityName);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.entityName);
        return hash;
    }

    public Id parsePrimaryKey(String input) {
        Object rawId = this.primaryKey.getType().parseFromUrl(input);
        if (rawId instanceof UUID) {
            return new IdUuid((UUID)rawId);
        }
        if (rawId instanceof Number) {
            return new IdLong(((Number)rawId).longValue());
        }
        if (rawId instanceof CharSequence) {
            return new IdString(rawId.toString());
        }
        throw new IllegalArgumentException("Can not use " + (rawId == null ? "null" : rawId.getClass().getName()) + " (" + input + ") as an Id");
    }
}

