/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geojson.GeoJsonObject;

public class GeoJsonDeserializier
implements CustomDeserializer {
    public static final String APPLICATION_GEOJSON = "application/geo+json";
    public static final Set<String> ENCODINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/geo+json", "application/vnd.geo+json")));

    public Object deserialize(String json) throws IOException {
        return SimpleJsonMapper.getSimpleObjectMapper().readValue(json, GeoJsonObject.class);
    }

    @Override
    public Object deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        return parser.readValueAs(GeoJsonObject.class);
    }

    @Override
    public Object deserialize(TreeNode json) throws IOException {
        return SimpleJsonMapper.getSimpleObjectMapper().treeToValue(json, GeoJsonObject.class);
    }
}

